/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Libraries.Java;

import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;

public class ReikaEncryptionHelper {
    public static <O> boolean isEncryptedMatch(O s, Encrypter<O> e, O ... parts) {
        return s.equals(e.encryptInto(parts));
    }

    public static final class ShiftEncrypter
    implements Encrypter<String> {
        public String encryptInto(String ... parts) {
            char[] chars = new char[ReikaStringParser.getLongestString(parts).length()];
            for (int i = 0; i < parts.length; ++i) {
                String s = parts[i];
                for (int k = 0; k < s.length(); ++k) {
                    char c = s.charAt(k);
                    chars[k] = (char)ReikaMathLibrary.addAndRollover(chars[k], c, 32, 126);
                    chars[k] = (char)ReikaMathLibrary.addAndRollover(chars[k], s.length(), 32, 126);
                }
            }
            return new String(chars);
        }
    }

    public static final class MorphEncrypter
    implements Encrypter<String> {
        public String encryptInto(String ... parts) {
            char[] chars = new char[ReikaStringParser.getLongestString(parts).length()];
            System.arraycopy(parts[0].toCharArray(), 0, chars, 0, parts[0].length());
            for (int i = 1; i < parts.length; ++i) {
                String s = parts[i];
                for (int k = 0; k < s.length(); ++k) {
                    char c = s.charAt(k);
                    int d = c - chars[k];
                    if (d == 0) continue;
                    chars[k] = (char)ReikaMathLibrary.addAndRollover(chars[k], d / 2, 32, 126);
                }
            }
            return new String(chars);
        }
    }

    public static final class SpliceEncrypter
    implements Encrypter<String> {
        public String encryptInto(String ... parts) {
            boolean action;
            StringBuilder sb = new StringBuilder();
            int idx = 0;
            do {
                action = false;
                for (int i = 0; i < parts.length; ++i) {
                    if (idx >= parts.length) continue;
                    sb.append(parts[i].charAt(idx));
                    action = true;
                }
                ++idx;
            } while (action);
            return sb.toString();
        }
    }

    public static final class AdditiveEncrypter
    implements Encrypter<String> {
        public String encryptInto(String ... parts) {
            char[] chars = new char[ReikaStringParser.getLongestString(parts).length()];
            for (int i = 0; i < parts.length; ++i) {
                String s = parts[i];
                for (int k = 0; k < s.length(); ++k) {
                    char c = s.charAt(k);
                    chars[k] = (char)ReikaMathLibrary.addAndRollover(chars[k], c, 32, 126);
                }
            }
            return new String(chars);
        }
    }

    public static interface Encrypter<O> {
        public O encryptInto(O ... var1);
    }
}

