/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Worldgen;

import Reika.DragonAPI.Libraries.Registry.ReikaTreeHelper;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class ModifiableBigTree
extends WorldGenAbstractTree {
    private static final byte[] otherCoordPairs = new byte[]{2, 0, 0, 1, 2, 1};
    protected final Random rand = new Random();
    private int[] basePos = new int[]{0, 0, 0};
    private int heightLimit;
    private int height;
    private double heightAttenuation = 0.618;
    private double branchDensity = 1.0;
    private double branchSlope = 0.381;
    private double scaleWidth = 1.0;
    private double leafDensity = 1.0;
    private int trunkSize = 1;
    private int heightLimitLimit = 12;
    private int leafDistanceLimit = 4;
    private int[][] leafNodes;

    public ModifiableBigTree(boolean updates) {
        super(updates);
    }

    private void generateLeafNodeList(World world) {
        int i;
        this.height = (int)((double)this.heightLimit * this.heightAttenuation);
        if (this.height >= this.heightLimit) {
            this.height = this.heightLimit - 1;
        }
        if ((i = (int)(1.382 + Math.pow(this.leafDensity * (double)this.heightLimit / 13.0, 2.0))) < 1) {
            i = 1;
        }
        int[][] aint = new int[i * this.heightLimit][4];
        int j = this.basePos[1] + this.heightLimit - this.leafDistanceLimit;
        int k = 1;
        int l = this.basePos[1] + this.height;
        int i1 = j - this.basePos[1];
        aint[0][0] = this.basePos[0];
        aint[0][1] = j--;
        aint[0][2] = this.basePos[2];
        aint[0][3] = l;
        while (i1 >= 0) {
            float f = this.layerSize(i1);
            if (f < 0.0f) {
                --j;
                --i1;
                continue;
            }
            double d0 = 0.5;
            for (int j1 = 0; j1 < i; ++j1) {
                int[] aint2;
                int l1;
                double d2;
                double d1 = this.scaleWidth * (double)f * ((double)this.rand.nextFloat() + 0.328);
                int k1 = MathHelper.func_76128_c((double)(d1 * Math.sin(d2 = (double)this.rand.nextFloat() * 2.0 * Math.PI) + (double)this.basePos[0] + d0));
                int[] aint1 = new int[]{k1, j, l1 = MathHelper.func_76128_c((double)(d1 * Math.cos(d2) + (double)this.basePos[2] + d0))};
                if (this.checkBlockLine(world, aint1, aint2 = new int[]{k1, j + this.leafDistanceLimit, l1}) != -1) continue;
                int[] aint3 = new int[]{this.basePos[0], this.basePos[1], this.basePos[2]};
                double d3 = Math.sqrt(Math.pow(Math.abs(this.basePos[0] - aint1[0]), 2.0) + Math.pow(Math.abs(this.basePos[2] - aint1[2]), 2.0));
                double d4 = d3 * this.branchSlope;
                aint3[1] = (double)aint1[1] - d4 > (double)l ? l : (int)((double)aint1[1] - d4);
                if (this.checkBlockLine(world, aint3, aint1) != -1) continue;
                aint[k][0] = k1;
                aint[k][1] = j;
                aint[k][2] = l1;
                aint[k][3] = aint3[1];
                ++k;
            }
            --j;
            --i1;
        }
        this.leafNodes = new int[k][4];
        System.arraycopy(aint, 0, this.leafNodes, 0, k);
    }

    private void func_150529_a(World world, int x, int y, int z, float p_150529_4_, byte p_150529_5_) {
        int l = (int)((double)p_150529_4_ + 0.618);
        byte b1 = otherCoordPairs[p_150529_5_];
        byte b2 = otherCoordPairs[p_150529_5_ + 3];
        int[] pos1 = new int[]{x, y, z};
        int[] pos2 = new int[]{0, 0, 0};
        int j1 = -l;
        pos2[p_150529_5_] = pos1[p_150529_5_];
        for (int i1 = -l; i1 <= l; ++i1) {
            pos2[b1] = pos1[b1] + i1;
            j1 = -l;
            while (j1 <= l) {
                double d0 = Math.pow((double)Math.abs(i1) + 0.5, 2.0) + Math.pow((double)Math.abs(j1) + 0.5, 2.0);
                if (d0 > (double)(p_150529_4_ * p_150529_4_)) {
                    ++j1;
                    continue;
                }
                pos2[b2] = pos1[b2] + j1;
                Block block1 = world.func_147439_a(pos2[0], pos2[1], pos2[2]);
                if (!block1.isAir((IBlockAccess)world, pos2[0], pos2[1], pos2[2]) && !block1.isLeaves((IBlockAccess)world, pos2[0], pos2[1], pos2[2])) {
                    ++j1;
                    continue;
                }
                this.func_150516_a(world, pos2[0], pos2[1], pos2[2], this.getLeafBlock(pos2[0], pos2[1], pos2[2]), this.getLeafMetadata(pos2[0], pos2[1], pos2[2]));
                ++j1;
            }
        }
    }

    public Block getLogBlock(int x, int y, int z) {
        return ReikaTreeHelper.OAK.getLogID();
    }

    public int getLogMetadata(int x, int y, int z) {
        return ReikaTreeHelper.OAK.getBaseLogMeta();
    }

    public Block getLeafBlock(int x, int y, int z) {
        return ReikaTreeHelper.OAK.getLeafID();
    }

    public int getLeafMetadata(int x, int y, int z) {
        return ReikaTreeHelper.OAK.getBaseLeafMeta();
    }

    private float layerSize(int layer) {
        if ((double)layer < (double)this.heightLimit * 0.3) {
            return -1.618f;
        }
        float f = (float)this.heightLimit / 2.0f;
        float f1 = (float)this.heightLimit / 2.0f - (float)layer;
        float f2 = f1 == 0.0f ? f : (Math.abs(f1) >= f ? 0.0f : (float)Math.sqrt(Math.pow(Math.abs(f), 2.0) - Math.pow(Math.abs(f1), 2.0)));
        return f2 *= 0.5f;
    }

    private float leafSize(int p_76495_1_) {
        return p_76495_1_ >= 0 && p_76495_1_ < this.leafDistanceLimit ? (p_76495_1_ != 0 && p_76495_1_ != this.leafDistanceLimit - 1 ? 3.0f : 2.0f) : -1.0f;
    }

    private void generateLeafNode(World world, int x, int y, int z) {
        int i1 = y + this.leafDistanceLimit;
        for (int l = y; l < i1; ++l) {
            float f = this.leafSize(l - y);
            this.func_150529_a(world, x, l, z, f, (byte)1);
        }
    }

    private void func_150530_a(World world, int[] pos1, int[] pos2) {
        int[] aint2 = new int[]{0, 0, 0};
        int b1 = 0;
        for (int b0 = 0; b0 < 3; b0 = (int)((byte)(b0 + 1))) {
            aint2[b0] = pos2[b0] - pos1[b0];
            if (Math.abs(aint2[b0]) <= Math.abs(aint2[b1])) continue;
            b1 = b0;
        }
        if (aint2[b1] != 0) {
            byte b2 = otherCoordPairs[b1];
            byte b3 = otherCoordPairs[b1 + 3];
            int b4 = aint2[b1] > 0 ? 1 : -1;
            double d0 = (double)aint2[b2] / (double)aint2[b1];
            double d1 = (double)aint2[b3] / (double)aint2[b1];
            int[] pos3 = new int[]{0, 0, 0};
            int j = aint2[b1] + b4;
            for (int i = 0; i != j; i += b4) {
                int l;
                pos3[b1] = MathHelper.func_76128_c((double)((double)(pos1[b1] + i) + 0.5));
                pos3[b2] = MathHelper.func_76128_c((double)((double)pos1[b2] + (double)i * d0 + 0.5));
                pos3[b3] = MathHelper.func_76128_c((double)((double)pos1[b3] + (double)i * d1 + 0.5));
                byte b5 = (byte)this.getLogMetadata(pos3[0], pos3[1], pos3[2]);
                int k = Math.abs(pos3[0] - pos1[0]);
                int i1 = Math.max(k, l = Math.abs(pos3[2] - pos1[2]));
                if (i1 > 0) {
                    if (k == i1) {
                        b5 = (byte)(b5 + 4);
                    } else if (l == i1) {
                        b5 = (byte)(b5 + 8);
                    }
                }
                this.func_150516_a(world, pos3[0], pos3[1], pos3[2], this.getLogBlock(pos3[0], pos3[1], pos3[2]), b5);
            }
        }
    }

    private void generateLeaves(World world) {
        int j = this.leafNodes.length;
        for (int i = 0; i < j; ++i) {
            int k = this.leafNodes[i][0];
            int l = this.leafNodes[i][1];
            int i1 = this.leafNodes[i][2];
            this.generateLeafNode(world, k, l, i1);
        }
    }

    private boolean leafNodeNeedsBase(int d) {
        return (double)d >= (double)this.heightLimit * 0.2;
    }

    private void generateTrunk(World world) {
        int i = this.basePos[0];
        int j = this.basePos[1];
        int k = this.basePos[1] + this.height;
        int l = this.basePos[2];
        int[] aint = new int[]{i, j, l};
        int[] aint1 = new int[]{i, k, l};
        this.func_150530_a(world, aint, aint1);
        if (this.trunkSize == 2) {
            aint[0] = aint[0] + 1;
            aint1[0] = aint1[0] + 1;
            this.func_150530_a(world, aint, aint1);
            aint[2] = aint[2] + 1;
            aint1[2] = aint1[2] + 1;
            this.func_150530_a(world, aint, aint1);
            aint[0] = aint[0] + -1;
            aint1[0] = aint1[0] + -1;
            this.func_150530_a(world, aint, aint1);
        }
    }

    private void generateLeafNodeBases(World world) {
        int j = this.leafNodes.length;
        int[] aint = new int[]{this.basePos[0], this.basePos[1], this.basePos[2]};
        for (int i = 0; i < j; ++i) {
            int[] aint1 = this.leafNodes[i];
            int[] aint2 = new int[]{aint1[0], aint1[1], aint1[2]};
            aint[1] = aint1[3];
            int k = aint[1] - this.basePos[1];
            if (!this.leafNodeNeedsBase(k)) continue;
            this.func_150530_a(world, aint, aint2);
        }
    }

    private int checkBlockLine(World world, int[] c1, int[] c2) {
        int i;
        int[] aint2 = new int[]{0, 0, 0};
        int b1 = 0;
        for (int b0 = 0; b0 < 3; b0 = (int)((byte)(b0 + 1))) {
            aint2[b0] = c2[b0] - c1[b0];
            if (Math.abs(aint2[b0]) <= Math.abs(aint2[b1])) continue;
            b1 = b0;
        }
        if (aint2[b1] == 0) {
            return -1;
        }
        byte b2 = otherCoordPairs[b1];
        byte b3 = otherCoordPairs[b1 + 3];
        int b4 = aint2[b1] > 0 ? 1 : -1;
        double d0 = (double)aint2[b2] / (double)aint2[b1];
        double d1 = (double)aint2[b3] / (double)aint2[b1];
        int[] aint3 = new int[]{0, 0, 0};
        int j = aint2[b1] + b4;
        for (i = 0; i != j; i += b4) {
            aint3[b1] = c1[b1] + i;
            aint3[b2] = MathHelper.func_76128_c((double)((double)c1[b2] + (double)i * d0));
            aint3[b3] = MathHelper.func_76128_c((double)((double)c1[b3] + (double)i * d1));
            Block block = world.func_147439_a(aint3[0], aint3[1], aint3[2]);
            if (!this.isReplaceable(world, aint3[0], aint3[1], aint3[2])) break;
        }
        return i == j ? -1 : Math.abs(i);
    }

    private boolean validTreeLocation(World world) {
        int[] aint = new int[]{this.basePos[0], this.basePos[1], this.basePos[2]};
        int[] aint1 = new int[]{this.basePos[0], this.basePos[1] + this.heightLimit - 1, this.basePos[2]};
        Block block = world.func_147439_a(this.basePos[0], this.basePos[1] - 1, this.basePos[2]);
        boolean isSoil = block.canSustainPlant((IBlockAccess)world, this.basePos[0], this.basePos[1] - 1, this.basePos[2], ForgeDirection.UP, (IPlantable)((BlockSapling)Blocks.field_150345_g));
        if (!isSoil) {
            return false;
        }
        int i = this.checkBlockLine(world, aint, aint1);
        if (i == -1) {
            return true;
        }
        if (i < 6) {
            return false;
        }
        this.heightLimit = i;
        return true;
    }

    public void func_76487_a(double h, double w, double d) {
        this.heightLimitLimit = (int)(h * 12.0);
        if (h > 0.5) {
            this.leafDistanceLimit = 5;
        }
        this.scaleWidth = w;
        this.leafDensity = d;
    }

    public boolean func_76484_a(World world, Random r, int x, int y, int z) {
        long l = r.nextLong();
        this.rand.setSeed(l);
        this.basePos[0] = x;
        this.basePos[1] = y;
        this.basePos[2] = z;
        if (this.heightLimit == 0) {
            this.heightLimit = 5 + this.rand.nextInt(this.heightLimitLimit);
        }
        if (!this.validTreeLocation(world)) {
            return false;
        }
        this.generateLeafNodeList(world);
        this.generateLeaves(world);
        this.generateTrunk(world);
        this.generateLeafNodeBases(world);
        return true;
    }
}

