/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable;

import Reika.DragonAPI.Libraries.MathSci.ReikaMusicHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class MusicScore {
    private final TreeMap<Integer, Collection<Note>>[] music;
    private final int channelCount;
    private int length;

    public MusicScore(int channels) {
        this.channelCount = channels;
        this.music = new TreeMap[channels];
    }

    public void addNote(int time, int channel, ReikaMusicHelper.MusicKey note, int voice, int vol, int len, boolean perc) {
        this.addNote(channel, time, new Note(note, voice, vol, len, perc));
    }

    private void addNote(int channel, int time, Note note) {
        Collection<Note> c;
        if (this.music[channel] == null) {
            this.music[channel] = new TreeMap();
        }
        if ((c = this.music[channel].get(time)) == null) {
            c = new ArrayList<Note>();
            this.music[channel].put(time, c);
        }
        c.add(note);
        this.length = Math.max(this.length, time);
    }

    public ArrayList<Note> getNotes(int time) {
        ArrayList<Note> li = new ArrayList<Note>();
        for (int i = 0; i < this.channelCount; ++i) {
            Collection<Note> n;
            Collection<Note> collection = n = this.music[i] != null ? this.music[i].get(time) : null;
            if (n == null) continue;
            li.addAll(n);
        }
        return li;
    }

    public Collection<Note> getNotes(int channel, int time) {
        Collection<Note> c = this.music[channel] != null ? this.music[channel].get(time) : null;
        return c != null ? Collections.unmodifiableCollection(c) : null;
    }

    public void backspace(int channel) {
        if (this.music[channel] != null && !this.music[channel].isEmpty()) {
            this.music[channel].remove(this.music[channel].lastKey());
        }
    }

    public Map<Integer, Collection<Note>> getTrack(int channel) {
        return this.music[channel] != null ? Collections.unmodifiableMap(this.music[channel]) : new HashMap<Integer, Collection<Note>>();
    }

    public int getLatestPos(int channel) {
        return this.music[channel] != null && !this.music[channel].isEmpty() ? this.music[channel].lastKey() : 0;
    }

    public int getLatestPos() {
        return this.length;
    }

    public int countTracks() {
        return this.music.length;
    }

    public MusicScore scaleSpeed(float factor) {
        MusicScore mus = new MusicScore(this.channelCount);
        for (int i = 0; i < this.channelCount; ++i) {
            if (this.music[i] == null) continue;
            for (int time : this.music[i].keySet()) {
                Collection<Note> c = this.music[i].get(time);
                if (c == null) continue;
                for (Note n : c) {
                    mus.addNote(i, (int)((float)time / factor), n);
                }
            }
        }
        return mus;
    }

    public void writeToNBT(NBTTagCompound tag) {
        for (int i = 0; i < this.channelCount; ++i) {
            NBTTagCompound nbt = new NBTTagCompound();
            if (this.music[i] != null) {
                for (int time : this.music[i].keySet()) {
                    Collection<Note> c = this.music[i].get(time);
                    NBTTagList li = new NBTTagList();
                    for (Note n : c) {
                        NBTTagCompound val = new NBTTagCompound();
                        n.writeToNBT(val);
                        li.func_74742_a((NBTBase)val);
                    }
                    nbt.func_74782_a(String.valueOf(time), (NBTBase)li);
                }
            }
            tag.func_74782_a("Ch_" + i, (NBTBase)nbt);
        }
        tag.func_74768_a("numchan", this.channelCount);
    }

    public static MusicScore readFromNBT(NBTTagCompound tag) {
        MusicScore mus = new MusicScore(tag.func_74762_e("numchan"));
        for (int i = 0; i < mus.channelCount; ++i) {
            if (!tag.func_74764_b("Ch_" + i)) continue;
            mus.music[i] = new TreeMap();
            NBTTagCompound nbt = tag.func_74775_l("Ch_" + i);
            for (Object o : nbt.func_150296_c()) {
                String s = (String)o;
                int time = Integer.parseInt(s);
                NBTTagList li = nbt.func_150295_c(s, ReikaNBTHelper.NBTTypes.COMPOUND.ID);
                ArrayList<Note> c = new ArrayList<Note>();
                for (Object o2 : li.field_74747_a) {
                    NBTTagCompound val = (NBTTagCompound)o2;
                    Note n = Note.readFromNBT(val);
                    c.add(n);
                }
                mus.music[i].put(time, c);
            }
        }
        return mus;
    }

    public String toString() {
        return Arrays.toString(this.music);
    }

    public void clearChannel(int channel) {
        this.music[channel] = null;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderPianoRoll() {
    }

    public MusicScore copy() {
        MusicScore mus = new MusicScore(this.channelCount);
        for (int i = 0; i < this.channelCount; ++i) {
            if (this.music[i] == null) continue;
            mus.music[i] = new TreeMap();
            mus.music[i].putAll(this.music[i]);
        }
        mus.length = this.length;
        return mus;
    }

    public static class Note {
        public final ReikaMusicHelper.MusicKey key;
        public final int voice;
        public final int volume;
        public final int length;
        public final boolean percussion;

        private Note(ReikaMusicHelper.MusicKey note, int instru, int vol, int len, boolean perc) {
            this.key = note;
            this.voice = instru;
            this.volume = vol;
            this.length = len;
            this.percussion = perc;
        }

        public void writeToNBT(NBTTagCompound nbt) {
            nbt.func_74768_a("key", this.key.ordinal());
            nbt.func_74768_a("volume", this.volume);
            nbt.func_74768_a("voice", this.voice);
            nbt.func_74768_a("length", this.length);
            nbt.func_74757_a("percussion", this.percussion);
        }

        public static Note readFromNBT(NBTTagCompound nbt) {
            return new Note(ReikaMusicHelper.MusicKey.getByIndex(nbt.func_74762_e("key")), nbt.func_74762_e("voice"), nbt.func_74762_e("volume"), nbt.func_74762_e("length"), nbt.func_74767_n("percussion"));
        }

        public String toString() {
            return this.key.name() + " / instr=" + this.voice + " / vol=" + this.volume + " / len=" + this.length;
        }

        public int hashCode() {
            return this.key.ordinal() << 16 | this.voice << 8 | this.volume;
        }

        public boolean equals(Object o) {
            if (o instanceof Note) {
                Note n = (Note)o;
                return n.key == this.key && n.voice == this.voice && n.volume == this.volume;
            }
            return false;
        }
    }
}

