/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.IO;

import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.DragonOptions;
import Reika.DragonAPI.Libraries.IO.ReikaChatHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.logging.log4j.Level;

public class ModLogger {
    private boolean logLoading;
    private boolean printDebug;
    private final boolean shouldWarn;
    private final DragonAPIMod mod;
    private static boolean logAll = false;
    private static boolean logNone = false;
    private BufferedWriter outputFile;
    private LoggerOut IOThread;
    private String destination;
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final ArrayList<ModLogger> loggers = new ArrayList();

    public ModLogger(DragonAPIMod mod, boolean warn) {
        this.mod = mod;
        this.logLoading = DragonOptions.LOGLOADING.getState();
        this.printDebug = DragonOptions.DEBUGMODE.getState();
        this.shouldWarn = warn;
        if (mod == null) {
            throw new IllegalArgumentException("Cannot create a logger for a null mod!");
        }
        if (this.shouldLog()) {
            ReikaJavaLibrary.pConsole(mod.getTechnicalName() + ": Creating logger. Log Loading: " + this.logLoading + "; Debug mode: " + this.printDebug + "; Warnings: " + warn);
        }
        loggers.add(this);
    }

    private String parseFileString(String file) {
        if (file.charAt(0) == '*') {
            boolean preName = file.charAt(1) == '*';
            String pre = DragonAPICore.getMinecraftDirectoryString() + "/logs/";
            file = file.replaceFirst("\\*", pre);
            if (preName) {
                file = file.replaceFirst("\\*", this.mod.getDisplayName());
            }
        }
        return file;
    }

    private void reloadConfigs() {
        this.logLoading = DragonOptions.LOGLOADING.getState();
        this.printDebug = DragonOptions.DEBUGMODE.getState();
    }

    public ModLogger setOutput(String file) {
        file = this.parseFileString(file);
        try {
            File par;
            this.flushOutput();
            File f = new File(file);
            if (f.exists()) {
                f.delete();
            }
            if (!(par = new File(f.getParent())).exists()) {
                par.mkdirs();
            }
            f.createNewFile();
            this.destination = f.getAbsolutePath();
            this.setOutput(new BufferedWriter(new PrintWriter(f)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public ModLogger setOutput(OutputStream out) {
        this.flushOutput();
        this.destination = out.getClass().getSimpleName() + " OutputStream '" + out + "'";
        this.setOutput(new BufferedWriter(new PrintWriter(out)));
        return this;
    }

    private void setOutput(BufferedWriter buf) {
        this.logChange();
        this.outputFile = buf;
        this.IOThread = new LoggerOut();
        Thread th = new Thread(this.IOThread);
        th.setDaemon(true);
        th.setName(this.mod.getDisplayName() + " - Custom I/O Logger");
        th.start();
    }

    private void logChange() {
        this.log("===============================================================================================================================");
        this.log("Logging is being redirected to " + this.destination + ". Check there for any and all logging information including debugging and errors!");
        this.log("===============================================================================================================================");
    }

    private void flushOutput() {
        if (this.outputFile != null) {
            this.IOThread.terminated = true;
        }
    }

    public void debug(Object o) {
        if (this.shouldDebug()) {
            this.write(Level.INFO, this.mod.getTechnicalName() + " DEBUG: " + o);
            ReikaChatHelper.write("DEBUG: " + o);
        }
    }

    public void log(Object o) {
        if (this.shouldLog()) {
            this.write(Level.INFO, this.mod.getTechnicalName() + ": " + o);
        }
    }

    public void logError(Object o) {
        this.write(Level.ERROR, this.mod.getTechnicalName() + " ERROR: " + o);
    }

    private void write(Level l, String s) {
        if (this.outputFile != null) {
            this.IOThread.addMessage(s, l);
        } else {
            ReikaJavaLibrary.pConsole(l, s);
        }
    }

    public boolean shouldLog() {
        if (logNone) {
            return false;
        }
        if (logAll) {
            return true;
        }
        return this.logLoading;
    }

    public boolean shouldDebug() {
        if (logNone) {
            return false;
        }
        if (logAll) {
            return true;
        }
        return this.printDebug;
    }

    public boolean shouldWarn() {
        return this.shouldWarn;
    }

    public void warn(Object o) {
        if (this.shouldWarn()) {
            this.write(Level.WARN, o.toString());
            ReikaChatHelper.write(o);
        }
    }

    public static void setAllLoggingTrue() {
        logAll = true;
        logNone = false;
    }

    public static void setAllLoggingFalse() {
        logAll = false;
        logNone = true;
    }

    public static void setAllLoggingDefault() {
        logNone = false;
        logAll = false;
    }

    public static int getActiveLoggers() {
        return loggers.size();
    }

    public static void reloadLoggers() {
        for (ModLogger m : loggers) {
            m.reloadConfigs();
        }
    }

    private class LoggerOut
    implements Runnable {
        private ConcurrentLinkedQueue<LogLine> messages = new ConcurrentLinkedQueue();
        private boolean terminated = false;

        private LoggerOut() {
        }

        private void addMessage(String s, Level l) {
            this.messages.add(new LogLine(s, l));
        }

        @Override
        public void run() {
            while (!this.terminated || !this.messages.isEmpty()) {
                ArrayList<LogLine> printed = new ArrayList<LogLine>();
                for (LogLine l : this.messages) {
                    try {
                        ModLogger.this.outputFile.write(l.toString());
                        ModLogger.this.outputFile.flush();
                        printed.add(l);
                    }
                    catch (IOException e) {
                        ReikaJavaLibrary.pConsole("ERROR: Could not output logger line to its IO destination '" + ModLogger.this.destination + "'!");
                        ReikaJavaLibrary.pConsole(l.level, l.message);
                        e.printStackTrace();
                    }
                }
                this.messages.removeAll(printed);
            }
            try {
                ModLogger.this.outputFile.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                ReikaJavaLibrary.pConsole("ERROR: Could not close logger stream!");
            }
        }

        public String toString() {
            return this.messages.size() + " Messages from " + ModLogger.this.mod.getDisplayName() + ": {" + this.messages + "}";
        }
    }

    private class LogLine {
        private final String message;
        private final Level level;
        private final Thread sender;
        private final long time;

        private LogLine(String s, Level l) {
            this.message = s;
            this.sender = Thread.currentThread();
            this.level = l;
            this.time = System.currentTimeMillis();
        }

        public String toString() {
            return this.parseTime() + " " + this.parseThread() + ": " + this.message + NEWLINE;
        }

        private String parseTime() {
            return "[" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date(this.time)) + "]";
        }

        private String parseThread() {
            return "[" + this.sender + " (" + (Object)((Object)this.sender.getState()) + ")/" + this.level + "]";
        }

        public boolean equals(Object o) {
            if (o instanceof LogLine) {
                LogLine l = (LogLine)o;
                return l.message.equals(this.message) && l.time == this.time && l.level == this.level && l.sender == this.sender;
            }
            return false;
        }

        public int hashCode() {
            return (int)this.time;
        }
    }
}

