/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.IO;

import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Exception.InvalidConfigException;
import Reika.DragonAPI.Exception.MisuseException;
import Reika.DragonAPI.Exception.RegistrationException;
import Reika.DragonAPI.Exception.StupidIDException;
import Reika.DragonAPI.IO.ReikaFileReader;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Interfaces.Configuration.BooleanConfig;
import Reika.DragonAPI.Interfaces.Configuration.BoundedConfig;
import Reika.DragonAPI.Interfaces.Configuration.ConfigList;
import Reika.DragonAPI.Interfaces.Configuration.CustomCategoryConfig;
import Reika.DragonAPI.Interfaces.Configuration.DecimalConfig;
import Reika.DragonAPI.Interfaces.Configuration.IntArrayConfig;
import Reika.DragonAPI.Interfaces.Configuration.IntegerConfig;
import Reika.DragonAPI.Interfaces.Configuration.SegmentedConfigList;
import Reika.DragonAPI.Interfaces.Configuration.SelectiveConfig;
import Reika.DragonAPI.Interfaces.Configuration.StringArrayConfig;
import Reika.DragonAPI.Interfaces.Configuration.StringConfig;
import Reika.DragonAPI.Interfaces.Configuration.UserSpecificConfig;
import Reika.DragonAPI.Interfaces.Registry.IDRegistry;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import com.google.common.base.Strings;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Session;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class ControlledConfig {
    private static final HashMap<String, ControlledConfig> configs = new HashMap();
    private static final int userHash = ControlledConfig.genUserHash();
    protected Configuration config;
    private int readID;
    protected File configFile;
    protected final DragonAPIMod configMod;
    private ConfigList[] optionList;
    private IDRegistry[] IDList;
    protected Object[] controls;
    protected int[] otherIDs;
    private final HashMap<SegmentedConfigList, String> specialFiles = new HashMap();
    private final MultiMap<String, SegmentedConfigList> specialConfigs = new MultiMap();
    private final HashMap<String, HashMap<String, String>> extraFiles = new HashMap();
    private final HashMap<String, HashMap<String, Object>> optionMap = new HashMap();
    private final HashMap<String, HashMap<String, DataElement>> additionalOptions = new HashMap();
    private final HashSet<String> orphanExclusions = new HashSet();

    public ControlledConfig(DragonAPIMod mod, ConfigList[] option, IDRegistry[] id) {
        String s2;
        String s1;
        ConfigList cfg;
        int i;
        if (mod == null) {
            throw new MisuseException("You cannot create a config with a null mod!");
        }
        this.configMod = mod;
        this.optionList = option;
        this.IDList = id;
        String n = ReikaStringParser.stripSpaces(mod.getDisplayName());
        if (configs.containsKey(n)) {
            throw new IllegalArgumentException("Only one config permitted per mod!");
        }
        configs.put(n, this);
        if (option != null) {
            this.controls = new Object[this.optionList.length];
        } else {
            this.controls = new Object[0];
            this.optionList = new ConfigList[0];
        }
        if (id != null) {
            this.otherIDs = new int[this.IDList.length];
        } else {
            this.otherIDs = new int[0];
            this.IDList = new IDRegistry[0];
        }
        for (i = 0; i < this.optionList.length; ++i) {
            cfg = this.optionList[i];
            s1 = this.getCategory(cfg);
            s2 = this.getLabel(cfg);
            this.registerOption(s1, s2, cfg);
        }
        for (i = 0; i < this.IDList.length; ++i) {
            cfg = this.IDList[i];
            s1 = cfg.getCategory();
            s2 = cfg.getConfigName();
            this.registerOption(s1, s2, cfg);
        }
    }

    private static int genUserHash() {
        return FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT ? ControlledConfig.getClientUserHash() : 0;
    }

    @SideOnly(value=Side.CLIENT)
    private static int getClientUserHash() {
        Session s = Minecraft.func_71410_x().func_110432_I();
        GameProfile p = s.func_148256_e();
        String id = p != null ? p.getId().toString() : s.func_111285_a();
        return id.hashCode();
    }

    private String getLabel(ConfigList cfg) {
        String s = cfg.getLabel();
        if (cfg instanceof UserSpecificConfig && ((UserSpecificConfig)cfg).isUserSpecific()) {
            s = "[" + Character.toUpperCase(s.charAt(0)) + this.getUserHash(cfg, s) + "] " + s;
        }
        return s;
    }

    private String getUserHash(ConfigList cfg, String s) {
        return Strings.padStart((String)Integer.toHexString(userHash - s.hashCode()).toUpperCase(Locale.ENGLISH), (int)8, (char)'0');
    }

    private void registerOption(String s1, String s2, Object cfg) {
        HashMap<String, Object> map = this.optionMap.get(s1.toLowerCase(Locale.ENGLISH));
        if (map == null) {
            map = new HashMap();
            this.optionMap.put(s1.toLowerCase(Locale.ENGLISH), map);
        }
        map.put(s2, cfg);
    }

    protected final void registerOrphanExclusion(String s) {
        this.orphanExclusions.add(s.toLowerCase(Locale.ENGLISH));
    }

    private final String getConfigPath() {
        return this.configFile.getAbsolutePath().substring(0, this.configFile.getAbsolutePath().length() - 4);
    }

    public final File getConfigFolder() {
        return this.configFile.getParentFile();
    }

    public final Collection<String> getExtraFiles() {
        return Collections.unmodifiableCollection(this.extraFiles.keySet());
    }

    public final Object getControl(int i) {
        return this.controls[i];
    }

    public int getOtherID(int i) {
        return this.otherIDs[i];
    }

    private boolean checkReset(Configuration config) {
        return false;
    }

    protected final void resetConfigFile() {
        String path = this.getConfigPath() + "_Old_Config_Backup.txt";
        File backup = new File(path);
        if (backup.exists()) {
            backup.delete();
        }
        try {
            DragonAPICore.log(this.configMod.getDisplayName().toUpperCase() + ": Writing Backup File to " + path);
            DragonAPICore.log(this.configMod.getDisplayName().toUpperCase() + ": Use this to restore custom IDs if necessary.");
            backup.createNewFile();
            if (!backup.exists()) {
                DragonAPICore.logError(this.configMod.getDisplayName().toUpperCase() + ": Could not create backup file at " + path + "!");
            } else {
                PrintWriter p = new PrintWriter(backup);
                p.println("#####----------THESE ARE ALL THE OLD CONFIG SETTINGS YOU WERE USING----------#####");
                p.println("#####---IF THEY DIFFER FROM THE DEFAULTS, YOU MUST RE-EDIT THE CONFIG FILE---#####");
                p.close();
            }
        }
        catch (IOException e) {
            DragonAPICore.logError(this.configMod.getDisplayName().toUpperCase() + ": Could not create backup file due to IOException!");
            e.printStackTrace();
        }
        this.configFile.delete();
    }

    private void versionCheck(FMLPreInitializationEvent event) {
        if (this.checkReset(this.config)) {
            DragonAPICore.log(this.configMod.getDisplayName().toUpperCase() + ": Config File Format Changed. Resetting...");
            this.resetConfigFile();
            this.initProps(event);
            return;
        }
    }

    public void loadCustomConfigFile(FMLPreInitializationEvent event, String file) {
        this.loadConfigFile(new File(file));
    }

    public void loadSubfolderedConfigFile(FMLPreInitializationEvent event) {
        String name = ReikaStringParser.stripSpaces(this.configMod.getDisplayName());
        String author = ReikaStringParser.stripSpaces(this.configMod.getModAuthorName());
        String file = event.getModConfigurationDirectory() + "/" + author + "/" + name + ".cfg";
        this.loadConfigFile(new File(file));
    }

    public void loadDefaultConfigFile(FMLPreInitializationEvent event) {
        this.loadConfigFile(event.getSuggestedConfigurationFile());
    }

    private void loadConfigFile(File f) {
        this.configFile = f;
        if (this.optionList != null) {
            for (int i = 0; i < this.optionList.length; ++i) {
                SegmentedConfigList sg;
                String s;
                ConfigList c = this.optionList[i];
                if (!(c instanceof SegmentedConfigList) || (s = (sg = (SegmentedConfigList)c).getCustomConfigFile()) == null) continue;
                s = this.parseFileString(s);
                this.specialFiles.put(sg, s);
                this.extraFiles.put(s, new HashMap());
                this.specialConfigs.addValue(s, sg);
            }
        }
    }

    private String parseFileString(String s) {
        String ext;
        int post;
        if (s.charAt(0) == '*') {
            String suffix = s.replaceAll("\\*", "");
            s = this.configFile.getAbsolutePath() + "*" + suffix;
        }
        if ((post = (ext = s.substring(s.lastIndexOf(46))).indexOf(42)) >= 0) {
            ext = ext.substring(0, post);
            s = s.replaceAll("\\*", "");
            s = s.replaceAll(ext, "");
            s = s + ext;
        }
        return s;
    }

    public final void initProps(FMLPreInitializationEvent event) {
        if (this.configFile == null) {
            throw new MisuseException("Error loading " + this.configMod.getDisplayName() + ": You must load a config file before reading it!");
        }
        this.config = new Configuration(this.configFile);
        this.onInit();
        this.loadConfig();
        this.afterInit();
    }

    protected void onInit() {
    }

    protected void afterInit() {
    }

    private void loadConfig() {
        int i;
        this.config.load();
        this.stripOrhpanedEntries();
        if (!this.specialFiles.isEmpty()) {
            this.loadExtraFiles();
        }
        for (i = 0; i < this.optionList.length; ++i) {
            ConfigList cfg = this.optionList[i];
            String label = this.getLabel(cfg);
            this.controls[i] = cfg.shouldLoad() ? this.loadValue(this.optionList[i]) : this.getDefault(this.optionList[i]);
        }
        for (i = 0; i < this.IDList.length; ++i) {
            this.otherIDs[i] = this.getValueFromConfig(this.IDList[i], this.config);
        }
        this.loadAdditionalData();
        this.config.save();
        if (!this.specialFiles.isEmpty()) {
            this.saveExtraFiles();
        }
    }

    private void stripOrhpanedEntries() {
        HashSet<ConfigCategory> catNames = new HashSet<ConfigCategory>();
        for (String s1 : this.config.getCategoryNames()) {
            ConfigCategory cat = this.config.getCategory(s1);
            HashMap<String, Object> map = this.optionMap.get(s1.toLowerCase(Locale.ENGLISH));
            if (map == null) {
                if (this.orphanExclusions.contains(s1)) continue;
                boolean flag = true;
                for (String s : this.orphanExclusions) {
                    if (!s.startsWith(s1) && !s1.startsWith(s)) continue;
                    flag = false;
                }
                if (!flag) continue;
                catNames.add(cat);
                continue;
            }
            HashSet<String> entryNames = new HashSet<String>();
            for (String s2 : cat.getValues().keySet()) {
                if (map.containsKey(s2)) continue;
                entryNames.add(s2);
            }
            for (String s : entryNames) {
                cat.remove((Object)s);
            }
        }
        for (ConfigCategory c : catNames) {
            this.config.removeCategory(c);
        }
    }

    private Object loadValue(ConfigList cfg) {
        if (cfg instanceof BooleanConfig && ((BooleanConfig)cfg).isBoolean()) {
            return this.setState((BooleanConfig)cfg);
        }
        if (cfg instanceof IntegerConfig && ((IntegerConfig)cfg).isNumeric()) {
            return this.setValue((IntegerConfig)cfg);
        }
        if (cfg instanceof DecimalConfig && ((DecimalConfig)cfg).isDecimal()) {
            return Float.valueOf(this.setFloat((DecimalConfig)cfg));
        }
        if (cfg instanceof StringConfig && ((StringConfig)cfg).isString()) {
            return this.setString((StringConfig)cfg);
        }
        if (cfg instanceof IntArrayConfig && ((IntArrayConfig)cfg).isIntArray()) {
            return this.setIntArray((IntArrayConfig)cfg);
        }
        if (cfg instanceof StringArrayConfig && ((StringArrayConfig)cfg).isStringArray()) {
            return this.setStringArray((StringArrayConfig)cfg);
        }
        return null;
    }

    private Object getDefault(ConfigList cfg) {
        if (cfg instanceof BooleanConfig && ((BooleanConfig)cfg).isBoolean()) {
            return ((BooleanConfig)cfg).getDefaultState();
        }
        if (cfg instanceof IntegerConfig && ((IntegerConfig)cfg).isNumeric()) {
            return ((IntegerConfig)cfg).getDefaultValue();
        }
        if (cfg instanceof DecimalConfig && ((DecimalConfig)cfg).isDecimal()) {
            return Float.valueOf(((DecimalConfig)cfg).getDefaultFloat());
        }
        if (cfg instanceof StringConfig && ((StringConfig)cfg).isString()) {
            return ((StringConfig)cfg).getDefaultString();
        }
        if (cfg instanceof IntArrayConfig && ((IntArrayConfig)cfg).isIntArray()) {
            return ((IntArrayConfig)cfg).getDefaultIntArray();
        }
        if (cfg instanceof StringArrayConfig && ((StringArrayConfig)cfg).isStringArray()) {
            return ((StringArrayConfig)cfg).getDefaultStringArray();
        }
        return null;
    }

    private void loadExtraFiles() {
        for (String string : this.extraFiles.keySet()) {
            File f = new File(string);
            if (!f.exists()) continue;
            this.readData(this.extraFiles.get(string), f);
        }
        for (ConfigList configList : this.specialFiles.keySet()) {
            String file = this.specialFiles.get(configList);
            HashMap<String, String> data = this.extraFiles.get(file);
            String s = data.get(this.getLabel(configList));
            if (s == null) {
                this.controls[configList.ordinal()] = this.getDefault(configList);
                continue;
            }
            try {
                Object o = this.parseData(configList, s);
                if (o == null) {
                    throw new RegistrationException(this.configMod, "Config entry '" + this.getLabel(configList) + "' returned a null value. This is invalid.");
                }
                this.controls[configList.ordinal()] = o;
            }
            catch (Exception e) {
                this.controls[configList.ordinal()] = this.getDefault(configList);
            }
        }
    }

    private Object parseData(ConfigList cfg, String o) {
        if (cfg instanceof StringConfig && ((StringConfig)cfg).isString()) {
            return o;
        }
        if (cfg instanceof IntegerConfig && ((IntegerConfig)cfg).isNumeric()) {
            return Integer.parseInt(o);
        }
        if (cfg instanceof DecimalConfig && ((DecimalConfig)cfg).isDecimal()) {
            return Float.valueOf(Float.parseFloat(o));
        }
        if (cfg instanceof IntArrayConfig && ((IntArrayConfig)cfg).isIntArray()) {
            o = o.replaceAll("[", "").replaceAll("]", "");
            String[] parts = o.split(",");
            int[] dat = new int[parts.length];
            for (int i = 0; i < dat.length; ++i) {
                dat[i] = Integer.parseInt(parts[i]);
            }
            return dat;
        }
        if (cfg instanceof StringArrayConfig && ((StringArrayConfig)cfg).isStringArray()) {
            o = o.replaceAll("[", "").replaceAll("]", "");
            String[] parts = o.split(",");
            return parts;
        }
        return o;
    }

    private void saveExtraFiles() {
        for (String s : this.extraFiles.keySet()) {
            try {
                File f = new File(s);
                ArrayList<String> li = this.getDataToWriteToFile(s);
                if (li.isEmpty()) continue;
                File parent = new File(f.getParent());
                if (!parent.exists()) {
                    parent.mkdirs();
                }
                if (f.exists()) {
                    f.delete();
                }
                f.createNewFile();
                if (!f.exists()) continue;
                ReikaFileReader.writeLinesToFile(f, li, true);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private ArrayList<String> getDataToWriteToFile(String s) {
        ArrayList<String> li = new ArrayList<String>();
        for (SegmentedConfigList cfg : this.specialConfigs.get(s)) {
            Object dat = this.controls[cfg.ordinal()];
            if (!cfg.saveIfUnspecified() && dat.equals(this.getDefault(cfg))) continue;
            String val = this.encodeData(cfg, dat);
            String sg = "[\"" + this.getLabel(cfg) + "\"=\"" + val + "\"";
            li.add(sg);
        }
        return li;
    }

    private String encodeData(ConfigList cfg, Object o) {
        if (cfg instanceof StringConfig && ((StringConfig)cfg).isString()) {
            return (String)o;
        }
        if (cfg instanceof BooleanConfig && ((BooleanConfig)cfg).isBoolean()) {
            return String.valueOf(o);
        }
        if (cfg instanceof IntegerConfig && ((IntegerConfig)cfg).isNumeric()) {
            return String.valueOf(o);
        }
        if (cfg instanceof DecimalConfig && ((DecimalConfig)cfg).isDecimal()) {
            return String.valueOf(o);
        }
        if (cfg instanceof IntArrayConfig && ((IntArrayConfig)cfg).isIntArray()) {
            return Arrays.toString((int[])o);
        }
        if (cfg instanceof StringArrayConfig && ((StringArrayConfig)cfg).isStringArray()) {
            return Arrays.toString((String[])o);
        }
        return "";
    }

    private void readData(HashMap<String, String> map, File f) {
        ArrayList<String> li = ReikaFileReader.getFileAsLines(f, true);
        for (String s : li) {
            int max;
            int min;
            String key;
            String[] dat;
            if (!s.startsWith("[") || (dat = (key = s.substring(min = s.indexOf(34), max = s.lastIndexOf(34)).replaceAll("\"", "")).split("=")).length != 2) continue;
            map.put(dat[0], dat[1]);
        }
    }

    private boolean setState(BooleanConfig cfg) {
        SelectiveConfig sfg;
        Property prop = this.config.get(this.getCategory(cfg), this.getLabel(cfg), cfg.getDefaultState());
        if (cfg.isEnforcingDefaults()) {
            prop.set(cfg.getDefaultState());
        }
        if (cfg instanceof SelectiveConfig && !(sfg = (SelectiveConfig)((Object)cfg)).saveIfUnspecified() && prop.getBoolean(cfg.getDefaultState()) == cfg.getDefaultState()) {
            this.removeConfigEntry(cfg);
            return cfg.getDefaultState();
        }
        if (cfg instanceof BoundedConfig && !((BoundedConfig)((Object)cfg)).isValueValid(prop)) {
            throw new InvalidConfigException(this.configMod, (BoundedConfig)((Object)cfg), prop);
        }
        if (!prop.isBooleanValue()) {
            throw new StupidIDException(this.configMod, prop, Property.Type.BOOLEAN);
        }
        return prop.getBoolean(cfg.getDefaultState());
    }

    private int setValue(IntegerConfig cfg) {
        SelectiveConfig sfg;
        Property prop = this.config.get(this.getCategory(cfg), this.getLabel(cfg), cfg.getDefaultValue());
        if (cfg.isEnforcingDefaults()) {
            prop.set(cfg.getDefaultValue());
        }
        if (cfg instanceof SelectiveConfig && !(sfg = (SelectiveConfig)((Object)cfg)).saveIfUnspecified() && prop.getInt(cfg.getDefaultValue()) == cfg.getDefaultValue()) {
            this.removeConfigEntry(cfg);
            return cfg.getDefaultValue();
        }
        if (cfg instanceof BoundedConfig && !((BoundedConfig)((Object)cfg)).isValueValid(prop)) {
            throw new InvalidConfigException(this.configMod, (BoundedConfig)((Object)cfg), prop);
        }
        if (!prop.isIntValue()) {
            throw new StupidIDException(this.configMod, prop, Property.Type.INTEGER);
        }
        return prop.getInt();
    }

    private float setFloat(DecimalConfig cfg) {
        SelectiveConfig sfg;
        Property prop = this.config.get(this.getCategory(cfg), this.getLabel(cfg), (double)cfg.getDefaultFloat());
        if (cfg.isEnforcingDefaults()) {
            prop.set((double)cfg.getDefaultFloat());
        }
        if (cfg instanceof SelectiveConfig && !(sfg = (SelectiveConfig)((Object)cfg)).saveIfUnspecified() && (float)prop.getDouble((double)cfg.getDefaultFloat()) == cfg.getDefaultFloat()) {
            this.removeConfigEntry(cfg);
            return cfg.getDefaultFloat();
        }
        if (cfg instanceof BoundedConfig && !((BoundedConfig)((Object)cfg)).isValueValid(prop)) {
            throw new InvalidConfigException(this.configMod, (BoundedConfig)((Object)cfg), prop);
        }
        if (!prop.isDoubleValue()) {
            throw new StupidIDException(this.configMod, prop, Property.Type.DOUBLE);
        }
        return (float)prop.getDouble((double)cfg.getDefaultFloat());
    }

    private String setString(StringConfig cfg) {
        SelectiveConfig sfg;
        Property prop = this.config.get(this.getCategory(cfg), this.getLabel(cfg), cfg.getDefaultString());
        if (cfg.isEnforcingDefaults()) {
            prop.set(cfg.getDefaultString());
        }
        if (cfg instanceof SelectiveConfig && !(sfg = (SelectiveConfig)((Object)cfg)).saveIfUnspecified() && prop.getString().equals(cfg.getDefaultString())) {
            this.removeConfigEntry(cfg);
            return cfg.getDefaultString();
        }
        if (cfg instanceof BoundedConfig && !((BoundedConfig)((Object)cfg)).isValueValid(prop)) {
            throw new InvalidConfigException(this.configMod, (BoundedConfig)((Object)cfg), prop);
        }
        return prop.getString();
    }

    private int[] setIntArray(IntArrayConfig cfg) {
        SelectiveConfig sfg;
        Property prop = this.config.get(this.getCategory(cfg), this.getLabel(cfg), cfg.getDefaultIntArray());
        if (cfg.isEnforcingDefaults()) {
            prop.set(cfg.getDefaultIntArray());
        }
        if (cfg instanceof SelectiveConfig && !(sfg = (SelectiveConfig)((Object)cfg)).saveIfUnspecified() && Arrays.equals(prop.getIntList(), cfg.getDefaultIntArray())) {
            this.removeConfigEntry(cfg);
            return cfg.getDefaultIntArray();
        }
        if (cfg instanceof BoundedConfig && !((BoundedConfig)((Object)cfg)).isValueValid(prop)) {
            throw new InvalidConfigException(this.configMod, (BoundedConfig)((Object)cfg), prop);
        }
        return prop.getIntList();
    }

    private String[] setStringArray(StringArrayConfig cfg) {
        SelectiveConfig sfg;
        Property prop = this.config.get(this.getCategory(cfg), this.getLabel(cfg), cfg.getDefaultStringArray());
        if (cfg.isEnforcingDefaults()) {
            prop.set(cfg.getDefaultStringArray());
        }
        if (cfg instanceof SelectiveConfig && !(sfg = (SelectiveConfig)((Object)cfg)).saveIfUnspecified() && Arrays.deepEquals(prop.getStringList(), cfg.getDefaultStringArray())) {
            this.removeConfigEntry(cfg);
            return cfg.getDefaultStringArray();
        }
        if (cfg instanceof BoundedConfig && !((BoundedConfig)((Object)cfg)).isValueValid(prop)) {
            throw new InvalidConfigException(this.configMod, (BoundedConfig)((Object)cfg), prop);
        }
        return prop.getStringList();
    }

    private String getCategory(ConfigList cfg) {
        String ret = "Control Setup";
        if (cfg instanceof CustomCategoryConfig) {
            String s = ((CustomCategoryConfig)cfg).getCategory();
            if (!Strings.isNullOrEmpty((String)s)) {
                ret = s;
            }
        } else if (cfg instanceof UserSpecificConfig && ((UserSpecificConfig)cfg).isUserSpecific()) {
            ret = "Client Specific";
        }
        return ret;
    }

    private void removeConfigEntry(ConfigList cfg) {
        ConfigCategory cat = this.config.getCategory(this.getCategory(cfg));
        cat.remove((Object)this.getLabel(cfg));
    }

    private int getValueFromConfig(IDRegistry id, Configuration config) {
        Property prop = config.get(id.getCategory(), id.getConfigName(), String.valueOf(id.getDefaultID()));
        if (!prop.isIntValue()) {
            throw new StupidIDException(this.configMod, prop, Property.Type.INTEGER);
        }
        return prop.getInt(id.getDefaultID());
    }

    private final void loadAdditionalData() {
        for (String c : this.additionalOptions.keySet()) {
            HashMap<String, DataElement> map = this.additionalOptions.get(c);
            for (String n : map.keySet()) {
                DataElement e = map.get(n);
                e.data = e.load(this.config);
            }
        }
    }

    protected final <C> DataElement<C> registerAdditionalOption(String c, String n, C default_) {
        HashMap<String, DataElement<Object>> map = this.additionalOptions.get(c = c.toLowerCase(Locale.ENGLISH));
        if (map == null) {
            map = new HashMap();
            this.additionalOptions.put(c, map);
        }
        DataElement e = new DataElement(c, n, default_);
        map.put(n, e);
        this.registerOption(c, n, e);
        return e;
    }

    public final void reload() {
        if (this.config == null) {
            throw new MisuseException("You cannot reload a config before it is initialized!");
        }
        this.loadConfig();
    }

    public static ControlledConfig getForMod(String mod) {
        return configs.get(mod);
    }

    public static void reloadAll() {
        for (ControlledConfig c : configs.values()) {
            c.reload();
        }
    }

    protected static final class DataElement<C> {
        private C data;
        public final String category;
        public final String name;

        private DataElement(String c, String n, C default_) {
            this.category = c;
            this.name = n;
            this.data = default_;
        }

        private Object load(Configuration config) {
            if (this.data instanceof Boolean) {
                return config.get(this.category, this.name, ((Boolean)this.data).booleanValue()).getBoolean();
            }
            if (this.data instanceof Integer) {
                return config.get(this.category, this.name, ((Integer)this.data).intValue()).getInt();
            }
            if (this.data instanceof Float || this.data instanceof Double) {
                return Float.valueOf((float)config.get(this.category, this.name, (double)((Float)this.data).floatValue()).getDouble());
            }
            if (this.data instanceof String) {
                return config.get(this.category, this.name, (String)this.data).getString();
            }
            if (this.data instanceof int[]) {
                return config.get(this.category, this.name, (int[])this.data).getIntList();
            }
            if (this.data instanceof String[]) {
                return config.get(this.category, this.name, (String[])this.data).getStringList();
            }
            return this.data;
        }

        public C getData() {
            return this.data;
        }

        public String toString() {
            return this.category + ":" + this.name + " > " + this.data.toString();
        }
    }
}

