/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.GUI;

import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Rectangle;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import org.lwjgl.opengl.GL11;

public abstract class InWorldGui {
    public final int xSize;
    public final int ySize;
    public int displayWidth;
    public int displayHeight;
    private ArrayList<Button> buttons = new ArrayList();

    public InWorldGui(int x, int y) {
        this.xSize = x;
        this.ySize = y;
        this.init();
    }

    protected void init() {
        this.buttons.clear();
    }

    protected void onButtonClicked(int id) {
    }

    protected final void addButton(int id, int x, int y, int w, int h) {
        this.buttons.add(new Button(id, x, y, w, h));
    }

    protected final void addButton(int id, int x, int y, int w, int h, int u, int v, String tex, Class root) {
        this.buttons.add(new TexturedButton(id, x, y, w, h, u, v, root, tex));
    }

    public void click(int x, int y, int button) {
        this.init();
        for (Button b : this.buttons) {
            if (!b.bounds.contains(x, y)) continue;
            this.onButtonClicked(b.ID);
            if (FMLCommonHandler.instance().getEffectiveSide() != Side.CLIENT) continue;
            this.playSound("random.click");
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void playSound(String s) {
        Minecraft.func_71410_x().field_71439_g.func_85030_a(s, 1.0f, 1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public final void render(float ptick) {
        Tessellator v5 = Tessellator.field_78398_a;
        v5.func_78382_b();
        this.bindMainTexture();
        double u = (double)this.xSize / 256.0;
        double v = (double)this.ySize / 256.0;
        GL11.glPushMatrix();
        GL11.glTranslated((double)-1.0, (double)0.0, (double)0.0);
        GL11.glScaled((double)this.displayWidth, (double)this.displayHeight, (double)1.0);
        v5.func_78374_a(0.0, 0.0, 0.0, 0.0, v);
        v5.func_78374_a(1.0, 0.0, 0.0, u, v);
        v5.func_78374_a(1.0, 1.0, 0.0, u, 0.0);
        v5.func_78374_a(0.0, 1.0, 0.0, 0.0, 0.0);
        v5.func_78381_a();
        v5.func_78382_b();
        for (Button b : this.buttons) {
            b.bindTexture();
            double dx = (double)((Button)b).bounds.x / (double)this.xSize;
            double dy = 1.0 - (double)(((Button)b).bounds.y + ((Button)b).bounds.height) / (double)this.ySize;
            double dx2 = dx + (double)((Button)b).bounds.width / (double)this.xSize;
            double dy2 = dy + (double)((Button)b).bounds.height / (double)this.ySize;
            u = 0.0;
            v = 0.2578125;
            double du = 0.77734375;
            double dv = 0.33203125;
            if (b instanceof TexturedButton) {
                TexturedButton tb = (TexturedButton)b;
                u = tb.u;
                v = tb.v;
                du = u + (double)((Button)b).bounds.width / 256.0;
                dv = v + (double)((Button)b).bounds.height / 256.0;
            }
            double t = 0.001;
            v5.func_78374_a(dx, dy, t, u, dv);
            v5.func_78374_a(dx2, dy, t, du, dv);
            v5.func_78374_a(dx2, dy2, t, du, v);
            v5.func_78374_a(dx, dy2, t, u, v);
        }
        v5.func_78381_a();
        this.renderCallback(ptick);
        GL11.glPopMatrix();
    }

    protected void renderCallback(float ptick) {
    }

    public abstract void bindMainTexture();

    private static class TexturedButton
    extends Button {
        private final String tex;
        private final Class root;
        private final double u;
        private final double v;

        private TexturedButton(int id, int x, int y, int w, int h, int u, int v, Class c, String t) {
            super(id, x, y, w, h);
            this.tex = t;
            this.root = c;
            this.u = (double)u / 256.0;
            this.v = (double)v / 256.0;
        }

        @Override
        protected void bindTexture() {
            ReikaTextureHelper.bindTexture(this.root, this.tex);
        }
    }

    private static class Button {
        private final Rectangle bounds;
        public final int ID;

        private Button(int id, int x, int y, int w, int h) {
            this.bounds = new Rectangle(x, y, w, h);
            this.ID = id;
        }

        protected void bindTexture() {
            ReikaTextureHelper.bindGuiTexture();
        }
    }
}

