/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.Maps;

import Reika.DragonAPI.Auxiliary.ModularLogger;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.DragonAPIInit;
import Reika.DragonAPI.Exception.MisuseException;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldChunk;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Instantiable.Data.Maps.NestedMap;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public final class TileEntityCache<V> {
    private static final String LOGGER_ID = "TileCache";
    private final NestedMap<WorldChunk, WorldLocation, V> data = new NestedMap();

    public V put(World world, int x, int y, int z, V value) {
        return this.put(new WorldLocation(world, x, y, z), value);
    }

    public V put(TileEntity te, V value) {
        return this.put(new WorldLocation(te), value);
    }

    public V put(WorldLocation loc, V value) {
        return this.data.put(TileEntityCache.getChunk(loc), loc, value);
    }

    public V put(V tile) {
        if (!(tile instanceof TileEntity)) {
            throw new MisuseException("You cannot self-put an entry if it is not a TileEntity!");
        }
        TileEntity te = (TileEntity)tile;
        return this.put(te.field_145850_b, te.field_145851_c, te.field_145848_d, te.field_145849_e, tile);
    }

    public void putAll(TileEntityCache<V> tc) {
        this.data.putAll(tc.data);
    }

    public V get(World world, int x, int y, int z) {
        return this.get(new WorldLocation(world, x, y, z));
    }

    public V get(TileEntity te) {
        return te != null ? (V)this.get(new WorldLocation(te)) : null;
    }

    public V get(WorldLocation c) {
        return this.data.get(TileEntityCache.getChunk(c), c);
    }

    public boolean containsKey(World world, int x, int y, int z) {
        return this.containsKey(new WorldLocation(world, x, y, z));
    }

    public boolean containsKey(TileEntity te) {
        return te != null && this.containsKey(new WorldLocation(te));
    }

    public boolean containsKey(WorldLocation c) {
        return this.data.containsInnerKey(c);
    }

    public V remove(World world, int x, int y, int z) {
        return (V)this.remove((V)new WorldLocation(world, x, y, z));
    }

    public V remove(TileEntity te) {
        return (V)this.remove((V)new WorldLocation(te));
    }

    public V remove(WorldLocation c) {
        return this.data.remove(TileEntityCache.getChunk(c), c);
    }

    public V remove(V tile) {
        if (!(tile instanceof TileEntity)) {
            throw new MisuseException("You cannot self-remove an entry if it is not a TileEntity!");
        }
        TileEntity te = (TileEntity)tile;
        return this.remove(te.field_145850_b, te.field_145851_c, te.field_145848_d, te.field_145849_e);
    }

    public Collection<WorldLocation> keySet() {
        return Collections.unmodifiableCollection(this.data.innerSet());
    }

    public void clear() {
        this.data.clear();
    }

    public void removeWorld(World world) {
        HashSet<WorldLocation> set = new HashSet<WorldLocation>(this.data.innerSet());
        for (WorldLocation loc : set) {
            if (loc.dimensionID != world.field_73011_w.field_76574_g) continue;
            this.data.removeAll(loc);
        }
    }

    public int size() {
        return this.data.size();
    }

    public Collection<V> values() {
        return Collections.unmodifiableCollection(this.data.values());
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public String toString() {
        return this.data.toString();
    }

    public void writeToNBT(NBTTagCompound tag) {
        NBTTagList li = new NBTTagList();
        for (WorldLocation loc : this.data.innerSet()) {
            NBTTagCompound data = new NBTTagCompound();
            loc.writeToNBT(data);
            li.func_74742_a((NBTBase)data);
        }
        tag.func_74782_a("locs", (NBTBase)li);
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.data.clear();
        NBTTagList li = tag.func_150295_c("locs", ReikaNBTHelper.NBTTypes.COMPOUND.ID);
        for (Object o : li.field_74747_a) {
            NBTTagCompound data = (NBTTagCompound)o;
            WorldLocation loc = WorldLocation.readFromNBT(data);
            TileEntity te = loc.getTileEntity();
            try {
                TileEntity v = te;
                this.data.put(TileEntityCache.getChunk(loc), loc, v);
            }
            catch (ClassCastException e) {
                DragonAPICore.logError("Tried to load a TileEntityCache from invalid NBT!");
            }
        }
    }

    public boolean containsValue(V value) {
        return this.data.containsValue(value);
    }

    public MultiMap<V, WorldLocation> invert(MultiMap.CollectionFactory cf) {
        MultiMap<V, WorldLocation> map = new MultiMap<V, WorldLocation>(cf);
        for (WorldLocation loc : this.data.innerSet()) {
            map.addValue(this.data.get(TileEntityCache.getChunk(loc), loc), loc);
        }
        return map;
    }

    public MultiMap<V, WorldLocation> invert() {
        return this.invert(null);
    }

    public Collection<WorldLocation> getAllLocationsNear(WorldLocation loc, double radius) {
        HashSet<WorldLocation> ret = new HashSet<WorldLocation>();
        int cx = ReikaMathLibrary.bitRound(loc.xCoord, 4);
        int cz = ReikaMathLibrary.bitRound(loc.zCoord, 4);
        int dx = loc.xCoord - cx;
        int dz = loc.zCoord - cz;
        double xmax = (double)dx + radius;
        double xmin = Math.abs((double)dx - radius);
        double zmax = (double)dz + radius;
        double zmin = Math.abs((double)dz - radius);
        int nxp = (int)Math.floor(xmax / 16.0);
        int nxn = (int)Math.ceil(xmin / 16.0);
        int nzp = (int)Math.floor(zmax / 16.0);
        int nzn = (int)Math.ceil(zmin / 16.0);
        for (int i = -nxn; i <= nxp; ++i) {
            for (int k = -nzn; k <= nzp; ++k) {
                WorldChunk pos = new WorldChunk(loc.dimensionID, (cx >> 4) + i, (cz >> 4) + k);
                Collection<WorldLocation> locs = this.data.getAllKeysIn(pos);
                if (ModularLogger.instance.isEnabled(LOGGER_ID) && radius > 16.0) {
                    ReikaJavaLibrary.pConsole(loc + " ->@ " + dx + "," + dz + " in " + cx + "," + cz + "; " + nxn + " > " + nxp + ", " + nzn + " > " + nzp + " pos[" + pos + "]= " + locs + " of " + this.data);
                }
                if (locs == null) continue;
                ret.addAll(locs);
            }
        }
        return ret;
    }

    public Map<WorldLocation, V> getChunkData(WorldChunk c) {
        return this.data.getMap(c);
    }

    public Map<WorldLocation, V> getChunkData(WorldLocation c) {
        return this.getChunkData(TileEntityCache.getChunk(c));
    }

    private static WorldChunk getChunk(WorldLocation loc) {
        return new WorldChunk(loc.dimensionID, loc.getChunk());
    }

    static {
        ModularLogger.instance.addLogger(DragonAPIInit.instance, LOGGER_ID);
    }
}

