/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.Immutable;

import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Interfaces.BlockCheck;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public final class BlockBox {
    public final int minX;
    public final int minY;
    public final int minZ;
    public final int maxX;
    public final int maxY;
    public final int maxZ;

    public BlockBox(int min, int max) {
        this(min, min, min, max, max, max);
    }

    public BlockBox(int x0, int y0, int z0, int x1, int y1, int z1) {
        this.minX = Math.min(x0, x1);
        this.minY = Math.min(y0, y1);
        this.minZ = Math.min(z0, z1);
        this.maxX = Math.max(x0, x1);
        this.maxY = Math.max(y0, y1);
        this.maxZ = Math.max(z0, z1);
    }

    public BlockBox(WorldLocation loc, WorldLocation loc2) {
        this(loc.xCoord, loc.yCoord, loc.zCoord, loc2.xCoord, loc2.yCoord, loc2.zCoord);
    }

    public static BlockBox infinity() {
        return new BlockBox(Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public static BlockBox nothing() {
        return new BlockBox(Integer.MAX_VALUE, Integer.MIN_VALUE);
    }

    public static BlockBox block(int x, int y, int z) {
        return new BlockBox(x, y, z, x + 1, y + 1, z + 1);
    }

    public static BlockBox block(TileEntity te) {
        return BlockBox.block(te.field_145851_c, te.field_145848_d, te.field_145849_e);
    }

    public static BlockBox block(ChunkCoordinates cc) {
        return BlockBox.block(cc.field_71574_a, cc.field_71572_b, cc.field_71573_c);
    }

    public int getSizeX() {
        return this.maxX - this.minX + 1;
    }

    public int getSizeY() {
        return this.maxY - this.minY + 1;
    }

    public int getSizeZ() {
        return this.maxZ - this.minZ + 1;
    }

    public int getVolume() {
        return this.getSizeX() * this.getSizeY() * this.getSizeZ();
    }

    public BlockBox expand(int amt) {
        return this.expand(amt, amt, amt);
    }

    public BlockBox expand(ForgeDirection dir, int amt) {
        int minx = this.minX;
        int miny = this.minY;
        int minz = this.minZ;
        int maxx = this.maxX;
        int maxy = this.maxY;
        int maxz = this.maxZ;
        switch (dir) {
            case EAST: {
                maxx += amt;
                break;
            }
            case WEST: {
                minx -= amt;
                break;
            }
            case NORTH: {
                minz -= amt;
                break;
            }
            case SOUTH: {
                maxz += amt;
                break;
            }
            case UP: {
                maxy += amt;
                break;
            }
            case DOWN: {
                miny -= amt;
                break;
            }
        }
        return new BlockBox(minx, miny, minz, maxx, maxy, maxz);
    }

    public BlockBox expandScale(double sx, double sy, double sz) {
        int midX = (this.minX + this.maxX) / 2;
        int midY = (this.minY + this.maxY) / 2;
        int midZ = (this.minZ + this.maxZ) / 2;
        int nx = MathHelper.func_76128_c((double)((double)midX - sx * (double)(midX - this.minX)));
        int px = MathHelper.func_76143_f((double)((double)midX + sx * (double)(this.maxX - midX)));
        int ny = MathHelper.func_76128_c((double)((double)midY - sy * (double)(midY - this.minY)));
        int py = MathHelper.func_76143_f((double)((double)midY + sy * (double)(this.maxY - midY)));
        int nz = MathHelper.func_76128_c((double)((double)midZ - sz * (double)(midZ - this.minZ)));
        int pz = MathHelper.func_76143_f((double)((double)midZ + sz * (double)(this.maxZ - midZ)));
        return new BlockBox(nx, ny, nz, px, py, pz);
    }

    public BlockBox expand(int dx, int dy, int dz) {
        return new BlockBox(this.minX - dx, this.minY - dy, this.minZ - dz, this.maxX + dx, this.maxY + dy, this.maxZ + dz);
    }

    public BlockBox shift(ForgeDirection dir, int dist) {
        return this.shift(dist * dir.offsetX, dist * dir.offsetY, dist * dir.offsetZ);
    }

    public BlockBox shift(int dx, int dy, int dz) {
        return new BlockBox(this.minX + dx, this.minY + dy, this.minZ + dz, this.maxX + dx, this.maxY + dy, this.maxZ + dz);
    }

    public BlockBox contract(ForgeDirection dir, int amt) {
        int minx = this.minX;
        int miny = this.minY;
        int minz = this.minZ;
        int maxx = this.maxX;
        int maxy = this.maxY;
        int maxz = this.maxZ;
        switch (dir) {
            case EAST: {
                maxx -= amt;
                break;
            }
            case WEST: {
                minx += amt;
                break;
            }
            case NORTH: {
                minz += amt;
                break;
            }
            case SOUTH: {
                maxz -= amt;
                break;
            }
            case UP: {
                maxy -= amt;
                break;
            }
            case DOWN: {
                miny += amt;
                break;
            }
        }
        return new BlockBox(minx, miny, minz, maxx, maxy, maxz);
    }

    public BlockBox contract(int dx, int dy, int dz) {
        return new BlockBox(this.minX + dx, this.minY + dy, this.minZ + dz, this.maxX - dx, this.maxY - dy, this.maxZ - dz);
    }

    public BlockBox clamp(ForgeDirection side, int value) {
        int minx = this.minX;
        int miny = this.minY;
        int minz = this.minZ;
        int maxx = this.maxX;
        int maxy = this.maxY;
        int maxz = this.maxX;
        switch (side) {
            case DOWN: {
                miny = Math.max(value, miny);
                break;
            }
            case UP: {
                maxy = Math.min(value, maxy);
                break;
            }
            case EAST: {
                maxx = Math.min(value, maxx);
                break;
            }
            case WEST: {
                minx = Math.max(value, minx);
                break;
            }
            case NORTH: {
                minz = Math.max(value, minz);
                break;
            }
            case SOUTH: {
                maxz = Math.min(value, maxz);
                break;
            }
        }
        return new BlockBox(minx, miny, minz, maxx, maxy, maxz);
    }

    public BlockBox combineWith(BlockBox box) {
        int minX = Math.min(this.minX, box.minX);
        int minY = Math.min(this.minY, box.minY);
        int minZ = Math.min(this.minZ, box.minZ);
        int maxX = Math.max(this.maxX, box.maxX);
        int maxY = Math.max(this.maxY, box.maxY);
        int maxZ = Math.max(this.maxZ, box.maxZ);
        return new BlockBox(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public boolean isBlockInside(Coordinate c) {
        return this.isBlockInside(c.xCoord, c.yCoord, c.zCoord);
    }

    public boolean isBlockInside(int x, int y, int z) {
        boolean ix = ReikaMathLibrary.isValueInsideBoundsIncl(this.minX, this.maxX, x);
        boolean iy = ReikaMathLibrary.isValueInsideBoundsIncl(this.minY, this.maxY, y);
        boolean iz = ReikaMathLibrary.isValueInsideBoundsIncl(this.minZ, this.maxZ, z);
        return ix && iy && iz;
    }

    public boolean isBlockInsideExclusive(Coordinate c) {
        return this.isBlockInsideExclusive(c.xCoord, c.yCoord, c.zCoord);
    }

    public boolean isBlockInsideExclusive(int x, int y, int z) {
        boolean ix = ReikaMathLibrary.isValueInsideBoundsIncl(this.minX, this.maxX - 1, x);
        boolean iy = ReikaMathLibrary.isValueInsideBoundsIncl(this.minY, this.maxY - 1, y);
        boolean iz = ReikaMathLibrary.isValueInsideBoundsIncl(this.minZ, this.maxZ - 1, z);
        return ix && iy && iz;
    }

    public boolean equals(Object o) {
        if (o instanceof BlockBox) {
            BlockBox b = (BlockBox)o;
            return b.maxX == this.maxX && b.maxY == this.maxY && b.maxZ == this.maxZ && b.minX == this.minX && b.minY == this.minY && b.minZ == this.minZ;
        }
        return false;
    }

    public int hashCode() {
        return this.minX + this.maxX + this.minY + this.maxY + this.minZ + this.maxZ;
    }

    public String toString() {
        return String.format("%d, %d, %d >> %d, %d, %d", this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    public AxisAlignedBB asAABB() {
        return AxisAlignedBB.func_72330_a((double)this.minX, (double)this.minY, (double)this.minZ, (double)(this.maxX + 1), (double)(this.maxY + 1), (double)(this.maxZ + 1));
    }

    public static BlockBox readFromNBT(NBTTagCompound tag) {
        int minx = tag.func_74762_e("minx");
        int miny = tag.func_74762_e("miny");
        int minz = tag.func_74762_e("minz");
        int maxx = tag.func_74762_e("maxx");
        int maxy = tag.func_74762_e("maxy");
        int maxz = tag.func_74762_e("maxz");
        return new BlockBox(minx, miny, minz, maxx, maxy, maxz);
    }

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("minx", this.minX);
        tag.func_74768_a("miny", this.minY);
        tag.func_74768_a("minz", this.minZ);
        tag.func_74768_a("maxx", this.maxX);
        tag.func_74768_a("maxy", this.maxY);
        tag.func_74768_a("maxz", this.maxZ);
    }

    public BlockBox offset(Coordinate offset) {
        return this.offset(offset.xCoord, offset.yCoord, offset.zCoord);
    }

    public BlockBox offset(int x, int y, int z) {
        return new BlockBox(this.minX + x, this.minY + y, this.minZ + z, this.maxX + x, this.maxY + y, this.maxZ + z);
    }

    public Coordinate getRandomContainedCoordinate(Random rand) {
        return new Coordinate(this.minX + rand.nextInt(this.maxX - this.minX + 1), this.minY + rand.nextInt(this.maxY - this.minY + 1), this.minZ + rand.nextInt(this.maxZ - this.minZ + 1));
    }

    public Coordinate findBlock(World world, BlockCheck bc) {
        for (int x = this.minX; x <= this.maxX; ++x) {
            for (int z = this.minZ; z <= this.maxZ; ++z) {
                for (int y = this.minY; y <= this.maxY; ++y) {
                    if (!bc.matchInWorld(world, x, y, z)) continue;
                    return new Coordinate(x, y, z);
                }
            }
        }
        return null;
    }
}

