/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.BlockStruct;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockArray;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;

public class BlockTracker
extends BlockArray {
    private HashMap<ItemStack, Integer> counts = new HashMap();
    private HashMap<Block, Integer> ids = new HashMap();

    public BlockTracker(World world) {
        this.refWorld = world;
    }

    @Override
    public boolean addBlockCoordinate(int x, int y, int z) {
        if (super.addBlockCoordinate(x, y, z)) {
            this.incrementCounts(x, y, z);
            return true;
        }
        return false;
    }

    private void incrementCounts(int x, int y, int z) {
        if (this.hasWorldReference()) {
            int count;
            int meta;
            Block id = this.refWorld.func_147439_a(x, y, z);
            ItemStack dat = new ItemStack(id, 1, meta = this.refWorld.func_72805_g(x, y, z));
            if (this.counts.containsKey(dat)) {
                count = this.counts.get(dat);
                this.counts.put(dat, count + 1);
            } else {
                this.counts.put(dat, 1);
            }
            if (this.ids.containsKey(id)) {
                count = this.ids.get(id);
                this.ids.put(id, count + 1);
            } else {
                this.ids.put(id, 1);
            }
        } else {
            DragonAPICore.logError("You must specify a reference world for BlockTracker!");
        }
    }

    public int getNumberOf(Block id, int meta) {
        ItemStack dat = new ItemStack(id, 1, meta);
        if (this.counts.containsKey(dat)) {
            int count = this.counts.get(dat);
            return count;
        }
        return 0;
    }

    public int getNumberOf(int id) {
        if (this.ids.containsKey(id)) {
            int count = this.ids.get(id);
            return count;
        }
        return 0;
    }

    public int getNumberOfLiquidSources(Fluid liq) {
        if (!liq.canBePlacedInWorld()) {
            DragonAPICore.logError("Cannot call the count for a non-world liquid!");
            return 0;
        }
        return this.getNumberOf(liq.getBlock(), 0);
    }
}

