/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable;

import java.util.List;

public class ConfigObject<V> {
    private final Object def;
    private final Types type;

    public ConfigObject(Object defaultValue) {
        this.type = Types.getType(defaultValue);
        this.def = defaultValue;
    }

    public V getValue() {
        return (V)this.def;
    }

    private static enum Types {
        INTEGER(Integer.TYPE),
        BOOLEAN(Boolean.TYPE),
        DECIMAL(Float.TYPE),
        LIST(List.class);

        public final Class objectClass;
        private static final Types[] list;

        private Types(Class c) {
            this.objectClass = c;
        }

        public static Types getType(Object o) {
            for (int i = 0; i < list.length; ++i) {
                Class c = Types.list[i].objectClass;
                if (!c.isAssignableFrom(o.getClass())) continue;
                return list[i];
            }
            throw new IllegalArgumentException(o + " of class " + o.getClass().getCanonicalName() + " is not a valid config parameter type!");
        }

        static {
            list = Types.values();
        }
    }
}

