/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Extras;

import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class IDHelper {
    private static final HashMap<String, Integer> blocks = ReikaJavaLibrary.sortMapByValues(IDHelper.calcBlockIDs());
    private static final HashMap<String, Integer> items = ReikaJavaLibrary.sortMapByValues(IDHelper.calcItemIDs());
    private static final HashMap<String, Integer> entities = ReikaJavaLibrary.sortMapByValues(IDHelper.calcEntityIDs());
    private static final HashMap<String, Integer> potions = ReikaJavaLibrary.sortMapByValues(IDHelper.calcPotionIDs());
    private static final HashMap<String, Integer> enchants = ReikaJavaLibrary.sortMapByValues(IDHelper.calcEnchantIDs());
    private static final HashMap<String, Integer> biomes = ReikaJavaLibrary.sortMapByValues(IDHelper.calcBiomeIDs());
    private static final HashMap<String, Integer> fluids = ReikaJavaLibrary.sortMapByValues(IDHelper.calcFluidIDs());
    private static final HashMap<String, Integer> fluidcontainers = ReikaJavaLibrary.sortMapByValues(IDHelper.calcFluidContainers());

    private static HashMap<String, Integer> calcBlockIDs() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (Block o : Block.field_149771_c) {
            String name = Block.field_149771_c.func_148750_c((Object)o);
            int id = Block.field_149771_c.func_148757_b((Object)o);
            map.put(name, id);
        }
        return map;
    }

    private static HashMap<String, Integer> calcItemIDs() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (Item o : Item.field_150901_e) {
            String name = Item.field_150901_e.func_148750_c((Object)o);
            int id = Item.field_150901_e.func_148757_b((Object)o);
            map.put(name, id);
        }
        return map;
    }

    private static HashMap<String, Integer> calcBiomeIDs() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (int i = 0; i < BiomeGenBase.field_76773_a.length; ++i) {
            BiomeGenBase b = BiomeGenBase.field_76773_a[i];
            if (b == null) continue;
            map.put(b.field_76791_y, i);
        }
        return map;
    }

    private static HashMap<String, Integer> calcEntityIDs() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.putAll(EntityList.field_75622_f);
        return map;
    }

    private static HashMap<String, Integer> calcPotionIDs() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (int i = 0; i < Potion.field_76425_a.length; ++i) {
            Potion b = Potion.field_76425_a[i];
            if (b == null) continue;
            map.put(b.func_76393_a(), i);
        }
        return map;
    }

    private static HashMap<String, Integer> calcEnchantIDs() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (int i = 0; i < Enchantment.field_77331_b.length; ++i) {
            Enchantment b = Enchantment.field_77331_b[i];
            if (b == null) continue;
            map.put(b.func_77320_a(), i);
        }
        return map;
    }

    private static HashMap<String, Integer> calcFluidIDs() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        Map data = FluidRegistry.getRegisteredFluids();
        for (String s : data.keySet()) {
            Fluid f = (Fluid)data.get(s);
            map.put(s, f.getID());
        }
        return map;
    }

    private static HashMap<String, Integer> calcFluidContainers() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        FluidContainerRegistry.FluidContainerData[] dat = FluidContainerRegistry.getRegisteredFluidContainerData();
        for (int i = 0; i < dat.length; ++i) {
            FluidContainerRegistry.FluidContainerData fcd = dat[i];
            FluidStack fs = fcd.fluid;
            Fluid f = FluidRegistry.getFluid((int)fs.getFluidID());
            ItemStack empty = fcd.emptyContainer;
            ItemStack full = fcd.filledContainer;
            String is1 = empty != null ? String.format("%s (%d:%d)", empty.func_82833_r(), Item.func_150891_b((Item)empty.func_77973_b()), empty.func_77960_j()) : "null";
            String is2 = full != null ? String.format("%s (%d:%d)", full.func_82833_r(), Item.func_150891_b((Item)full.func_77973_b()), full.func_77960_j()) : "null";
            String sg = String.format("%d of %s in %s > %s", fs.amount, f.getName(), is1, is2);
            map.put(sg, fs.getFluidID());
        }
        return map;
    }

    public static Map<String, Integer> getBlockIDs() {
        return Collections.unmodifiableMap(blocks);
    }

    public static Map<String, Integer> getItemIDs() {
        return Collections.unmodifiableMap(items);
    }

    public static Map<String, Integer> getEntityIDs() {
        return Collections.unmodifiableMap(entities);
    }

    public static Map<String, Integer> getPotionIDs() {
        return Collections.unmodifiableMap(potions);
    }

    public static Map<String, Integer> getEnchantmentIDs() {
        return Collections.unmodifiableMap(enchants);
    }

    public static Map<String, Integer> getBiomeIDs() {
        return Collections.unmodifiableMap(biomes);
    }

    public static Map<String, Integer> getFluidIDs() {
        return Collections.unmodifiableMap(ReikaJavaLibrary.sortMapByValues(IDHelper.calcFluidIDs()));
    }

    public static Map<String, Integer> getFluidContainers() {
        return Collections.unmodifiableMap(fluidcontainers);
    }
}

