/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Extras;

import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import Reika.DragonAPI.Libraries.IO.ReikaRenderHelper;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.entity.RenderManager;
import org.lwjgl.opengl.GL11;

public class ChangePacketRenderer {
    public static final ChangePacketRenderer instance = new ChangePacketRenderer();
    private final HashMap<Coordinate, RenderBox> data = new HashMap();
    public static boolean isActive = false;
    private static final int LIFETIME = 60;

    private ChangePacketRenderer() {
    }

    public static void onBlockChangePacket(int x, int y, int z, Block b, int meta) {
        if (isActive) {
            instance.addCoordinate(x, y, z, false);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void onChunkRerender(int mx, int my, int mz, int px, int py, int pz, WorldRenderer r) {
        if (isActive) {
            if (py == 257 && my == -1 && px - mx == 17 && pz - mz == 17) {
                return;
            }
            if (px - mx > 0 && py - my > 0 && pz - mz > 0) {
                for (int x = mx + 1; x <= px - 1; ++x) {
                    for (int y = my + 1; y <= py - 1; ++y) {
                        for (int z = mz + 1; z <= pz - 1; ++z) {
                            instance.addCoordinate(x, y, z, true);
                        }
                    }
                }
            } else {
                instance.addCoordinate(px, py, pz, true);
            }
        }
    }

    public void addCoordinate(int x, int y, int z, boolean reRender) {
        RenderBox rb;
        Coordinate c = new Coordinate(x, y, z);
        if (!reRender && (rb = this.data.get(c)) != null && rb.isReRender) {
            rb.renderLife = 60;
            return;
        }
        this.data.put(c, new RenderBox(c, reRender ? 1174339584 : 1627377744, reRender));
    }

    public void clear() {
        this.data.clear();
    }

    public void render() {
        if (this.data.isEmpty()) {
            return;
        }
        GL11.glPushAttrib((int)1048575);
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2929);
        GL11.glDisable((int)3008);
        ReikaGLHelper.BlendMode.DEFAULT.apply();
        GL11.glDepthMask((boolean)false);
        ReikaRenderHelper.disableEntityLighting();
        GL11.glTranslated((double)(-RenderManager.field_78725_b), (double)(-RenderManager.field_78726_c), (double)(-RenderManager.field_78723_d));
        Tessellator v5 = Tessellator.field_78398_a;
        v5.func_78382_b();
        HashMap<Coordinate, Integer> subChunks = new HashMap<Coordinate, Integer>();
        Iterator<Map.Entry<Coordinate, RenderBox>> it = this.data.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Coordinate, RenderBox> e = it.next();
            Coordinate c = e.getKey();
            RenderBox b = e.getValue();
            this.renderPosition(v5, b);
            Integer get = (Integer)subChunks.get(b.subchunk);
            int put = Math.max(b.renderLife, get != null ? Math.abs(get) : 0);
            if (b.isReRender || get != null && get < 0) {
                put = -put;
            }
            subChunks.put(b.subchunk, put);
            if (b.renderLife > 1) {
                b.renderLife--;
                continue;
            }
            it.remove();
        }
        v5.func_78381_a();
        float w = GL11.glGetFloat((int)2849);
        GL11.glLineWidth((float)6.0f);
        v5.func_78371_b(1);
        for (Coordinate c : subChunks.keySet()) {
            int val = (Integer)subChunks.get(c);
            float f = (float)Math.abs(val) / 60.0f;
            f = (double)f <= 0.5 ? f * 2.0f : 1.0f;
            double o = 0.03125;
            v5.func_78384_a(0xFFFFFF, (int)(255.0f * f));
            v5.func_78377_a((double)c.xCoord, (double)c.yCoord, (double)c.zCoord);
            v5.func_78377_a((double)(c.xCoord + 16), (double)c.yCoord, (double)c.zCoord);
            v5.func_78377_a((double)(c.xCoord + 16), (double)c.yCoord, (double)c.zCoord);
            v5.func_78377_a((double)(c.xCoord + 16), (double)c.yCoord, (double)(c.zCoord + 16));
            v5.func_78377_a((double)(c.xCoord + 16), (double)c.yCoord, (double)(c.zCoord + 16));
            v5.func_78377_a((double)c.xCoord, (double)c.yCoord, (double)(c.zCoord + 16));
            v5.func_78377_a((double)c.xCoord, (double)c.yCoord, (double)(c.zCoord + 16));
            v5.func_78377_a((double)c.xCoord, (double)c.yCoord, (double)c.zCoord);
            v5.func_78377_a((double)c.xCoord, (double)(c.yCoord + 16), (double)c.zCoord);
            v5.func_78377_a((double)(c.xCoord + 16), (double)(c.yCoord + 16), (double)c.zCoord);
            v5.func_78377_a((double)(c.xCoord + 16), (double)(c.yCoord + 16), (double)c.zCoord);
            v5.func_78377_a((double)(c.xCoord + 16), (double)(c.yCoord + 16), (double)(c.zCoord + 16));
            v5.func_78377_a((double)(c.xCoord + 16), (double)(c.yCoord + 16), (double)(c.zCoord + 16));
            v5.func_78377_a((double)c.xCoord, (double)(c.yCoord + 16), (double)(c.zCoord + 16));
            v5.func_78377_a((double)c.xCoord, (double)(c.yCoord + 16), (double)(c.zCoord + 16));
            v5.func_78377_a((double)c.xCoord, (double)(c.yCoord + 16), (double)c.zCoord);
            v5.func_78377_a((double)c.xCoord, (double)c.yCoord, (double)c.zCoord);
            v5.func_78377_a((double)c.xCoord, (double)(c.yCoord + 16), (double)c.zCoord);
            v5.func_78377_a((double)(c.xCoord + 16), (double)c.yCoord, (double)c.zCoord);
            v5.func_78377_a((double)(c.xCoord + 16), (double)(c.yCoord + 16), (double)c.zCoord);
            v5.func_78377_a((double)(c.xCoord + 16), (double)c.yCoord, (double)(c.zCoord + 16));
            v5.func_78377_a((double)(c.xCoord + 16), (double)(c.yCoord + 16), (double)(c.zCoord + 16));
            v5.func_78377_a((double)c.xCoord, (double)c.yCoord, (double)(c.zCoord + 16));
            v5.func_78377_a((double)c.xCoord, (double)(c.yCoord + 16), (double)(c.zCoord + 16));
            v5.func_78384_a(0xFFFFFF, (int)(48.0f * f));
            for (int i = 1; i <= 15; ++i) {
                v5.func_78377_a((double)(c.xCoord + i), (double)c.yCoord, (double)c.zCoord);
                v5.func_78377_a((double)(c.xCoord + i), (double)(c.yCoord + 16), (double)c.zCoord);
                v5.func_78377_a((double)(c.xCoord + i), (double)c.yCoord, (double)(c.zCoord + 16));
                v5.func_78377_a((double)(c.xCoord + i), (double)(c.yCoord + 16), (double)(c.zCoord + 16));
                v5.func_78377_a((double)c.xCoord, (double)c.yCoord, (double)(c.zCoord + i));
                v5.func_78377_a((double)c.xCoord, (double)(c.yCoord + 16), (double)(c.zCoord + i));
                v5.func_78377_a((double)(c.xCoord + 16), (double)c.yCoord, (double)(c.zCoord + i));
                v5.func_78377_a((double)(c.xCoord + 16), (double)(c.yCoord + 16), (double)(c.zCoord + i));
            }
            if (val >= 0) continue;
            v5.func_78384_a(16732384, (int)(255.0f * f));
            v5.func_78377_a((double)c.xCoord + 0.5, (double)c.yCoord + 0.5, (double)c.zCoord + 0.5);
            v5.func_78377_a((double)c.xCoord + 15.5, (double)c.yCoord + 0.5, (double)c.zCoord + 0.5);
            v5.func_78377_a((double)c.xCoord + 15.5, (double)c.yCoord + 0.5, (double)c.zCoord + 0.5);
            v5.func_78377_a((double)c.xCoord + 15.5, (double)c.yCoord + 0.5, (double)c.zCoord + 15.5);
            v5.func_78377_a((double)c.xCoord + 15.5, (double)c.yCoord + 0.5, (double)c.zCoord + 15.5);
            v5.func_78377_a((double)c.xCoord + 0.5, (double)c.yCoord + 0.5, (double)c.zCoord + 15.5);
            v5.func_78377_a((double)c.xCoord + 0.5, (double)c.yCoord + 0.5, (double)c.zCoord + 15.5);
            v5.func_78377_a((double)c.xCoord + 0.5, (double)c.yCoord + 0.5, (double)c.zCoord + 0.5);
            v5.func_78377_a((double)c.xCoord + 0.5, (double)c.yCoord + 15.5, (double)c.zCoord + 0.5);
            v5.func_78377_a((double)c.xCoord + 15.5, (double)c.yCoord + 15.5, (double)c.zCoord + 0.5);
            v5.func_78377_a((double)c.xCoord + 15.5, (double)c.yCoord + 15.5, (double)c.zCoord + 0.5);
            v5.func_78377_a((double)c.xCoord + 15.5, (double)c.yCoord + 15.5, (double)c.zCoord + 15.5);
            v5.func_78377_a((double)c.xCoord + 15.5, (double)c.yCoord + 15.5, (double)c.zCoord + 15.5);
            v5.func_78377_a((double)c.xCoord + 0.5, (double)c.yCoord + 15.5, (double)c.zCoord + 15.5);
            v5.func_78377_a((double)c.xCoord + 0.5, (double)c.yCoord + 15.5, (double)c.zCoord + 15.5);
            v5.func_78377_a((double)c.xCoord + 0.5, (double)c.yCoord + 15.5, (double)c.zCoord + 0.5);
            v5.func_78377_a((double)c.xCoord + 0.5, (double)c.yCoord + 0.5, (double)c.zCoord + 0.5);
            v5.func_78377_a((double)c.xCoord + 0.5, (double)c.yCoord + 15.5, (double)c.zCoord + 0.5);
            v5.func_78377_a((double)c.xCoord + 15.5, (double)c.yCoord + 0.5, (double)c.zCoord + 0.5);
            v5.func_78377_a((double)c.xCoord + 15.5, (double)c.yCoord + 15.5, (double)c.zCoord + 0.5);
            v5.func_78377_a((double)c.xCoord + 15.5, (double)c.yCoord + 0.5, (double)c.zCoord + 15.5);
            v5.func_78377_a((double)c.xCoord + 15.5, (double)c.yCoord + 15.5, (double)c.zCoord + 15.5);
            v5.func_78377_a((double)c.xCoord + 0.5, (double)c.yCoord + 0.5, (double)c.zCoord + 15.5);
            v5.func_78377_a((double)c.xCoord + 0.5, (double)c.yCoord + 15.5, (double)c.zCoord + 15.5);
        }
        v5.func_78381_a();
        GL11.glLineWidth((float)w);
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }

    private void renderPosition(Tessellator v5, RenderBox b) {
        float f = (float)b.renderLife / 60.0f;
        f = (double)f <= 0.5 ? f * 2.0f : 1.0f;
        double o = 0.03125;
        v5.func_78384_a(b.renderColor, (int)((float)ReikaColorAPI.getAlpha(b.renderColor) * f));
        Coordinate c = b.location;
        v5.func_78377_a((double)c.xCoord - o, (double)c.yCoord - o, (double)c.zCoord - o);
        v5.func_78377_a((double)(c.xCoord + 1) + o, (double)c.yCoord - o, (double)c.zCoord - o);
        v5.func_78377_a((double)(c.xCoord + 1) + o, (double)c.yCoord - o, (double)(c.zCoord + 1) + o);
        v5.func_78377_a((double)c.xCoord - o, (double)c.yCoord - o, (double)(c.zCoord + 1) + o);
        v5.func_78377_a((double)c.xCoord - o, (double)(c.yCoord + 1) + o, (double)(c.zCoord + 1) + o);
        v5.func_78377_a((double)(c.xCoord + 1) + o, (double)(c.yCoord + 1) + o, (double)(c.zCoord + 1) + o);
        v5.func_78377_a((double)(c.xCoord + 1) + o, (double)(c.yCoord + 1) + o, (double)c.zCoord - o);
        v5.func_78377_a((double)c.xCoord - o, (double)(c.yCoord + 1) + o, (double)c.zCoord - o);
        v5.func_78377_a((double)(c.xCoord + 1) + o, (double)c.yCoord - o, (double)c.zCoord - o);
        v5.func_78377_a((double)(c.xCoord + 1) + o, (double)(c.yCoord + 1) + o, (double)c.zCoord - o);
        v5.func_78377_a((double)(c.xCoord + 1) + o, (double)(c.yCoord + 1) + o, (double)(c.zCoord + 1) + o);
        v5.func_78377_a((double)(c.xCoord + 1) + o, (double)c.yCoord - o, (double)(c.zCoord + 1) + o);
        v5.func_78377_a((double)c.xCoord - o, (double)c.yCoord - o, (double)(c.zCoord + 1) + o);
        v5.func_78377_a((double)c.xCoord - o, (double)(c.yCoord + 1) + o, (double)(c.zCoord + 1) + o);
        v5.func_78377_a((double)c.xCoord - o, (double)(c.yCoord + 1) + o, (double)c.zCoord - o);
        v5.func_78377_a((double)c.xCoord - o, (double)c.yCoord - o, (double)c.zCoord - o);
        v5.func_78377_a((double)(c.xCoord + 1) + o, (double)c.yCoord - o, (double)(c.zCoord + 1) + o);
        v5.func_78377_a((double)(c.xCoord + 1) + o, (double)(c.yCoord + 1) + o, (double)(c.zCoord + 1) + o);
        v5.func_78377_a((double)c.xCoord - o, (double)(c.yCoord + 1) + o, (double)(c.zCoord + 1) + o);
        v5.func_78377_a((double)c.xCoord - o, (double)c.yCoord - o, (double)(c.zCoord + 1) + o);
        v5.func_78377_a((double)c.xCoord - o, (double)c.yCoord - o, (double)c.zCoord - o);
        v5.func_78377_a((double)c.xCoord - o, (double)(c.yCoord + 1) + o, (double)c.zCoord - o);
        v5.func_78377_a((double)(c.xCoord + 1) + o, (double)(c.yCoord + 1) + o, (double)c.zCoord - o);
        v5.func_78377_a((double)(c.xCoord + 1) + o, (double)c.yCoord - o, (double)c.zCoord - o);
    }

    private static class RenderBox {
        private final Coordinate subchunk;
        private final Coordinate location;
        private final int renderColor;
        private int renderLife = 60;
        private final boolean isReRender;

        private RenderBox(Coordinate c, int clr, boolean re) {
            this.location = c;
            this.renderColor = clr;
            this.subchunk = new Coordinate(ReikaMathLibrary.roundDownToX(16, c.xCoord), ReikaMathLibrary.roundDownToX(16, c.yCoord), ReikaMathLibrary.roundDownToX(16, c.zCoord));
            this.isReRender = re;
        }
    }
}

