/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI;

import Reika.DragonAPI.DragonAPIInit;
import Reika.DragonAPI.Exception.MisuseException;
import Reika.DragonAPI.Exception.RegistrationException;
import Reika.DragonAPI.Instantiable.Event.Client.GameFinishedLoadingEvent;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaObfuscationHelper;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.FMLInjectionData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Random;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.PropertyManager;

public class DragonAPICore {
    public static final Random rand = new Random();
    private static final boolean reika = DragonAPICore.calculateReikasComputer();
    public static final String last_API_Version = "@MAJOR_VERSION@@MINOR_VERSION@";
    public static boolean debugtest = false;
    private static boolean loaded;
    private static final long launchTime;
    private static final String MINFORGE = "required-after:Forge@[10.13.4.1558,);";
    public static final String dependencies = "required-after:Forge@[10.13.4.1558,);after:BuildCraft|Energy;after:IC2;after:ThermalExpansion;after:Thaumcraft;after:powersuits;after:GalacticCraft;after:Mystcraft;after:UniversalElectricity;after:Forestry;after:MagicBees;after:ExtraBees;after:Natura;after:TConstruct;after:ProjRed|Core;after:bluepower;after:Waila;after:funkylocomotion;after:chisel;after:ComputerCraft;after:ThermalFoundation;after:CarpentersBlocks;after:AgriCraft";
    public static final String FORUM_PAGE = "http://www.minecraftforum.net/topic/1969694-";
    public static final UUID Reika_UUID;

    protected DragonAPICore() {
        throw new MisuseException("The class " + this.getClass() + " cannot be instantiated!");
    }

    public static URL getReikaForumPage() {
        try {
            return new URL(FORUM_PAGE);
        }
        catch (MalformedURLException e) {
            throw new RegistrationException(DragonAPIInit.instance, "Reika's mods provided a malformed URL for their documentation site!", e);
        }
    }

    public static final boolean hasAllClasses() {
        return true;
    }

    public static File getMinecraftDirectory() {
        return (File)FMLInjectionData.data()[6];
    }

    public static String getMinecraftDirectoryString() {
        String s = DragonAPICore.getMinecraftDirectory().getAbsolutePath();
        if (s.endsWith("/.") || s.endsWith("\\.")) {
            s = s.substring(0, s.length() - 2);
        }
        s = s.replaceAll("\\\\", "/");
        return s;
    }

    public static String getServerRootFolder() {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            return DragonAPICore.getMinecraftDirectoryString();
        }
        if (MinecraftServer.func_71276_C() != null && MinecraftServer.func_71276_C().field_71305_c.length > 0 && MinecraftServer.func_71276_C().field_71305_c[0] != null) {
            return MinecraftServer.func_71276_C().field_71305_c[0].func_72860_G().func_75765_b().getAbsolutePath();
        }
        File props = new File("server.properties");
        if (!props.exists()) {
            File root = DragonAPICore.getMinecraftDirectory();
            props = new File(root, "server.properties");
        }
        if (props.exists()) {
            return new PropertyManager(props).func_73671_a("level-name", "world");
        }
        return null;
    }

    private static boolean calculateReikasComputer() {
        try {
            String username = System.getProperty("user.name");
            boolean win = System.getProperty("os.name").equals("Windows 7");
            int cpus = Runtime.getRuntime().availableProcessors();
            String cpu = System.getProperty("os.arch");
            long diskSize = new File("c:").getTotalSpace();
            return win && "amd64".equals(cpu) && diskSize == 119926681600L && cpus == 8 && "Reika".equals(username);
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static boolean isReikasComputer() {
        return reika;
    }

    protected static Side getSide() {
        return FMLCommonHandler.instance().getEffectiveSide();
    }

    private static void validateForgeVersions() {
        int major = 10;
        int minor = 13;
        int rev = 4;
        int build = 1558;
        int recbuild = 1291;
        if (build < recbuild) {
            DragonAPICore.log("The version of Forge you are using is compatible but not recommended.");
            DragonAPICore.log(String.format("Consider updating to at least %d.%d.%d.%d.", major, minor, rev, recbuild));
        }
    }

    public static boolean isOnActualServer() {
        return DragonAPICore.getSide() == Side.SERVER && FMLCommonHandler.instance().getMinecraftServerInstance().func_71262_S();
    }

    public static boolean isSinglePlayer() {
        return DragonAPICore.getSide() == Side.SERVER && !FMLCommonHandler.instance().getMinecraftServerInstance().func_71262_S();
    }

    public static void debugPrint(Object o) {
        ReikaJavaLibrary.pConsole(o);
        if (!ReikaObfuscationHelper.isDeObfEnvironment()) {
            Thread.dumpStack();
        }
    }

    public static void debug(Object s) {
        DragonAPIInit.instance.getModLogger().debug(s);
    }

    public static void log(Object s) {
        DragonAPIInit.instance.getModLogger().log(s);
    }

    public static void logError(Object s) {
        DragonAPIInit.instance.getModLogger().logError(s);
    }

    public static void logError(Object o, Side side) {
        if (FMLCommonHandler.instance().getEffectiveSide() == side) {
            DragonAPICore.logError(o);
        }
    }

    public static boolean hasGameLoaded() {
        return loaded;
    }

    public static void setGameLoaded() {
        loaded = true;
    }

    public static long getLaunchTime() {
        return launchTime;
    }

    public static int getSystemTimeAsInt() {
        long t = System.currentTimeMillis();
        return (int)(t % Integer.MIN_VALUE);
    }

    static {
        launchTime = ManagementFactory.getRuntimeMXBean().getStartTime();
        Reika_UUID = UUID.fromString("e5248026-6874-4954-9a02-aa8910d08f31");
        if (DragonAPICore.isReikasComputer()) {
            ReikaJavaLibrary.pConsole("DRAGONAPI: Loading on Reika's computer; Dev features enabled.");
        }
        DragonAPICore.validateForgeVersions();
    }

    public static class DragonAPILoadWatcher {
        public static final DragonAPILoadWatcher instance = new DragonAPILoadWatcher();

        private DragonAPILoadWatcher() {
        }

        @SubscribeEvent
        @SideOnly(value=Side.CLIENT)
        public void load(GameFinishedLoadingEvent evt) {
            loaded = true;
        }
    }
}

