/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Command;

import Reika.DragonAPI.Command.DragonCommandBase;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.StructureExport;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Instantiable.Data.Maps.PlayerMap;
import java.io.IOException;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumChatFormatting;

public class StructureExportCommand
extends DragonCommandBase {
    private final PlayerMap<Coordinate> click = new PlayerMap();
    private final PlayerMap<HashMap<String, Boolean>> states = new PlayerMap();
    private final MultiMap<UUID, String> tags = new MultiMap();

    public void func_71515_b(ICommandSender ics, String[] args) {
        EntityPlayerMP ep = StructureExportCommand.func_71521_c((ICommandSender)ics);
        if (args.length == 1) {
            if (args[0].equals("cleartags")) {
                this.tags.remove(ep.func_110124_au());
                StructureExportCommand.sendChatToSender(ics, EnumChatFormatting.GREEN + "NBT tags cleared.");
            } else {
                Boolean b;
                HashMap<String, Boolean> map = this.states.get((EntityPlayer)ep);
                if (map == null) {
                    map = new HashMap();
                    this.states.put((EntityPlayer)ep, map);
                }
                boolean e = (b = map.get(args[0])) != null ? b : false;
                map.put(args[0], !e);
                StructureExportCommand.sendChatToSender(ics, EnumChatFormatting.GREEN + "Flag '" + args[0] + "' toggled.");
            }
            return;
        }
        if (args.length > 0) {
            UUID uid = ep.getPersistentID();
            for (int i = 0; i < args.length; ++i) {
                this.tags.addValue(uid, args[i]);
            }
            StructureExportCommand.sendChatToSender(ics, EnumChatFormatting.GREEN + String.valueOf(args.length) + " tags added.");
            return;
        }
        if (this.click.containsKey((EntityPlayer)ep)) {
            Coordinate c1 = this.click.get((EntityPlayer)ep);
            StructureExportCommand.sendChatToSender(ics, EnumChatFormatting.YELLOW + "Position 2 set.");
            Coordinate c2 = new Coordinate((Entity)ep);
            String name = String.valueOf(System.currentTimeMillis());
            this.click.remove((EntityPlayer)ep);
            StructureExport s = new StructureExport(name);
            int x1 = Math.min(c1.xCoord, c2.xCoord);
            int y1 = Math.min(c1.yCoord, c2.yCoord);
            int z1 = Math.min(c1.zCoord, c2.zCoord);
            int x2 = Math.max(c1.xCoord, c2.xCoord);
            int y2 = Math.max(c1.yCoord, c2.yCoord);
            int z2 = Math.max(c1.zCoord, c2.zCoord);
            s.addWatchedNBT(this.tags.get(ep.getPersistentID()));
            s.addRegion(ep.field_70170_p, x1, y1, z1, x2, y2, z2);
            HashMap<String, Boolean> map = this.states.get((EntityPlayer)ep);
            if (map != null) {
                Boolean b = map.get("encrypt");
                s.encryptData = b != null && b != false;
                b = map.get("compress");
                s.compressData = b != null && b != false;
            }
            try {
                s.save();
                StructureExportCommand.sendChatToSender(ics, EnumChatFormatting.GREEN + "Structure exported.");
            }
            catch (IOException e) {
                StructureExportCommand.sendChatToSender(ics, EnumChatFormatting.RED + "Structure not exported: " + e.toString());
                e.printStackTrace();
            }
        } else {
            StructureExportCommand.sendChatToSender(ics, EnumChatFormatting.YELLOW + "Position 1 set.");
            this.click.put((EntityPlayer)ep, new Coordinate((Entity)ep));
        }
    }

    @Override
    public String getCommandString() {
        return "exportstructure";
    }

    @Override
    protected boolean isAdminOnly() {
        return true;
    }
}

