/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Base;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.DragonOptions;
import Reika.DragonAPI.Instantiable.Data.Immutable.InventorySlot;
import Reika.DragonAPI.Instantiable.GUI.Slot.SlotNoClick;
import Reika.DragonAPI.Interfaces.TileEntity.MultiPageInventory;
import Reika.DragonAPI.Interfaces.TileEntity.XPProducer;
import Reika.DragonAPI.Libraries.IO.ReikaChatHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;

public class CoreContainer
extends Container {
    protected final TileEntity tile;
    int posX;
    int posY;
    int posZ;
    protected EntityPlayer ep;
    protected ItemStack[] oldInv;
    protected final IInventory ii;
    private boolean alwaysCan = false;
    private static final TileEntityChest fakeChest = new TileEntityChest();
    private ArrayList<InventorySlot> relaySlots = new ArrayList();

    public CoreContainer(EntityPlayer player, TileEntity te) {
        this.tile = te;
        this.posX = this.tile.field_145851_c;
        this.posY = this.tile.field_145848_d;
        this.posZ = this.tile.field_145849_e;
        this.ep = player;
        this.ii = te instanceof IInventory ? (IInventory)te : null;
    }

    public CoreContainer setAlwaysInteractable() {
        this.alwaysCan = true;
        return this;
    }

    public CoreContainer addSlotRelay(IInventory inv, int slot) {
        this.relaySlots.add(new InventorySlot(slot, inv));
        return this;
    }

    public boolean hasInventoryChanged(ItemStack[] inv) {
        for (int i = 0; i < this.oldInv.length; ++i) {
            if (ItemStack.func_77989_b((ItemStack)this.oldInv[i], (ItemStack)inv[i])) continue;
            return true;
        }
        return false;
    }

    protected void updateInventory(ItemStack[] inv) {
        for (int i = 0; i < this.oldInv.length; ++i) {
            this.oldInv[i] = inv[i];
        }
    }

    protected void addPlayerInventoryWithOffset(EntityPlayer player, int dx, int dy) {
        for (int i = 0; i < 3; ++i) {
            for (int k = 0; k < 9; ++k) {
                this.func_75146_a(new Slot((IInventory)player.field_71071_by, k + i * 9 + 9, dx + 8 + k * 18, dy + 84 + i * 18));
            }
        }
        for (int j = 0; j < 9; ++j) {
            this.func_75146_a(new Slot((IInventory)player.field_71071_by, j, dx + 8 + j * 18, dy + 142));
        }
    }

    protected void addPlayerInventory(EntityPlayer player) {
        this.addPlayerInventoryWithOffset(player, 0, 0);
    }

    public void func_75142_b() {
        super.func_75142_b();
    }

    public final void func_75141_a(int slot, ItemStack is) {
        super.func_75141_a(slot, is);
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.alwaysCan || this.isStandard8mReach(player);
    }

    public final boolean isStandard8mReach(EntityPlayer player) {
        double dist = ReikaMathLibrary.py3d((double)this.tile.field_145851_c + 0.5 - player.field_70165_t, (double)this.tile.field_145848_d + 0.5 - player.field_70163_u, (double)this.tile.field_145849_e + 0.5 - player.field_70161_v);
        return dist <= 8.0;
    }

    public final ItemStack func_82846_b(EntityPlayer player, int slot) {
        int i;
        Slot islot = (Slot)this.field_75151_b.get(slot);
        if (!this.allowShiftClicking(player, slot, islot.func_75211_c())) {
            return null;
        }
        ItemStack ret = this.onShiftClickSlot(player, slot, islot.func_75211_c());
        if (ret != null) {
            return ret;
        }
        ItemStack is = null;
        Slot fromSlot = islot;
        if (!(this.tile instanceof IInventory)) {
            return null;
        }
        int invsize = ((IInventory)this.tile).func_70302_i_();
        int base = 0;
        if (this.tile instanceof MultiPageInventory) {
            MultiPageInventory mp = (MultiPageInventory)this.tile;
            invsize = mp.getSlotsOnPage(mp.getCurrentPage());
            int cur = mp.getCurrentPage();
            for (i = 0; i < cur; ++i) {
                base += mp.getSlotsOnPage(i);
            }
        }
        if (fromSlot != null && fromSlot.func_75216_d()) {
            boolean toPlayer;
            ItemStack inslot = fromSlot.func_75211_c();
            is = inslot.func_77946_l();
            boolean bl = toPlayer = slot < invsize + base;
            if (toPlayer) {
                for (i = invsize + base; i < this.field_75151_b.size() && is.field_77994_a > 0; ++i) {
                    Slot toSlot = (Slot)this.field_75151_b.get(i);
                    if (!toSlot.func_75214_a(is) || !this.canAdd(is, toSlot.func_75211_c())) continue;
                    if (!toSlot.func_75216_d()) {
                        toSlot.func_75215_d(is.func_77946_l());
                        is.field_77994_a = 0;
                    } else {
                        ItemStack inToSlot = toSlot.func_75211_c();
                        int add = inToSlot.func_77976_d() - inToSlot.field_77994_a;
                        if (add > is.field_77994_a) {
                            add = is.field_77994_a;
                        }
                        ItemStack toAdd = ReikaItemHelper.getSizedItemStack(is, inToSlot.field_77994_a + add);
                        toSlot.func_75215_d(toAdd);
                        is.field_77994_a -= add;
                    }
                    if (!(this.tile instanceof XPProducer)) continue;
                    float xp = ((XPProducer)this.tile).getXP();
                    this.ep.func_71023_q((int)xp);
                    ((XPProducer)this.tile).clearXP();
                }
                if (is.field_77994_a <= 0) {
                    fromSlot.func_75215_d(null);
                } else {
                    fromSlot.func_75215_d(is.func_77946_l());
                }
                is = null;
                return is;
            }
            List<Slot> list = this.getOrderedSlotList();
            for (int i2 = base; i2 < ((IInventory)this.tile).func_70302_i_() && i2 < list.size() && is.field_77994_a > 0; ++i2) {
                Slot toSlot = list.get(i2);
                int lim = ((IInventory)this.tile).func_70297_j_();
                if (!toSlot.func_75214_a(is) || !((IInventory)this.tile).func_94041_b(i2, is) || !this.canAdd(is, toSlot.func_75211_c())) continue;
                if (!toSlot.func_75216_d()) {
                    if (is.field_77994_a <= lim) {
                        toSlot.func_75215_d(is.func_77946_l());
                        is.field_77994_a = 0;
                        continue;
                    }
                    toSlot.func_75215_d(ReikaItemHelper.getSizedItemStack(is, lim));
                    is.field_77994_a -= lim;
                    continue;
                }
                ItemStack inToSlot = toSlot.func_75211_c();
                int add = Math.min(inToSlot.func_77976_d() - inToSlot.field_77994_a, lim - inToSlot.field_77994_a);
                if (add > is.field_77994_a) {
                    add = is.field_77994_a;
                }
                toSlot.func_75215_d(ReikaItemHelper.getSizedItemStack(is, inToSlot.field_77994_a + add));
                is.field_77994_a -= add;
            }
            if (is.field_77994_a <= 0) {
                fromSlot.func_75215_d(null);
            } else {
                fromSlot.func_75215_d(is.func_77946_l());
            }
            is = null;
            return is;
        }
        return null;
    }

    public boolean allowShiftClicking(EntityPlayer player, int slot, ItemStack stack) {
        return true;
    }

    protected ItemStack onShiftClickSlot(EntityPlayer player, int slot, ItemStack is) {
        return null;
    }

    private boolean canAdd(ItemStack is, ItemStack inslot) {
        if (inslot == null) {
            return true;
        }
        return ReikaItemHelper.matchStacks(is, inslot) && ItemStack.func_77970_a((ItemStack)is, (ItemStack)inslot);
    }

    public Slot func_75139_a(int index) {
        if (index >= this.field_75151_b.size() || index < 0) {
            String o = "A mod tried to access an invalid slot " + index + " for TileEntity " + this.tile + ".";
            String o2 = "It is likely assuming the TileEntity has an inventory when it does not.";
            String o3 = "Check for any inventory-modifying mods and items you are carrying.";
            String o4 = "Slot List = " + this.field_75151_b.size() + ": " + this.field_75151_b.toString();
            DragonAPICore.log(o);
            DragonAPICore.log(o2);
            DragonAPICore.log(o3);
            DragonAPICore.log(o4);
            DragonAPICore.log("Stack Trace:");
            Thread.dumpStack();
            if (DragonOptions.CHATERRORS.getState()) {
                ReikaChatHelper.write(o);
                ReikaChatHelper.write(o2);
                ReikaChatHelper.write(o3);
                ReikaChatHelper.write(o4);
            }
            return new Slot((IInventory)fakeChest, 0, -20, -20);
        }
        return (Slot)this.field_75151_b.get(index);
    }

    protected void addSlot(int i, int x, int y) {
        if (this.ii == null) {
            return;
        }
        this.func_75146_a(new Slot(this.ii, i, x, y));
    }

    protected void addSlotNoClick(int i, int x, int y) {
        if (this.ii == null) {
            return;
        }
        this.func_75146_a(new SlotNoClick(this.ii, i, x, y));
    }

    public ItemStack func_75144_a(int ID, int par2, int par3, EntityPlayer ep) {
        float xp;
        ItemStack is = super.func_75144_a(ID, par2, par3, ep);
        if (this.ii != null && this.tile instanceof XPProducer && ID < this.ii.func_70302_i_() && (xp = ((XPProducer)this.tile).getXP()) > 0.0f) {
            ep.func_71023_q((int)xp);
            ((XPProducer)this.tile).clearXP();
            ep.func_85030_a("random.orb", 0.3f, 1.0f);
        }
        return is;
    }

    private List<Slot> getOrderedSlotList() {
        ArrayList<Slot> copy = new ArrayList<Slot>(this.field_75151_b);
        Collections.sort(copy, new SlotComparator());
        Iterator it = copy.iterator();
        while (it.hasNext()) {
            Slot s = (Slot)it.next();
            if (!(s.field_75224_c instanceof InventoryPlayer)) continue;
            it.remove();
        }
        return copy;
    }

    public Slot func_75147_a(IInventory ii, int slot) {
        Slot s = super.func_75147_a(ii, slot);
        if (s == null) {
            for (InventorySlot is : this.relaySlots) {
                if (is.inventory != ii || is.slot != slot) continue;
                return is.toSlot(-20, -20);
            }
        }
        return null;
    }

    private static class SlotComparator
    implements Comparator<Slot> {
        private SlotComparator() {
        }

        @Override
        public int compare(Slot o1, Slot o2) {
            return o1.getSlotIndex() - o2.getSlotIndex();
        }
    }
}

