/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Auxiliary;

import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.Exception.RegistrationException;
import Reika.DragonAPI.Instantiable.Data.Maps.PluralMap;
import net.minecraft.world.biome.BiomeGenBase;

public class SpecialBiomePlacementRegistry {
    public static final SpecialBiomePlacementRegistry instance = new SpecialBiomePlacementRegistry();
    private final PluralMap<Integer> IDs = new PluralMap(2);
    private static final int VARIANTS = 16;

    private SpecialBiomePlacementRegistry() {
    }

    public void registerID(DragonAPIMod mod, Category c, int idx, int biomeID) {
        if (idx < 0 || idx >= 16) {
            throw new RegistrationException(mod, "Special biome variant indices can only be within 0-15!");
        }
        if (this.IDs.containsKeyV(new Object[]{c, idx})) {
            throw new RegistrationException(mod, "Special biome variant " + idx + " for " + (Object)((Object)c) + " is already occupied!");
        }
        this.IDs.put(biomeID, new Object[]{c, idx});
    }

    public int getBiomeID(Category c, int variant) {
        Integer get = this.IDs.get(new Object[]{c, variant});
        return get != null ? get : ((Category)c).defaultBiome.field_76756_M;
    }

    public static int getBiome_Hot(int variant) {
        return instance.getBiomeID(Category.HOT, variant);
    }

    public static int getBiome_Hot2(int variant) {
        return instance.getBiomeID(Category.HOT2, variant);
    }

    public static int getBiome_Warm(int variant) {
        return instance.getBiomeID(Category.WARM, variant);
    }

    public static int getBiome_Cool(int variant) {
        return instance.getBiomeID(Category.COOL, variant);
    }

    public static int getBiome_Cold(int variant) {
        return instance.getBiomeID(Category.COLD, variant);
    }

    public static enum Category {
        COLD(4, BiomeGenBase.field_76789_p),
        COOL(3, BiomeGenBase.field_150578_U),
        WARM(2, BiomeGenBase.field_76782_w),
        HOT(1, BiomeGenBase.field_150608_ab),
        HOT2(1, BiomeGenBase.field_150607_aa);

        private final int flag;
        private final BiomeGenBase defaultBiome;

        private Category(int f, BiomeGenBase b) {
            this.flag = f;
            this.defaultBiome = b;
        }
    }
}

