/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Auxiliary;

import Reika.DragonAPI.DragonOptions;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import net.minecraft.creativetab.CreativeTabs;

public class CreativeTabSorter {
    public static final CreativeTabSorter instance = new CreativeTabSorter();
    private final HashMap<CreativeTabs, LinkedList<CreativeTabs>> tabGroups = new HashMap();
    private final Collection<CreativeTabs> childTabs = new ArrayList<CreativeTabs>();
    private static final TabComparator tabComparator = new TabComparator();

    private CreativeTabSorter() {
    }

    public void registerCreativeTabAfter(CreativeTabs c, CreativeTabs ref) {
        LinkedList<Object> li = this.tabGroups.get(ref);
        if (li == null) {
            li = new LinkedList();
            this.tabGroups.put(ref, li);
        }
        li.addLast(c);
        this.childTabs.add(c);
    }

    public void sortTabs() {
        this.collectSortAndReplace(tabComparator);
    }

    private void collectSortAndReplace(Comparator c) {
        ArrayList list = ReikaJavaLibrary.makeListFromArray(CreativeTabs.field_78032_a);
        for (CreativeTabs t : this.childTabs) {
            list.remove(t);
        }
        Collections.sort(list, c);
        for (CreativeTabs p : this.tabGroups.keySet()) {
            LinkedList<CreativeTabs> ch = this.tabGroups.get(p);
            int index = list.indexOf(p) + 1;
            for (CreativeTabs t : ch) {
                list.add(index, t);
                ++index;
            }
        }
        CreativeTabs.field_78032_a = new CreativeTabs[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            CreativeTabs t;
            t = (CreativeTabs)list.get(i);
            t.field_78033_n = i;
            CreativeTabs.field_78032_a[i] = t;
        }
    }

    private static boolean isVanillaTab(CreativeTabs t) {
        return t.func_78021_a() <= 11;
    }

    private static class TabComparator
    implements Comparator<CreativeTabs> {
        private TabComparator() {
        }

        @Override
        public int compare(CreativeTabs o1, CreativeTabs o2) {
            if (CreativeTabSorter.isVanillaTab(o1) && CreativeTabSorter.isVanillaTab(o2)) {
                return o1.field_78033_n - o2.field_78033_n;
            }
            if (CreativeTabSorter.isVanillaTab(o1)) {
                return Integer.MIN_VALUE;
            }
            if (CreativeTabSorter.isVanillaTab(o2)) {
                return Integer.MAX_VALUE;
            }
            return DragonOptions.SORTCREATIVE.getState() ? String.CASE_INSENSITIVE_ORDER.compare(o1.func_78013_b(), o2.func_78013_b()) : o1.field_78033_n - o2.field_78033_n;
        }
    }
}

