/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ASM.Patchers.Fixes;

import Reika.DragonAPI.ASM.Patchers.Patcher;
import Reika.DragonAPI.Libraries.Java.ReikaASMHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidBlock;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class FluidDensityCheck
extends Patcher {
    public FluidDensityCheck() {
        super("net.minecraftforge.fluids.BlockFluidBase");
    }

    @Override
    protected void apply(ClassNode cn) {
        String sig = "(Lnet/minecraft/world/IBlockAccess;III)I";
        MethodNode m = ReikaASMHelper.getMethodByName(cn, "getDensity", sig);
        m.instructions.clear();
        m.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        m.instructions.add((AbstractInsnNode)new VarInsnNode(21, 1));
        m.instructions.add((AbstractInsnNode)new VarInsnNode(21, 2));
        m.instructions.add((AbstractInsnNode)new VarInsnNode(21, 3));
        m.instructions.add((AbstractInsnNode)new MethodInsnNode(184, "Reika/DragonAPI/ASM/Patchers/Fixes/FluidDensityCheck", "getDensityOverride", sig, false));
        m.instructions.add((AbstractInsnNode)new InsnNode(172));
    }

    public static int getDensityOverride(IBlockAccess world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y, z);
        if (b instanceof IFluidBlock || b instanceof BlockLiquid) {
            Fluid f = FluidRegistry.lookupFluidForBlock((Block)b);
            if (f == null && b.func_149688_o() == Material.field_151586_h) {
                f = FluidRegistry.WATER;
            }
            if (f == null && b.func_149688_o() == Material.field_151587_i) {
                f = FluidRegistry.LAVA;
            }
            if (f != null) {
                return world instanceof World ? f.getDensity((World)world, x, y, z) : f.getDensity();
            }
        }
        return Integer.MAX_VALUE;
    }
}

