/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ASM;

import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.Libraries.Java.ReikaJVMParser;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModAPIManager;
import cpw.mods.fml.common.discovery.ASMDataTable;
import gnu.trove.set.hash.THashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.launchwrapper.Launch;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.objectweb.asm.tree.MethodNode;

class AnnotationStripper {
    static THashSet<String> strippables;
    static final String strippableDesc;
    static String side;
    private static final boolean DEBUG = true;
    private static final boolean printClass;
    static final ArrayList<String> workingPath;
    private static final String[] emptyList;

    AnnotationStripper() {
    }

    static byte[] parse(String name, String transformedName, byte[] bytes) {
        workingPath.add(transformedName);
        if (AnnotationStripper.doStrip(name)) {
            ClassReader cr = new ClassReader(bytes);
            ClassNode cn = new ClassNode();
            cr.accept((ClassVisitor)cn, 0);
            if (AnnotationStripper.strip(cn)) {
                ClassWriter cw = new ClassWriter(2);
                cn.accept((ClassVisitor)cw);
                bytes = cw.toByteArray();
                if (printClass) {
                    ReikaJavaLibrary.printClassSource("StrippedClasses/" + name.replace('.', '/'), bytes);
                }
            }
        }
        workingPath.remove(workingPath.size() - 1);
        return bytes;
    }

    private static boolean doStrip(String name) {
        if (strippables.contains((Object)name)) {
            return true;
        }
        int idx = name.indexOf(36);
        return idx >= 0 && strippables.contains((Object)name.substring(0, idx));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized void HACK(String name, byte[] bytes) {
        ArrayList<String> arrayList = workingPath;
        synchronized (arrayList) {
            workingPath.add(name);
            ClassReader cr = new ClassReader(bytes);
            ClassNode cn = new ClassNode();
            cr.accept((ClassVisitor)cn, 0);
            if (cn.innerClasses != null) {
                for (InnerClassNode node : cn.innerClasses) {
                    if (!workingPath.contains(node.name) && AnnotationStripper.classExists(node.name)) continue;
                }
            }
            workingPath.remove(workingPath.size() - 1);
        }
    }

    static boolean strip(ClassNode cn) {
        Iterator iter;
        boolean altered = false;
        if (cn.visibleAnnotations != null) {
            for (AnnotationNode n : cn.visibleAnnotations) {
                AnnotationInfo node = AnnotationStripper.parseAnnotation(n, strippableDesc);
                if (node == null) continue;
                String[] value = node.values;
                boolean wrongSide = side == node.side;
                for (String clazz : value) {
                    String cz = clazz.replace('.', '/');
                    if (!cn.interfaces.contains(cz) || wrongSide || workingPath.contains(clazz) || AnnotationStripper.classExists(clazz)) continue;
                    cn.interfaces.remove(cz);
                    altered = true;
                    ReikaJavaLibrary.pConsole("Removing interface " + cz + " from " + cn.name + "; class not present.");
                }
            }
        }
        if (cn.methods != null) {
            iter = cn.methods.iterator();
            block2: while (iter.hasNext()) {
                MethodNode mn = (MethodNode)iter.next();
                if (mn.visibleAnnotations == null) continue;
                for (AnnotationNode node : mn.visibleAnnotations) {
                    if (!AnnotationStripper.checkRemove(AnnotationStripper.parseAnnotation(node, strippableDesc), iter)) continue;
                    altered = true;
                    continue block2;
                }
            }
        }
        if (cn.fields != null) {
            iter = cn.fields.iterator();
            block4: while (iter.hasNext()) {
                FieldNode fn = (FieldNode)iter.next();
                if (fn.visibleAnnotations == null) continue;
                for (AnnotationNode node : fn.visibleAnnotations) {
                    if (!AnnotationStripper.checkRemove(AnnotationStripper.parseAnnotation(node, strippableDesc), iter)) continue;
                    altered = true;
                    continue block4;
                }
            }
        }
        if (altered) {
            ReikaJavaLibrary.pConsole("Remaining interfaces on " + cn.name + ": " + cn.interfaces);
        }
        return altered;
    }

    private static boolean classExists(String name) {
        try {
            return Launch.classLoader.getClassBytes(name) != null;
        }
        catch (IOException e) {
            return false;
        }
    }

    static boolean checkRemove(AnnotationInfo node, Iterator<? extends Object> iter) {
        if (node != null) {
            boolean needsRemoved;
            boolean bl = needsRemoved = node.side == side;
            if (!needsRemoved) {
                for (String clazz : node.values) {
                    if (clazz.startsWith("mod:")) {
                        needsRemoved = !Loader.isModLoaded((String)clazz.substring(4));
                    } else if (clazz.startsWith("api:")) {
                        needsRemoved = !ModAPIManager.INSTANCE.hasAPI(clazz.substring(4));
                    } else if (!workingPath.contains(clazz) && !AnnotationStripper.classExists(clazz)) {
                        needsRemoved = true;
                    }
                    if (needsRemoved) break;
                }
            }
            if (needsRemoved) {
                iter.remove();
                return true;
            }
        }
        return false;
    }

    static AnnotationInfo parseAnnotation(AnnotationNode node, String desc) {
        AnnotationInfo info = null;
        if (node.desc.equals(desc)) {
            info = new AnnotationInfo();
            if (node.values != null) {
                List values = node.values;
                int i = 0;
                int e = values.size();
                while (i < e) {
                    String t;
                    Object k = values.get(i++);
                    Object v = values.get(i++);
                    if ("value".equals(k)) {
                        if (!(v instanceof List) || ((List)v).size() <= 0 || !(((List)v).get(0) instanceof String)) continue;
                        info.values = ((List)v).toArray(emptyList);
                        continue;
                    }
                    if (!"side".equals(k) || !(v instanceof String[]) || (t = ((String[])v)[1]) == null) continue;
                    info.side = t.toUpperCase().intern();
                }
            }
        }
        return info;
    }

    static void scrapeData(ASMDataTable table) {
        side = FMLCommonHandler.instance().getSide().toString().toUpperCase().intern();
        for (ASMDataTable.ASMData data : table.getAll(APIStripper.Strippable.class.getName())) {
            String name = data.getClassName();
            strippables.add((Object)name);
            strippables.add((Object)(name + "$class"));
        }
    }

    static /* synthetic */ String[] access$000() {
        return emptyList;
    }

    static {
        printClass = ReikaJVMParser.isArgumentPresent("-DragonAPI_printStripped");
        strippableDesc = Type.getDescriptor(APIStripper.Strippable.class);
        strippables = new THashSet(10);
        workingPath = new ArrayList();
        emptyList = new String[0];
    }

    static class AnnotationInfo {
        String side;
        String[] values = AnnotationStripper.access$000();

        AnnotationInfo() {
        }
    }
}

