/*
 * Decompiled with CFR 0.152.
 */
package drzhark.customspawner.utils;

import drzhark.customspawner.CustomSpawner;
import drzhark.customspawner.biomes.BiomeModData;
import drzhark.customspawner.environment.EnvironmentSettings;
import drzhark.customspawner.type.EntitySpawnType;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldProviderEnd;
import net.minecraft.world.WorldProviderHell;
import net.minecraft.world.WorldProviderSurface;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;

public class CMSUtils {
    public static boolean isTamed(Entity entity) {
        if (entity instanceof EntityTameable && ((EntityTameable)entity).func_70909_n()) {
            return true;
        }
        NBTTagCompound nbt = new NBTTagCompound();
        entity.func_189511_e(nbt);
        if (nbt != null) {
            if (nbt.func_74764_b("Owner") && !nbt.func_74779_i("Owner").equals("")) {
                return true;
            }
            if (nbt.func_74764_b("Tamed") && nbt.func_74767_n("Tamed")) {
                return true;
            }
        }
        return false;
    }

    public static List<String> parseName(String biomeConfigEntry) {
        ArrayList<String> biomeParts = new ArrayList<String>();
        if (biomeConfigEntry.indexOf(124) == -1) {
            biomeParts.add("");
            if (CustomSpawner.debug) {
                CustomSpawner.globalLog.logger.info("Invalid biome entry '" + biomeConfigEntry + "' detected in config while attempting to parse name. Please review your biome configs for possible typos. Skipping...");
            }
            return biomeParts;
        }
        String tag = biomeConfigEntry.substring(0, biomeConfigEntry.indexOf(124));
        String biomeName = biomeConfigEntry.substring(biomeConfigEntry.indexOf(124) + 1, biomeConfigEntry.length());
        biomeParts.add(tag);
        biomeParts.add(biomeName);
        return biomeParts;
    }

    public static EnvironmentSettings getEnvironment(World world) {
        return CustomSpawner.environmentMap.get(world.field_73011_w.getClass());
    }

    public static String generateModPackage(String entityClass) {
        String[] tokens = entityClass.split("\\.");
        if (tokens.length >= 2) {
            String modKey = tokens[0];
            if (modKey.equalsIgnoreCase("mod") || modKey.equalsIgnoreCase("mods") || modKey.equalsIgnoreCase("mob") || modKey.equalsIgnoreCase("mobs") || modKey.equalsIgnoreCase("com") || modKey.equalsIgnoreCase("coms") || modKey.equalsIgnoreCase("net")) {
                modKey = tokens[1];
            }
            if (entityClass.contains("net.minecraft") && tokens.length > 2) {
                modKey = tokens[2];
            }
            if (modKey.equalsIgnoreCase("minecraft") && tokens.length > 2) {
                modKey = tokens[2];
            }
            return modKey.toUpperCase();
        }
        return "";
    }

    public static boolean addWorldEnvironment(Class<? extends WorldProvider> worldProviderClass) {
        if (!CustomSpawner.environmentMap.containsKey(worldProviderClass)) {
            String worldEnvironment = worldProviderClass.getSimpleName().toLowerCase();
            worldEnvironment = worldEnvironment.replace("worldprovider", "");
            worldEnvironment = worldEnvironment.replace("provider", "");
            if (worldProviderClass == WorldProviderSurface.class) {
                if (CustomSpawner.debug) {
                    CustomSpawner.globalLog.logger.info("Adding World Environment " + worldEnvironment + " for class " + worldProviderClass.getName());
                }
                CustomSpawner.environmentMap.put(worldProviderClass, new EnvironmentSettings(new File(CustomSpawner.ROOT, "overworld"), "overworld", worldProviderClass));
            } else if (worldProviderClass == WorldProviderHell.class) {
                if (CustomSpawner.debug) {
                    CustomSpawner.globalLog.logger.info("Adding World Environment " + worldEnvironment + " for class " + worldProviderClass.getName());
                }
                CustomSpawner.environmentMap.put(worldProviderClass, new EnvironmentSettings(new File(CustomSpawner.ROOT, "nether"), "nether", worldProviderClass));
            } else if (worldProviderClass == WorldProviderEnd.class) {
                if (CustomSpawner.debug) {
                    CustomSpawner.globalLog.logger.info("Adding World Environment " + worldEnvironment + " for class " + worldProviderClass.getName());
                }
                CustomSpawner.environmentMap.put(worldProviderClass, new EnvironmentSettings(new File(CustomSpawner.ROOT, "end"), "end", worldProviderClass));
            } else {
                if (CustomSpawner.debug) {
                    CustomSpawner.globalLog.logger.info("Adding World Environment " + worldEnvironment + " for class " + worldProviderClass.getName());
                }
                CustomSpawner.environmentMap.put(worldProviderClass, new EnvironmentSettings(new File(CustomSpawner.ROOT, worldEnvironment), worldEnvironment, worldProviderClass));
            }
            EnvironmentSettings environment = CustomSpawner.environmentMap.get(worldProviderClass);
            if (CustomSpawner.debug) {
                CustomSpawner.globalLog.logger.info("Copying spawn list data from all biomes...");
            }
            CustomSpawner.copyVanillaSpawnData();
            environment.initializeBiomes();
            environment.initializeEntities();
            environment.updateSettings();
            return true;
        }
        return false;
    }

    public static BiomeModData getBiomeModData(Map<String, BiomeModData> biomeMap, String tag) {
        for (BiomeModData biomeModData : biomeMap.values()) {
            if (!biomeModData.getModTag().equalsIgnoreCase(tag)) continue;
            return biomeModData;
        }
        return null;
    }

    public static void dumpEntitySpawnLists() {
        for (EnvironmentSettings environment : CustomSpawner.environmentMap.values()) {
            if (!environment.debug) continue;
            environment.envLog.logger.info("[" + environment.name().toUpperCase() + "]" + " Dumping SPAWN LISTS...");
            for (EntitySpawnType entitySpawnType : environment.entitySpawnTypes.values()) {
                if (entitySpawnType.name().equalsIgnoreCase("undefined")) continue;
                environment.envLog.logger.info("Reading type " + entitySpawnType.name().toUpperCase() + "...");
                for (Biome biome : Biome.field_185377_q) {
                    environment.envLog.logger.info("Found biome " + biome.field_76791_y + " with spawn entries : ");
                    if (entitySpawnType.getBiomeSpawnList(Biome.func_185362_a((Biome)biome)) == null) {
                        environment.envLog.logger.info("NONE!");
                        continue;
                    }
                    for (Biome.SpawnListEntry spawn : entitySpawnType.getBiomeSpawnList(Biome.func_185362_a((Biome)biome))) {
                        environment.envLog.logger.info("[SpawnListEntry]" + spawn.field_76300_b + " - " + spawn.field_76292_a + ":" + spawn.field_76301_c + ":" + spawn.field_76299_d);
                    }
                }
            }
        }
    }

    public static void dumpDefaultSpawnList() {
        if (!CustomSpawner.debug) {
            return;
        }
        for (Map.Entry<String, ArrayList<Biome>> defaultEntry : CustomSpawner.entityDefaultSpawnBiomes.entrySet()) {
            CustomSpawner.globalLog.logger.info("Found entity " + defaultEntry.getKey() + ", printing biome list :");
            for (Biome biome : defaultEntry.getValue()) {
                CustomSpawner.globalLog.logger.info("with biome " + biome.field_76791_y);
            }
            CustomSpawner.globalLog.logger.info("");
        }
    }

    public static int getLightFromNeighbors(Chunk chunk, int x, int y, int z) {
        ExtendedBlockStorage extendedblockstorage = chunk.func_76587_i()[y >> 4];
        if (extendedblockstorage == null) {
            return 0;
        }
        return extendedblockstorage.func_76674_d(x, y & 0xF, z);
    }

    public static boolean isValidUndergroundLightLevel(EntityLiving entityliving) {
        BlockPos pos = entityliving.func_180425_c();
        if (entityliving.field_70170_p.func_175642_b(EnumSkyBlock.SKY, pos) > entityliving.field_70170_p.field_73012_v.nextInt(32)) {
            return false;
        }
        int l = entityliving.field_70170_p.func_175671_l(pos);
        if (entityliving.field_70170_p.func_72911_I()) {
            int i1 = entityliving.field_70170_p.func_175657_ab();
            entityliving.field_70170_p.func_175692_b(10);
            l = entityliving.field_70170_p.func_175671_l(pos);
            entityliving.field_70170_p.func_175692_b(i1);
        }
        return l <= entityliving.field_70170_p.field_73012_v.nextInt(8);
    }

    public static Biome.SpawnListEntry getSpawnListEntry(Class<? extends EntityLiving> clazz, List<Biome.SpawnListEntry> spawnList) {
        for (Biome.SpawnListEntry spawnListEntry : spawnList) {
            if (spawnListEntry.field_76300_b != clazz) continue;
            return spawnListEntry;
        }
        return null;
    }

    public static Map<String, Integer> sortByComparator(Map<String, Integer> unsortMap, final boolean order) {
        LinkedList<Map.Entry<String, Integer>> list = new LinkedList<Map.Entry<String, Integer>>(unsortMap.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<String, Integer>>(){

            @Override
            public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                if (order) {
                    return o1.getValue().compareTo(o2.getValue());
                }
                return o2.getValue().compareTo(o1.getValue());
            }
        });
        LinkedHashMap<String, Integer> sortedMap = new LinkedHashMap<String, Integer>();
        for (Map.Entry entry : list) {
            sortedMap.put((String)entry.getKey(), (Integer)entry.getValue());
        }
        return sortedMap;
    }

    public static long asLong(int x, int z) {
        return ((long)x << 32) + (long)z - Integer.MIN_VALUE;
    }

    public static int getChunkX(long l) {
        return (int)(l >> 32);
    }

    public static int getChunkZ(long l) {
        return (int)(l & 0xFFFFFFFFFFFFFFFFL) + Integer.MIN_VALUE;
    }
}

