/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.instructions;

import com.simibubi.create.foundation.ponder.PonderScene;
import com.simibubi.create.foundation.ponder.elements.AnimatedOverlayElement;
import com.simibubi.create.foundation.ponder.elements.AnimatedSceneElement;
import com.simibubi.create.foundation.ponder.instructions.TickingInstruction;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;

public class HideAllInstruction
extends TickingInstruction {
    private Direction fadeOutTo;

    public HideAllInstruction(int fadeOutTicks, Direction fadeOutTo) {
        super(false, fadeOutTicks);
        this.fadeOutTo = fadeOutTo;
    }

    @Override
    protected void firstTick(PonderScene scene) {
        super.firstTick(scene);
        scene.getElements().forEach(element -> {
            if (element instanceof AnimatedSceneElement) {
                AnimatedSceneElement animatedSceneElement = (AnimatedSceneElement)element;
                animatedSceneElement.setFade(1.0f);
                animatedSceneElement.setFadeVec(this.fadeOutTo == null ? null : Vector3d.func_237491_b_((Vector3i)this.fadeOutTo.func_176730_m()).func_186678_a(0.5));
            } else if (element instanceof AnimatedOverlayElement) {
                AnimatedOverlayElement animatedSceneElement = (AnimatedOverlayElement)element;
                animatedSceneElement.setFade(1.0f);
            } else {
                element.setVisible(false);
            }
        });
    }

    @Override
    public void tick(PonderScene scene) {
        super.tick(scene);
        float fade = (float)this.remainingTicks / (float)this.totalTicks;
        scene.forEach(AnimatedSceneElement.class, ase -> {
            ase.setFade(fade * fade);
            if (this.remainingTicks == 0) {
                ase.setFade(0.0f);
            }
        });
        scene.forEach(AnimatedOverlayElement.class, aoe -> {
            aoe.setFade(fade * fade);
            if (this.remainingTicks == 0) {
                aoe.setFade(0.0f);
            }
        });
    }
}

