/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.BoxElement;
import com.simibubi.create.foundation.gui.GuiGameElement;
import com.simibubi.create.foundation.gui.IScreenRenderable;
import com.simibubi.create.foundation.gui.RenderElement;
import com.simibubi.create.foundation.gui.ScreenOpener;
import com.simibubi.create.foundation.gui.Theme;
import com.simibubi.create.foundation.gui.UIRenderHelper;
import com.simibubi.create.foundation.gui.widgets.AbstractSimiWidget;
import com.simibubi.create.foundation.gui.widgets.ElementWidget;
import com.simibubi.create.foundation.ponder.NavigatableSimiScreen;
import com.simibubi.create.foundation.ponder.PonderProgressBar;
import com.simibubi.create.foundation.ponder.PonderRegistry;
import com.simibubi.create.foundation.ponder.PonderScene;
import com.simibubi.create.foundation.ponder.PonderStoryBoardEntry;
import com.simibubi.create.foundation.ponder.PonderWorld;
import com.simibubi.create.foundation.ponder.content.DebugScenes;
import com.simibubi.create.foundation.ponder.content.PonderChapter;
import com.simibubi.create.foundation.ponder.content.PonderTag;
import com.simibubi.create.foundation.ponder.content.PonderTagScreen;
import com.simibubi.create.foundation.ponder.elements.TextWindowElement;
import com.simibubi.create.foundation.ponder.ui.PonderButton;
import com.simibubi.create.foundation.renderState.SuperRenderTypeBuffer;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.FontHelper;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.foundation.utility.Pointing;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.IntStream;
import net.minecraft.client.ClipboardHelper;
import net.minecraft.client.GameSettings;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraftforge.fml.client.gui.GuiUtils;
import net.minecraftforge.registries.ForgeRegistries;
import org.lwjgl.opengl.GL11;

public class PonderUI
extends NavigatableSimiScreen {
    public static int ponderTicks;
    public static float ponderPartialTicksPaused;
    public static final String PONDERING = "ponder.pondering";
    public static final String IDENTIFY_MODE = "ponder.identify_mode";
    public static final String IN_CHAPTER = "ponder.in_chapter";
    public static final String IDENTIFY = "ponder.identify";
    public static final String PREVIOUS = "ponder.previous";
    public static final String CLOSE = "ponder.close";
    public static final String NEXT = "ponder.next";
    public static final String REPLAY = "ponder.replay";
    public static final String SLOW_TEXT = "ponder.slow_text";
    private List<PonderScene> scenes;
    private List<PonderTag> tags;
    private List<PonderButton> tagButtons;
    private List<LerpedFloat> tagFades;
    private LerpedFloat fadeIn;
    ItemStack stack;
    PonderChapter chapter = null;
    private boolean userViewMode;
    private boolean identifyMode;
    private ItemStack hoveredTooltipItem;
    private BlockPos hoveredBlockPos;
    private ClipboardHelper clipboardHelper;
    private BlockPos copiedBlockPos;
    private LerpedFloat finishingFlash;
    private int finishingFlashWarmup = 0;
    private LerpedFloat lazyIndex;
    private int index = 0;
    private PonderTag referredToByTag;
    private PonderButton left;
    private PonderButton right;
    private PonderButton scan;
    private PonderButton chap;
    private PonderButton userMode;
    private PonderButton close;
    private PonderButton replay;
    private PonderButton slowMode;
    private PonderProgressBar progressBar;
    private int skipCooling = 0;
    private int extendedTickLength = 0;
    private int extendedTickTimer = 0;

    public static PonderUI of(ResourceLocation id) {
        return new PonderUI(PonderRegistry.compile(id));
    }

    public static PonderUI of(ItemStack item) {
        return new PonderUI(PonderRegistry.compile(item.func_77973_b().getRegistryName()));
    }

    public static PonderUI of(ItemStack item, PonderTag tag) {
        PonderUI ponderUI = new PonderUI(PonderRegistry.compile(item.func_77973_b().getRegistryName()));
        ponderUI.referredToByTag = tag;
        return ponderUI;
    }

    public static PonderUI of(PonderChapter chapter) {
        PonderUI ui = new PonderUI(PonderRegistry.compile(chapter));
        ui.chapter = chapter;
        return ui;
    }

    PonderUI(List<PonderScene> scenes) {
        ResourceLocation component = scenes.get((int)0).component;
        this.stack = ForgeRegistries.ITEMS.containsKey(component) ? new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(component)) : new ItemStack((IItemProvider)ForgeRegistries.BLOCKS.getValue(component));
        this.tags = new ArrayList<PonderTag>(PonderRegistry.TAGS.getTags(component));
        this.scenes = scenes;
        if (scenes.isEmpty()) {
            List<PonderStoryBoardEntry> l = Collections.singletonList(new PonderStoryBoardEntry(DebugScenes::empty, "create", "debug/scene_1", new ResourceLocation("minecraft", "stick")));
            scenes.addAll(PonderRegistry.compile(l));
        }
        this.lazyIndex = LerpedFloat.linear().startWithValue(this.index);
        this.fadeIn = LerpedFloat.linear().startWithValue(0.0).chase(1.0, 0.1f, LerpedFloat.Chaser.EXP);
        this.clipboardHelper = new ClipboardHelper();
        this.finishingFlash = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 0.1f, LerpedFloat.Chaser.EXP);
    }

    @Override
    protected void func_231160_c_() {
        this.widgets.clear();
        super.func_231160_c_();
        this.tagButtons = new ArrayList<PonderButton>();
        this.tagFades = new ArrayList<LerpedFloat>();
        this.tags.forEach(t -> {
            int i = this.tagButtons.size();
            int x = 31;
            int y = 81 + i * 30;
            PonderButton b2 = (PonderButton)((Object)((Object)((AbstractSimiWidget)((Object)((Object)new PonderButton(x, y).showing((IScreenRenderable)t)))).withCallback((mX, mY) -> {
                this.centerScalingOn((int)mX, (int)mY);
                ScreenOpener.transitionTo(new PonderTagScreen((PonderTag)t));
            })));
            this.widgets.add(b2);
            this.tagButtons.add(b2);
            LerpedFloat chase = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 0.05f, LerpedFloat.Chaser.exp(0.1));
            this.tagFades.add(chase);
        });
        GameSettings bindings = this.field_230706_i_.field_71474_y;
        int spacing = 8;
        int bX = (this.field_230708_k_ - 20) / 2 - (70 + 2 * spacing);
        int bY = this.field_230709_l_ - 20 - 31;
        int pX = this.field_230708_k_ / 2 - 110;
        int pY = bY + 20 + 4;
        int pW = this.field_230708_k_ - 2 * pX;
        this.progressBar = new PonderProgressBar(this, pX, pY, pW, 1);
        this.widgets.add(this.progressBar);
        this.scan = (PonderButton)((Object)((AbstractSimiWidget)((Object)((ElementWidget)((Object)((ElementWidget)((Object)new PonderButton(bX, bY).withShortcut(bindings.field_74316_C))).showing(AllIcons.I_MTD_SCAN))).enableFade(0, 5))).withCallback(() -> {
            boolean bl = this.identifyMode = !this.identifyMode;
            if (!this.identifyMode) {
                this.scenes.get(this.index).deselect();
            } else {
                ponderPartialTicksPaused = this.field_230706_i_.func_184121_ak();
            }
        }));
        this.widgets.add(this.scan);
        this.slowMode = (PonderButton)((Object)((AbstractSimiWidget)((Object)((ElementWidget)((Object)new PonderButton(this.field_230708_k_ - 20 - 31, bY).showing(AllIcons.I_MTD_SLOW_MODE))).enableFade(0, 5))).withCallback(() -> this.setComfyReadingEnabled(!this.isComfyReadingEnabled())));
        this.widgets.add(this.slowMode);
        this.left = (PonderButton)((Object)((AbstractSimiWidget)((Object)((ElementWidget)((Object)((ElementWidget)((Object)new PonderButton(bX += 50 + spacing, bY).withShortcut(bindings.field_74370_x))).showing(AllIcons.I_MTD_LEFT))).enableFade(0, 5))).withCallback(() -> this.scroll(false)));
        this.widgets.add(this.left);
        this.close = (PonderButton)((Object)((AbstractSimiWidget)((Object)((ElementWidget)((Object)((ElementWidget)((Object)new PonderButton(bX += 20 + spacing, bY).withShortcut(bindings.field_151445_Q))).showing(AllIcons.I_MTD_CLOSE))).enableFade(0, 5))).withCallback(this::func_231175_as__));
        this.widgets.add(this.close);
        this.right = (PonderButton)((Object)((AbstractSimiWidget)((Object)((ElementWidget)((Object)((ElementWidget)((Object)new PonderButton(bX += 20 + spacing, bY).withShortcut(bindings.field_74366_z))).showing(AllIcons.I_MTD_RIGHT))).enableFade(0, 5))).withCallback(() -> this.scroll(true)));
        this.widgets.add(this.right);
        this.replay = (PonderButton)((Object)((AbstractSimiWidget)((Object)((ElementWidget)((Object)((ElementWidget)((Object)new PonderButton(bX += 50 + spacing, bY).withShortcut(bindings.field_74368_y))).showing(AllIcons.I_MTD_REPLAY))).enableFade(0, 5))).withCallback(this::replay));
        this.widgets.add(this.replay);
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        if (this.skipCooling > 0) {
            --this.skipCooling;
        }
        if (this.referredToByTag != null) {
            for (int i = 0; i < this.scenes.size(); ++i) {
                PonderScene ponderScene = this.scenes.get(i);
                if (!ponderScene.tags.contains(this.referredToByTag)) continue;
                if (i == this.index) break;
                this.scenes.get(this.index).fadeOut();
                this.index = i;
                this.scenes.get(this.index).begin();
                this.lazyIndex.chase(this.index, 0.25, LerpedFloat.Chaser.EXP);
                this.identifyMode = false;
                break;
            }
            this.referredToByTag = null;
        }
        this.lazyIndex.tickChaser();
        this.fadeIn.tickChaser();
        this.finishingFlash.tickChaser();
        PonderScene activeScene = this.scenes.get(this.index);
        this.extendedTickLength = 0;
        if (this.isComfyReadingEnabled()) {
            activeScene.forEachVisible(TextWindowElement.class, twe -> {
                this.extendedTickLength = 2;
            });
        }
        if (this.extendedTickTimer == 0) {
            float lazyIndexValue;
            if (!this.identifyMode) {
                ++ponderTicks;
                if (this.skipCooling == 0) {
                    activeScene.tick();
                }
            }
            if (!this.identifyMode && Math.abs((lazyIndexValue = this.lazyIndex.getValue()) - (float)this.index) > 0.001953125f) {
                this.scenes.get(lazyIndexValue < (float)this.index ? this.index - 1 : this.index + 1).tick();
            }
            this.extendedTickTimer = this.extendedTickLength;
        } else {
            --this.extendedTickTimer;
        }
        this.progressBar.tick();
        if (activeScene.currentTime == activeScene.totalTime - 1) {
            this.finishingFlashWarmup = 30;
        }
        if (this.finishingFlashWarmup > 0) {
            --this.finishingFlashWarmup;
            if (this.finishingFlashWarmup == 0) {
                this.finishingFlash.setValue(1.0);
                this.finishingFlash.setValue(1.0);
            }
        }
        this.updateIdentifiedItem(activeScene);
    }

    public PonderScene getActiveScene() {
        return this.scenes.get(this.index);
    }

    public void seekToTime(int time) {
        if (this.getActiveScene().currentTime > time) {
            this.replay();
        }
        this.getActiveScene().seekToTime(time);
        if (time != 0) {
            this.coolDownAfterSkip();
        }
    }

    public void updateIdentifiedItem(PonderScene activeScene) {
        this.hoveredTooltipItem = ItemStack.field_190927_a;
        this.hoveredBlockPos = null;
        if (!this.identifyMode) {
            return;
        }
        MainWindow w = this.field_230706_i_.func_228018_at_();
        double mouseX = this.field_230706_i_.field_71417_B.func_198024_e() * (double)w.func_198107_o() / (double)w.func_198105_m();
        double mouseY = this.field_230706_i_.field_71417_B.func_198026_f() * (double)w.func_198087_p() / (double)w.func_198083_n();
        PonderScene.SceneTransform t = activeScene.getTransform();
        Vector3d vec1 = t.screenToScene(mouseX, mouseY, 1000, 0.0f);
        Vector3d vec2 = t.screenToScene(mouseX, mouseY, -100, 0.0f);
        Pair<ItemStack, BlockPos> pair = activeScene.rayTraceScene(vec1, vec2);
        this.hoveredTooltipItem = pair.getFirst();
        this.hoveredBlockPos = pair.getSecond();
    }

    @Override
    public boolean func_231043_a_(double mouseX, double mouseY, double delta) {
        if (this.scroll(delta > 0.0)) {
            return true;
        }
        return super.func_231043_a_(mouseX, mouseY, delta);
    }

    protected void replay() {
        this.identifyMode = false;
        PonderScene scene = this.scenes.get(this.index);
        if (PonderUI.func_231173_s_()) {
            List<PonderStoryBoardEntry> list = PonderRegistry.ALL.get(scene.component);
            PonderStoryBoardEntry sb = list.get(this.index);
            Template activeTemplate = PonderRegistry.loadSchematic(sb.getSchematicLocation());
            PonderWorld world = new PonderWorld(BlockPos.field_177992_a, (World)Minecraft.func_71410_x().field_71441_e);
            activeTemplate.func_237152_b_((IServerWorld)world, BlockPos.field_177992_a, new PlacementSettings(), new Random());
            world.createBackup();
            scene = PonderRegistry.compileScene(this.index, sb, world);
            scene.begin();
            this.scenes.set(this.index, scene);
        }
        scene.begin();
    }

    protected boolean scroll(boolean forward) {
        int prevIndex = this.index;
        this.index = forward ? this.index + 1 : this.index - 1;
        this.index = MathHelper.func_76125_a((int)this.index, (int)0, (int)(this.scenes.size() - 1));
        if (prevIndex != this.index) {
            this.scenes.get(prevIndex).fadeOut();
            this.scenes.get(this.index).begin();
            this.lazyIndex.chase(this.index, 0.25, LerpedFloat.Chaser.EXP);
            this.identifyMode = false;
            return true;
        }
        this.index = prevIndex;
        return false;
    }

    @Override
    protected void renderWindow(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        partialTicks = PonderUI.getPartialTicks();
        RenderSystem.enableBlend();
        this.renderVisibleScenes(ms, mouseX, mouseY, this.skipCooling > 0 ? 0.0f : (this.identifyMode ? ponderPartialTicksPaused : partialTicks));
        this.renderWidgets(ms, mouseX, mouseY, this.identifyMode ? ponderPartialTicksPaused : partialTicks);
    }

    public void func_230446_a_(MatrixStack ms) {
        super.func_230446_a_(ms);
    }

    protected void renderVisibleScenes(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        this.renderScene(ms, mouseX, mouseY, this.index, partialTicks);
        float lazyIndexValue = this.lazyIndex.getValue(partialTicks);
        if (Math.abs(lazyIndexValue - (float)this.index) > 0.001953125f) {
            this.renderScene(ms, mouseX, mouseY, lazyIndexValue < (float)this.index ? this.index - 1 : this.index + 1, partialTicks);
        }
    }

    protected void renderScene(MatrixStack ms, int mouseX, int mouseY, int i, float partialTicks) {
        float flash;
        SuperRenderTypeBuffer buffer = SuperRenderTypeBuffer.getInstance();
        PonderScene story = this.scenes.get(i);
        double value = this.lazyIndex.getValue(this.field_230706_i_.func_184121_ak());
        double diff = (double)i - value;
        double slide = MathHelper.func_219803_d((double)(diff * diff), (double)200.0, (double)600.0) * diff;
        RenderSystem.enableAlphaTest();
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)0.0, (double)0.0, (double)800.0);
        ms.func_227860_a_();
        ms.func_227861_a_(0.0, 0.0, -800.0);
        story.transform.updateScreenParams(this.field_230708_k_, this.field_230709_l_, slide);
        story.transform.apply(ms, partialTicks, false);
        story.transform.updateSceneRVE(partialTicks);
        story.renderScene(buffer, ms, partialTicks);
        buffer.draw();
        MutableBoundingBox bounds = story.getBounds();
        ms.func_227860_a_();
        RenderSystem.enableCull();
        RenderSystem.enableDepthTest();
        ms.func_227860_a_();
        ms.func_227861_a_((double)story.basePlateOffsetX, 0.0, (double)story.basePlateOffsetZ);
        ms.func_227862_a_(1.0f, -1.0f, 1.0f);
        float alpha = flash = this.finishingFlash.getValue(partialTicks) * 0.9f;
        flash *= flash;
        flash = flash * 2.0f - 1.0f;
        flash *= flash;
        flash = 1.0f - flash;
        for (int f = 0; f < 4; ++f) {
            ms.func_227861_a_((double)story.basePlateSize, 0.0, 0.0);
            ms.func_227860_a_();
            ms.func_227861_a_(0.0, 0.0, -9.765625E-4);
            if (flash > 0.0f) {
                ms.func_227860_a_();
                ms.func_227862_a_(1.0f, 0.5f + flash * 0.75f, 1.0f);
                GuiUtils.drawGradientRect((Matrix4f)ms.func_227866_c_().func_227870_a_(), (int)0, (int)0, (int)-1, (int)(-story.basePlateSize), (int)0, (int)13041609, (int)new Color(-1429798967).scaleAlpha(alpha).getRGB());
                ms.func_227865_b_();
            }
            ms.func_227861_a_(0.0, 0.0, 0.001953125);
            GuiUtils.drawGradientRect((Matrix4f)ms.func_227866_c_().func_227870_a_(), (int)0, (int)0, (int)0, (int)(-story.basePlateSize), (int)4, (int)0x66000000, (int)0);
            ms.func_227865_b_();
            ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
        }
        ms.func_227865_b_();
        RenderSystem.disableCull();
        RenderSystem.disableDepthTest();
        ms.func_227865_b_();
        ms.func_227865_b_();
        RenderSystem.popMatrix();
    }

    protected void renderWidgets(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        boolean finished;
        RenderSystem.disableDepthTest();
        float fade = this.fadeIn.getValue(partialTicks);
        float lazyIndexValue = this.lazyIndex.getValue(partialTicks);
        float indexDiff = Math.abs(lazyIndexValue - (float)this.index);
        PonderScene activeScene = this.scenes.get(this.index);
        boolean noWidgetsHovered = true;
        for (Widget widget : this.widgets) {
            noWidgetsHovered &= !widget.func_231047_b_((double)mouseX, (double)mouseY);
        }
        int tooltipColor = Theme.i(Theme.Key.TEXT_DARKER);
        ms.func_227860_a_();
        ms.func_227861_a_(0.0, 0.0, 400.0);
        int x = 59;
        int y = 31;
        String title = activeScene.getTitle();
        int wordWrappedHeight = this.field_230712_o_.func_78267_b(title, this.left.field_230690_l_ - 51);
        int streakHeight = 26 + wordWrappedHeight;
        UIRenderHelper.streak(ms, 0.0f, x - 4, y - 12 + streakHeight / 2, streakHeight, (int)(150.0f * fade));
        UIRenderHelper.streak(ms, 180.0f, x - 4, y - 12 + streakHeight / 2, streakHeight, (int)(30.0f * fade));
        ((RenderElement)((RenderElement)((RenderElement)((BoxElement)new BoxElement().withBackground(Theme.c(Theme.Key.PONDER_BACKGROUND_FLAT))).gradientBorder(Theme.p(Theme.Key.PONDER_IDLE))).at(21.0f, 21.0f, 100.0f)).withBounds(30, 30)).render(ms);
        ((RenderElement)GuiGameElement.of(this.stack).scale(2.0).at(x - 39, y - 11)).render(ms);
        this.field_230712_o_.func_243248_b(ms, (ITextComponent)Lang.translate(PONDERING, new Object[0]), (float)x, (float)(y - 6), tooltipColor);
        ms.func_227861_a_((double)(x += 0), (double)(y += 8), 0.0);
        ms.func_227863_a_(Vector3f.field_229178_a_.func_229187_a_(indexDiff * -75.0f));
        ms.func_227861_a_(0.0, 0.0, 5.0);
        FontHelper.drawSplitString(ms, this.field_230712_o_, title, 0, 0, this.left.field_230690_l_ - 51, Theme.c(Theme.Key.TEXT).scaleAlpha(1.0f - indexDiff).getRGB());
        ms.func_227865_b_();
        if (this.chapter != null) {
            ms.func_227860_a_();
            ms.func_227861_a_((double)(this.chap.field_230690_l_ - 4 - 4), (double)this.chap.field_230691_m_, 0.0);
            UIRenderHelper.streak(ms, 180.0f, 4, 10, 26, (int)(150.0f * fade));
            this.drawRightAlignedString(this.field_230712_o_, ms, Lang.translate(IN_CHAPTER, new Object[0]).getString(), 0, 0, tooltipColor);
            this.drawRightAlignedString(this.field_230712_o_, ms, this.chapter.getTitle(), 0, 12, Theme.i(Theme.Key.TEXT));
            ms.func_227865_b_();
        }
        Color c1 = Theme.c(Theme.Key.PONDER_BACK_ARROW).setAlpha(64);
        Color c2 = Theme.c(Theme.Key.PONDER_BACK_ARROW).setAlpha(32);
        Color c3 = Theme.c(Theme.Key.PONDER_BACK_ARROW).setAlpha(16);
        UIRenderHelper.breadcrumbArrow(ms, this.field_230708_k_ / 2 - 20, this.field_230709_l_ - 51, 0, 20, 20, 5, c1, c2);
        UIRenderHelper.breadcrumbArrow(ms, this.field_230708_k_ / 2 + 20, this.field_230709_l_ - 51, 0, -20, 20, -5, c1, c2);
        UIRenderHelper.breadcrumbArrow(ms, this.field_230708_k_ / 2 - 90, this.field_230709_l_ - 51, 0, 70, 20, 5, c1, c3);
        UIRenderHelper.breadcrumbArrow(ms, this.field_230708_k_ / 2 + 90, this.field_230709_l_ - 51, 0, -70, 20, -5, c1, c3);
        if (this.identifyMode) {
            if (noWidgetsHovered && mouseY < this.field_230709_l_ - 80) {
                ms.func_227860_a_();
                ms.func_227861_a_((double)mouseX, (double)mouseY, 100.0);
                if (this.hoveredTooltipItem.func_190926_b()) {
                    IFormattableTextComponent text = Lang.translate(IDENTIFY_MODE, ((IFormattableTextComponent)this.field_230706_i_.field_71474_y.field_74316_C.func_238171_j_()).func_240699_a_(TextFormatting.WHITE)).func_240699_a_(TextFormatting.GRAY);
                    this.renderWrappedToolTip(ms, this.field_230712_o_.func_238420_b_().func_238362_b_((ITextProperties)text, this.field_230708_k_ / 3, Style.field_240709_b_), 0, 0, this.field_230712_o_);
                } else {
                    this.func_230457_a_(ms, this.hoveredTooltipItem, 0, 0);
                }
                if (this.hoveredBlockPos != null) {
                    // empty if block
                }
                ms.func_227865_b_();
            }
            this.scan.flash();
        } else {
            this.scan.dim();
        }
        if (this.isComfyReadingEnabled()) {
            this.slowMode.flash();
        } else {
            this.slowMode.dim();
        }
        float scenePT = this.skipCooling > 0 ? 0.0f : partialTicks;
        ms.func_227860_a_();
        ms.func_227861_a_(0.0, 0.0, 100.0);
        this.renderOverlay(ms, this.index, scenePT);
        if (indexDiff > 0.001953125f) {
            this.renderOverlay(ms, lazyIndexValue < (float)this.index ? this.index - 1 : this.index + 1, scenePT);
        }
        ms.func_227865_b_();
        this.widgets.forEach(w -> {
            if (w instanceof PonderButton) {
                ((PonderButton)((Object)w)).fade().startWithValue(fade);
            }
        });
        if (this.index == 0 || this.index == 1 && lazyIndexValue < (float)this.index) {
            this.left.fade().startWithValue(lazyIndexValue);
        }
        if (this.index == this.scenes.size() - 1 || this.index == this.scenes.size() - 2 && lazyIndexValue > (float)this.index) {
            this.right.fade().startWithValue((float)this.scenes.size() - lazyIndexValue - 1.0f);
        }
        if (finished = activeScene.isFinished()) {
            this.right.flash();
        } else {
            this.right.dim();
        }
        List<PonderTag> sceneTags = activeScene.tags;
        boolean highlightAll = sceneTags.contains(PonderTag.Highlight.ALL);
        double s = Minecraft.func_71410_x().func_228018_at_().func_198100_s();
        IntStream.range(0, this.tagButtons.size()).forEach(i -> {
            ms.func_227860_a_();
            LerpedFloat chase = this.tagFades.get(i);
            PonderButton button = this.tagButtons.get(i);
            if (button.func_231047_b_(mouseX, mouseY)) {
                chase.updateChaseTarget(1.0f);
            } else {
                chase.updateChaseTarget(0.0f);
            }
            chase.tickChaser();
            if (highlightAll) {
                button.flash();
            } else {
                button.dim();
            }
            int x = button.field_230690_l_ + button.func_230998_h_() + 4;
            int y = button.field_230691_m_ - 2;
            ms.func_227861_a_((double)x, (double)((float)y + 5.0f * (1.0f - fade)), 800.0);
            float fadedWidth = 200.0f * chase.getValue(partialTicks);
            UIRenderHelper.streak(ms, 0.0f, 0, 12, 26, (int)fadedWidth);
            GL11.glScissor((int)((int)((double)x * s)), (int)0, (int)((int)((double)fadedWidth * s)), (int)((int)((double)this.field_230709_l_ * s)));
            GL11.glEnable((int)3089);
            String tagName = this.tags.get(i).getTitle();
            this.field_230712_o_.func_238421_b_(ms, tagName, 3.0f, 8.0f, Theme.i(Theme.Key.TEXT_ACCENT_SLIGHT));
            GL11.glDisable((int)3089);
            ms.func_227865_b_();
        });
        ms.func_227860_a_();
        ms.func_227861_a_(0.0, 0.0, 500.0);
        int tooltipY = this.field_230709_l_ - 16;
        if (this.scan.func_230449_g_()) {
            PonderUI.func_238472_a_((MatrixStack)ms, (FontRenderer)this.field_230712_o_, (ITextComponent)Lang.translate(IDENTIFY, new Object[0]), (int)(this.scan.field_230690_l_ + 10), (int)tooltipY, (int)tooltipColor);
        }
        if (this.index != 0 && this.left.func_230449_g_()) {
            PonderUI.func_238472_a_((MatrixStack)ms, (FontRenderer)this.field_230712_o_, (ITextComponent)Lang.translate(PREVIOUS, new Object[0]), (int)(this.left.field_230690_l_ + 10), (int)tooltipY, (int)tooltipColor);
        }
        if (this.close.func_230449_g_()) {
            PonderUI.func_238472_a_((MatrixStack)ms, (FontRenderer)this.field_230712_o_, (ITextComponent)Lang.translate(CLOSE, new Object[0]), (int)(this.close.field_230690_l_ + 10), (int)tooltipY, (int)tooltipColor);
        }
        if (this.index != this.scenes.size() - 1 && this.right.func_230449_g_()) {
            PonderUI.func_238472_a_((MatrixStack)ms, (FontRenderer)this.field_230712_o_, (ITextComponent)Lang.translate(NEXT, new Object[0]), (int)(this.right.field_230690_l_ + 10), (int)tooltipY, (int)tooltipColor);
        }
        if (this.replay.func_230449_g_()) {
            PonderUI.func_238472_a_((MatrixStack)ms, (FontRenderer)this.field_230712_o_, (ITextComponent)Lang.translate(REPLAY, new Object[0]), (int)(this.replay.field_230690_l_ + 10), (int)tooltipY, (int)tooltipColor);
        }
        if (this.slowMode.func_230449_g_()) {
            PonderUI.func_238472_a_((MatrixStack)ms, (FontRenderer)this.field_230712_o_, (ITextComponent)Lang.translate(SLOW_TEXT, new Object[0]), (int)(this.slowMode.field_230690_l_ + 5), (int)tooltipY, (int)tooltipColor);
        }
        ms.func_227865_b_();
        RenderSystem.enableDepthTest();
    }

    private void renderOverlay(MatrixStack ms, int i, float partialTicks) {
        if (this.identifyMode) {
            return;
        }
        ms.func_227860_a_();
        PonderScene story = this.scenes.get(i);
        story.renderOverlay(this, ms, this.skipCooling > 0 ? 0.0f : (this.identifyMode ? ponderPartialTicksPaused : partialTicks));
        ms.func_227865_b_();
    }

    @Override
    public boolean func_231044_a_(double x, double y, int button) {
        if (!this.identifyMode || this.hoveredBlockPos != null) {
            // empty if block
        }
        return super.func_231044_a_(x, y, button);
    }

    @Override
    public boolean func_231046_a_(int code, int p_keyPressed_2_, int p_keyPressed_3_) {
        GameSettings settings = Minecraft.func_71410_x().field_71474_y;
        int sCode = settings.field_74368_y.getKey().func_197937_c();
        int aCode = settings.field_74370_x.getKey().func_197937_c();
        int dCode = settings.field_74366_z.getKey().func_197937_c();
        int qCode = settings.field_74316_C.getKey().func_197937_c();
        if (code == sCode) {
            this.replay();
            return true;
        }
        if (code == aCode) {
            this.scroll(false);
            return true;
        }
        if (code == dCode) {
            this.scroll(true);
            return true;
        }
        if (code == qCode) {
            boolean bl = this.identifyMode = !this.identifyMode;
            if (!this.identifyMode) {
                this.scenes.get(this.index).deselect();
            }
            return true;
        }
        return super.func_231046_a_(code, p_keyPressed_2_, p_keyPressed_3_);
    }

    @Override
    protected String getBreadcrumbTitle() {
        if (this.chapter != null) {
            return this.chapter.getTitle();
        }
        return this.stack.func_77973_b().func_200296_o().getString();
    }

    public FontRenderer getFontRenderer() {
        return this.field_230712_o_;
    }

    protected boolean isMouseOver(double mouseX, double mouseY, int x, int y, int w, int h) {
        boolean hovered = !(mouseX < (double)x) && !(mouseX > (double)(x + w));
        return hovered &= !(mouseY < (double)y) && !(mouseY > (double)(y + h));
    }

    public static void renderSpeechBox(MatrixStack ms, int x, int y, int w, int h, boolean highlighted, Pointing pointing, boolean returnWithLocalTransform) {
        Color c;
        if (!returnWithLocalTransform) {
            ms.func_227860_a_();
        }
        int boxX = x;
        int boxY = y;
        int divotX = x;
        int divotY = y;
        int divotRotation = 0;
        int divotSize = 8;
        int distance = 1;
        int divotRadius = divotSize / 2;
        Couple<Color> borderColors = Theme.p(highlighted ? Theme.Key.PONDER_HIGHLIGHT : Theme.Key.PONDER_IDLE);
        switch (pointing) {
            default: {
                divotRotation = 0;
                boxX -= w / 2;
                boxY -= h + divotSize + 1 + distance;
                divotX -= divotRadius;
                divotY -= divotSize + distance;
                c = (Color)borderColors.getSecond();
                break;
            }
            case LEFT: {
                divotRotation = 90;
                boxX += divotSize + 1 + distance;
                boxY -= h / 2;
                divotX += distance;
                divotY -= divotRadius;
                c = Color.mixColors(borderColors, 0.5f);
                break;
            }
            case RIGHT: {
                divotRotation = 270;
                boxX -= w + divotSize + 1 + distance;
                boxY -= h / 2;
                divotX -= divotSize + distance;
                divotY -= divotRadius;
                c = Color.mixColors(borderColors, 0.5f);
                break;
            }
            case UP: {
                divotRotation = 180;
                boxX -= w / 2;
                boxY += divotSize + 1 + distance;
                divotX -= divotRadius;
                divotY += distance;
                c = (Color)borderColors.getFirst();
            }
        }
        ((RenderElement)((RenderElement)((RenderElement)((BoxElement)new BoxElement().withBackground(Theme.c(Theme.Key.PONDER_BACKGROUND_FLAT))).gradientBorder(borderColors)).at(boxX, boxY, 100.0f)).withBounds(w, h)).render(ms);
        ms.func_227860_a_();
        ms.func_227861_a_((double)(divotX + divotRadius), (double)(divotY + divotRadius), 10.0);
        ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)divotRotation));
        ms.func_227861_a_((double)(-divotRadius), (double)(-divotRadius), 0.0);
        AllGuiTextures.SPEECH_TOOLTIP_BACKGROUND.draw(ms, 0, 0);
        AllGuiTextures.SPEECH_TOOLTIP_COLOR.draw(ms, 0, 0, c);
        ms.func_227865_b_();
        if (returnWithLocalTransform) {
            ms.func_227861_a_((double)boxX, (double)boxY, 0.0);
            return;
        }
        ms.func_227865_b_();
    }

    public ItemStack getHoveredTooltipItem() {
        return this.hoveredTooltipItem;
    }

    public ItemStack getSubject() {
        return this.stack;
    }

    @Override
    public boolean isEquivalentTo(NavigatableSimiScreen other) {
        if (other instanceof PonderUI) {
            return this.stack.func_77969_a(((PonderUI)other).stack);
        }
        return super.isEquivalentTo(other);
    }

    @Override
    public void shareContextWith(NavigatableSimiScreen other) {
        if (other instanceof PonderUI) {
            PonderUI ponderUI = (PonderUI)other;
            ponderUI.referredToByTag = this.referredToByTag;
        }
    }

    public static float getPartialTicks() {
        float renderPartialTicks = Minecraft.func_71410_x().func_184121_ak();
        if (Minecraft.func_71410_x().field_71462_r instanceof PonderUI) {
            PonderUI ui = (PonderUI)Minecraft.func_71410_x().field_71462_r;
            if (ui.identifyMode) {
                return ponderPartialTicksPaused;
            }
            return (renderPartialTicks + (float)(ui.extendedTickLength - ui.extendedTickTimer)) / (float)(ui.extendedTickLength + 1);
        }
        return renderPartialTicks;
    }

    @Override
    public boolean func_231177_au__() {
        return true;
    }

    public void coolDownAfterSkip() {
        this.skipCooling = 15;
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        this.hoveredTooltipItem = ItemStack.field_190927_a;
    }

    public void drawRightAlignedString(FontRenderer fontRenderer, MatrixStack ms, String string, int x, int y, int color) {
        fontRenderer.func_238421_b_(ms, string, (float)(x - fontRenderer.func_78256_a(string)), (float)y, color);
    }

    public boolean isComfyReadingEnabled() {
        return (Boolean)AllConfigs.CLIENT.comfyReading.get();
    }

    public void setComfyReadingEnabled(boolean slowTextMode) {
        AllConfigs.CLIENT.comfyReading.set(slowTextMode);
    }

    private /* synthetic */ void lambda$init$4() {
        this.userViewMode = !this.userViewMode;
    }
}

