/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.fluid;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.fluids.actors.GenericItemFilling;
import com.simibubi.create.content.contraptions.fluids.tank.CreativeFluidTankTileEntity;
import com.simibubi.create.content.contraptions.processing.EmptyingByBasin;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.utility.Pair;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidHelper {
    public static boolean isWater(Fluid fluid) {
        return FluidHelper.convertToStill(fluid) == Fluids.field_204546_a;
    }

    public static boolean isLava(Fluid fluid) {
        return FluidHelper.convertToStill(fluid) == Fluids.field_204547_b;
    }

    public static boolean hasBlockState(Fluid fluid) {
        BlockState blockState = fluid.func_207188_f().func_206883_i();
        return blockState != null && blockState != Blocks.field_150350_a.func_176223_P();
    }

    public static FluidStack copyStackWithAmount(FluidStack fs, int amount) {
        if (fs.isEmpty()) {
            return FluidStack.EMPTY;
        }
        FluidStack copy = fs.copy();
        copy.setAmount(amount);
        return copy;
    }

    public static Fluid convertToFlowing(Fluid fluid) {
        if (fluid == Fluids.field_204546_a) {
            return Fluids.field_207212_b;
        }
        if (fluid == Fluids.field_204547_b) {
            return Fluids.field_207213_d;
        }
        if (fluid instanceof ForgeFlowingFluid) {
            return ((ForgeFlowingFluid)fluid).func_210197_e();
        }
        return fluid;
    }

    public static Fluid convertToStill(Fluid fluid) {
        if (fluid == Fluids.field_207212_b) {
            return Fluids.field_204546_a;
        }
        if (fluid == Fluids.field_207213_d) {
            return Fluids.field_204547_b;
        }
        if (fluid instanceof ForgeFlowingFluid) {
            return ((ForgeFlowingFluid)fluid).func_210198_f();
        }
        return fluid;
    }

    public static JsonElement serializeFluidStack(FluidStack stack) {
        JsonObject json = new JsonObject();
        json.addProperty("fluid", stack.getFluid().getRegistryName().toString());
        json.addProperty("amount", (Number)stack.getAmount());
        if (stack.hasTag()) {
            json.addProperty("nbt", stack.getTag().toString());
        }
        return json;
    }

    public static FluidStack deserializeFluidStack(JsonObject json) {
        ResourceLocation id = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"fluid"));
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(id);
        if (fluid == null) {
            throw new JsonSyntaxException("Unknown fluid '" + id + "'");
        }
        int amount = JSONUtils.func_151203_m((JsonObject)json, (String)"amount");
        FluidStack stack = new FluidStack(fluid, amount);
        if (!json.has("nbt")) {
            return stack;
        }
        try {
            JsonElement element = json.get("nbt");
            stack.setTag(JsonToNBT.func_180713_a((String)(element.isJsonObject() ? Create.GSON.toJson(element) : JSONUtils.func_151206_a((JsonElement)element, (String)"nbt"))));
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
        }
        return stack;
    }

    public static boolean tryEmptyItemIntoTE(World worldIn, PlayerEntity player, Hand handIn, ItemStack heldItem, SmartTileEntity te) {
        if (!EmptyingByBasin.canItemBeEmptied(worldIn, heldItem)) {
            return false;
        }
        Pair<FluidStack, ItemStack> emptyingResult = EmptyingByBasin.emptyItem(worldIn, heldItem, true);
        LazyOptional capability = te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
        IFluidHandler tank = (IFluidHandler)capability.orElse(null);
        FluidStack fluidStack = emptyingResult.getFirst();
        if (tank == null || fluidStack.getAmount() != tank.fill(fluidStack, IFluidHandler.FluidAction.SIMULATE)) {
            return false;
        }
        if (worldIn.field_72995_K) {
            return true;
        }
        ItemStack copyOfHeld = heldItem.func_77946_l();
        emptyingResult = EmptyingByBasin.emptyItem(worldIn, copyOfHeld, false);
        tank.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
        if (!player.func_184812_l_() && !(te instanceof CreativeFluidTankTileEntity)) {
            if (copyOfHeld.func_190926_b()) {
                player.func_184611_a(handIn, emptyingResult.getSecond());
            } else {
                player.func_184611_a(handIn, copyOfHeld);
                player.field_71071_by.func_191975_a(worldIn, emptyingResult.getSecond());
            }
        }
        return true;
    }

    public static boolean tryFillItemFromTE(World world, PlayerEntity player, Hand handIn, ItemStack heldItem, SmartTileEntity te) {
        if (!GenericItemFilling.canItemBeFilled(world, heldItem)) {
            return false;
        }
        LazyOptional capability = te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
        IFluidHandler tank = (IFluidHandler)capability.orElse(null);
        if (tank == null) {
            return false;
        }
        for (int i = 0; i < tank.getTanks(); ++i) {
            int requiredAmountForItem;
            FluidStack fluid = tank.getFluidInTank(i);
            if (fluid.isEmpty() || (requiredAmountForItem = GenericItemFilling.getRequiredAmountForItem(world, heldItem, fluid.copy())) == -1 || requiredAmountForItem > fluid.getAmount()) continue;
            if (world.field_72995_K) {
                return true;
            }
            if (player.func_184812_l_() || te instanceof CreativeFluidTankTileEntity) {
                heldItem = heldItem.func_77946_l();
            }
            ItemStack out = GenericItemFilling.fillItem(world, requiredAmountForItem, heldItem, fluid.copy());
            FluidStack copy = fluid.copy();
            copy.setAmount(requiredAmountForItem);
            tank.drain(copy, IFluidHandler.FluidAction.EXECUTE);
            if (!player.func_184812_l_()) {
                player.field_71071_by.func_191975_a(world, out);
            }
            te.notifyUpdate();
            return true;
        }
        return false;
    }

    @Nullable
    public static FluidExchange exchange(IFluidHandler fluidTank, IFluidHandlerItem fluidItem, FluidExchange preferred, int maxAmount) {
        return FluidHelper.exchange(fluidTank, fluidItem, preferred, true, maxAmount);
    }

    @Nullable
    public static FluidExchange exchangeAll(IFluidHandler fluidTank, IFluidHandlerItem fluidItem, FluidExchange preferred) {
        return FluidHelper.exchange(fluidTank, fluidItem, preferred, false, Integer.MAX_VALUE);
    }

    @Nullable
    private static FluidExchange exchange(IFluidHandler fluidTank, IFluidHandlerItem fluidItem, FluidExchange preferred, boolean singleOp, int maxTransferAmountPerTank) {
        FluidExchange lockedExchange = null;
        for (int tankSlot = 0; tankSlot < fluidTank.getTanks(); ++tankSlot) {
            for (int slot = 0; slot < fluidItem.getTanks(); ++slot) {
                int amount;
                boolean canMoveToItem;
                FluidStack fluidInTank = fluidTank.getFluidInTank(tankSlot);
                int tankCapacity = fluidTank.getTankCapacity(tankSlot) - fluidInTank.getAmount();
                boolean tankEmpty = fluidInTank.isEmpty();
                FluidStack fluidInItem = fluidItem.getFluidInTank(tankSlot);
                int itemCapacity = fluidItem.getTankCapacity(tankSlot) - fluidInItem.getAmount();
                boolean itemEmpty = fluidInItem.isEmpty();
                boolean undecided = lockedExchange == null;
                boolean canMoveToTank = (undecided || lockedExchange == FluidExchange.ITEM_TO_TANK) && tankCapacity > 0;
                boolean bl = canMoveToItem = (undecided || lockedExchange == FluidExchange.TANK_TO_ITEM) && itemCapacity > 0;
                if (!tankEmpty && !itemEmpty && !fluidInItem.isFluidEqual(fluidInTank)) continue;
                if (((tankEmpty || itemCapacity <= 0) && canMoveToTank || undecided && preferred == FluidExchange.ITEM_TO_TANK) && (amount = fluidTank.fill(fluidItem.drain(Math.min(maxTransferAmountPerTank, tankCapacity), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE)) > 0) {
                    lockedExchange = FluidExchange.ITEM_TO_TANK;
                    if (!singleOp) continue;
                    return lockedExchange;
                }
                if ((!itemEmpty && tankCapacity > 0 || !canMoveToItem) && (!undecided || preferred != FluidExchange.TANK_TO_ITEM) || (amount = fluidItem.fill(fluidTank.drain(Math.min(maxTransferAmountPerTank, itemCapacity), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE)) <= 0) continue;
                lockedExchange = FluidExchange.TANK_TO_ITEM;
                if (!singleOp) continue;
                return lockedExchange;
            }
        }
        return null;
    }

    public static enum FluidExchange {
        ITEM_TO_TANK,
        TANK_TO_ITEM;

    }
}

