/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics.packet;

import com.simibubi.create.AllItems;
import com.simibubi.create.content.schematics.filtering.SchematicInstances;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraftforge.fml.network.NetworkEvent;

public class SchematicSyncPacket
extends SimplePacketBase {
    public int slot;
    public boolean deployed;
    public BlockPos anchor;
    public Rotation rotation;
    public Mirror mirror;

    public SchematicSyncPacket(int slot, PlacementSettings settings, BlockPos anchor, boolean deployed) {
        this.slot = slot;
        this.deployed = deployed;
        this.anchor = anchor;
        this.rotation = settings.func_186215_c();
        this.mirror = settings.func_186212_b();
    }

    public SchematicSyncPacket(PacketBuffer buffer) {
        this.slot = buffer.func_150792_a();
        this.deployed = buffer.readBoolean();
        this.anchor = buffer.func_179259_c();
        this.rotation = (Rotation)buffer.func_179257_a(Rotation.class);
        this.mirror = (Mirror)buffer.func_179257_a(Mirror.class);
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.func_150787_b(this.slot);
        buffer.writeBoolean(this.deployed);
        buffer.func_179255_a(this.anchor);
        buffer.func_179249_a((Enum)this.rotation);
        buffer.func_179249_a((Enum)this.mirror);
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)context.get()).getSender();
            if (player == null) {
                return;
            }
            ItemStack stack = ItemStack.field_190927_a;
            stack = this.slot == -1 ? player.func_184614_ca() : player.field_71071_by.func_70301_a(this.slot);
            if (!AllItems.SCHEMATIC.isIn(stack)) {
                return;
            }
            CompoundNBT tag = stack.func_196082_o();
            tag.func_74757_a("Deployed", this.deployed);
            tag.func_218657_a("Anchor", (INBT)NBTUtil.func_186859_a((BlockPos)this.anchor));
            tag.func_74778_a("Rotation", this.rotation.name());
            tag.func_74778_a("Mirror", this.mirror.name());
            SchematicInstances.clearHash(stack);
        });
        context.get().setPacketHandled(true);
    }
}

