/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics.packet;

import com.simibubi.create.content.schematics.SchematicPrinter;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import com.simibubi.create.foundation.utility.BlockHelper;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;

public class SchematicPlacePacket
extends SimplePacketBase {
    public ItemStack stack;

    public SchematicPlacePacket(ItemStack stack) {
        this.stack = stack;
    }

    public SchematicPlacePacket(PacketBuffer buffer) {
        this.stack = buffer.func_150791_c();
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.func_150788_a(this.stack);
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)context.get()).getSender();
            if (player == null) {
                return;
            }
            ServerWorld world = player.func_71121_q();
            SchematicPrinter printer = new SchematicPrinter();
            printer.loadSchematic(this.stack, (World)world, !player.func_195070_dx());
            if (!printer.isLoaded()) {
                return;
            }
            boolean includeAir = (Boolean)AllConfigs.SERVER.schematics.creativePrintIncludesAir.get();
            while (printer.advanceCurrentPos()) {
                if (!printer.shouldPlaceCurrent((World)world)) continue;
                printer.handleCurrentTarget((arg_0, arg_1, arg_2) -> SchematicPlacePacket.lambda$null$0((World)world, includeAir, arg_0, arg_1, arg_2), (arg_0, arg_1) -> SchematicPlacePacket.lambda$null$1((World)world, arg_0, arg_1));
            }
        });
        context.get().setPacketHandled(true);
    }

    private static /* synthetic */ void lambda$null$1(World world, BlockPos pos, Entity entity) {
        world.func_217376_c(entity);
    }

    private static /* synthetic */ void lambda$null$0(World world, boolean includeAir, BlockPos pos, BlockState state, TileEntity tile) {
        boolean placingAir = state.func_177230_c().isAir(state, (IBlockReader)world, pos);
        if (placingAir && !includeAir) {
            return;
        }
        CompoundNBT tileData = tile != null ? tile.func_189515_b(new CompoundNBT()) : null;
        BlockHelper.placeSchematicBlock(world, state, pos, null, tileData);
    }
}

