/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.item;

import com.jozufozu.flywheel.util.transform.MatrixTransformStack;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.logistics.item.LinkedControllerClientHandler;
import com.simibubi.create.content.logistics.item.LinkedControllerModel;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModelRenderer;
import com.simibubi.create.foundation.item.render.PartialItemModelRenderer;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.Vector;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.item.ItemStack;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.MathHelper;

public class LinkedControllerItemRenderer
extends CustomRenderedItemModelRenderer<LinkedControllerModel> {
    static LerpedFloat equipProgress = LerpedFloat.linear().startWithValue(0.0);
    static Vector<LerpedFloat> buttons = new Vector(6);

    static void tick() {
        boolean active = LinkedControllerClientHandler.MODE != LinkedControllerClientHandler.Mode.IDLE;
        equipProgress.chase(active ? 1.0 : 0.0, 0.2f, LerpedFloat.Chaser.EXP);
        equipProgress.tickChaser();
        if (!active) {
            return;
        }
        for (int i = 0; i < buttons.size(); ++i) {
            LerpedFloat lerpedFloat = buttons.get(i);
            lerpedFloat.chase(LinkedControllerClientHandler.currentlyPressed.contains(i) ? 1.0 : 0.0, 0.4f, LerpedFloat.Chaser.EXP);
            lerpedFloat.tickChaser();
        }
    }

    static void resetButtons() {
        for (int i = 0; i < buttons.size(); ++i) {
            buttons.get(i).startWithValue(0.0);
        }
    }

    @Override
    protected void render(ItemStack stack, LinkedControllerModel model, PartialItemModelRenderer renderer, ItemCameraTransforms.TransformType transformType, MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        LinkedControllerItemRenderer.renderNormal(stack, model, renderer, transformType, ms, light);
    }

    protected static void renderNormal(ItemStack stack, LinkedControllerModel model, PartialItemModelRenderer renderer, ItemCameraTransforms.TransformType transformType, MatrixStack ms, int light) {
        LinkedControllerItemRenderer.render(stack, model, renderer, transformType, ms, light, RenderType.NORMAL, false, false);
    }

    public static void renderInLectern(ItemStack stack, LinkedControllerModel model, PartialItemModelRenderer renderer, ItemCameraTransforms.TransformType transformType, MatrixStack ms, int light, boolean active, boolean renderDepression) {
        LinkedControllerItemRenderer.render(stack, model, renderer, transformType, ms, light, RenderType.LECTERN, active, renderDepression);
    }

    protected static void render(ItemStack stack, LinkedControllerModel model, PartialItemModelRenderer renderer, ItemCameraTransforms.TransformType transformType, MatrixStack ms, int light, RenderType renderType, boolean active, boolean renderDepression) {
        float pt = AnimationTickHolder.getPartialTicks();
        MatrixTransformStack msr = MatrixTransformStack.of((MatrixStack)ms);
        ms.func_227860_a_();
        if (renderType == RenderType.NORMAL) {
            boolean noControllerInMain;
            Minecraft mc = Minecraft.func_71410_x();
            boolean rightHanded = mc.field_71474_y.field_186715_A == HandSide.RIGHT;
            ItemCameraTransforms.TransformType mainHand = rightHanded ? ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND : ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND;
            ItemCameraTransforms.TransformType offHand = rightHanded ? ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND : ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND;
            active = false;
            boolean bl = noControllerInMain = !AllItems.LINKED_CONTROLLER.isIn(mc.field_71439_g.func_184614_ca());
            if (transformType == mainHand || transformType == offHand && noControllerInMain) {
                float equip = equipProgress.getValue(pt);
                int handModifier = transformType == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND ? -1 : 1;
                msr.translate(0.0, (double)(equip / 4.0f), (double)(equip / 4.0f * (float)handModifier));
                msr.rotateY((double)(equip * -30.0f * (float)handModifier));
                msr.rotateZ((double)(equip * -30.0f));
                active = true;
            }
            if (transformType == ItemCameraTransforms.TransformType.GUI) {
                if (stack == mc.field_71439_g.func_184614_ca()) {
                    active = true;
                }
                if (stack == mc.field_71439_g.func_184592_cb() && noControllerInMain) {
                    active = true;
                }
            }
            active &= LinkedControllerClientHandler.MODE != LinkedControllerClientHandler.Mode.IDLE;
            renderDepression = true;
        }
        renderer.render(active ? model.getPartial("powered") : model.getOriginalModel(), light);
        if (!active) {
            ms.func_227865_b_();
            return;
        }
        IBakedModel button = model.getPartial("button");
        float s = 0.0625f;
        float b = s * -0.75f;
        int index = 0;
        if (renderType == RenderType.NORMAL && LinkedControllerClientHandler.MODE == LinkedControllerClientHandler.Mode.BIND) {
            int i = (int)MathHelper.func_219799_g((float)((MathHelper.func_76126_a((float)(AnimationTickHolder.getRenderTime() / 4.0f)) + 1.0f) / 2.0f), (float)5.0f, (float)15.0f);
            light = i << 20;
        }
        ms.func_227860_a_();
        msr.translate((double)(2.0f * s), 0.0, (double)(8.0f * s));
        LinkedControllerItemRenderer.renderButton(renderer, ms, light, pt, button, b, index++, renderDepression);
        msr.translate((double)(4.0f * s), 0.0, 0.0);
        LinkedControllerItemRenderer.renderButton(renderer, ms, light, pt, button, b, index++, renderDepression);
        msr.translate((double)(-2.0f * s), 0.0, (double)(2.0f * s));
        LinkedControllerItemRenderer.renderButton(renderer, ms, light, pt, button, b, index++, renderDepression);
        msr.translate(0.0, 0.0, (double)(-4.0f * s));
        LinkedControllerItemRenderer.renderButton(renderer, ms, light, pt, button, b, index++, renderDepression);
        ms.func_227865_b_();
        msr.translate((double)(3.0f * s), 0.0, (double)(3.0f * s));
        LinkedControllerItemRenderer.renderButton(renderer, ms, light, pt, button, b, index++, renderDepression);
        msr.translate((double)(2.0f * s), 0.0, 0.0);
        LinkedControllerItemRenderer.renderButton(renderer, ms, light, pt, button, b, index++, renderDepression);
        ms.func_227865_b_();
    }

    protected static void renderButton(PartialItemModelRenderer renderer, MatrixStack ms, int light, float pt, IBakedModel button, float b, int index, boolean renderDepression) {
        ms.func_227860_a_();
        if (renderDepression) {
            float depression = b * buttons.get(index).getValue(pt);
            ms.func_227861_a_(0.0, (double)depression, 0.0);
        }
        renderer.renderSolid(button, light);
        ms.func_227865_b_();
    }

    static {
        for (int i = 0; i < 6; ++i) {
            buttons.add(LerpedFloat.linear().startWithValue(0.0));
        }
    }

    protected static enum RenderType {
        NORMAL,
        LECTERN;

    }
}

