/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.zapper;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.content.curiosities.zapper.PlacementPatterns;
import com.simibubi.create.foundation.gui.AbstractSimiScreen;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.GuiGameElement;
import com.simibubi.create.foundation.gui.RenderElement;
import com.simibubi.create.foundation.gui.widgets.IconButton;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.networking.NbtPacket;
import com.simibubi.create.foundation.utility.Lang;
import java.util.Vector;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.Hand;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class ZapperScreen
extends AbstractSimiScreen {
    protected ItemStack zapper;
    protected boolean offhand;
    protected float animationProgress;
    protected AllGuiTextures background;
    private IconButton confirmButton;
    protected final ITextComponent patternSection = Lang.translate("gui.terrainzapper.patternSection", new Object[0]);
    protected ITextComponent field_230704_d_;
    protected Vector<IconButton> patternButtons;
    protected int brightColor;
    protected int fontColor;

    public ZapperScreen(AllGuiTextures background, ItemStack zapper, boolean offhand) {
        this.background = background;
        this.zapper = zapper;
        this.offhand = offhand;
        this.field_230704_d_ = StringTextComponent.field_240750_d_;
        this.brightColor = 0xFEFEFE;
        this.fontColor = 5726074;
    }

    @Override
    protected void func_231160_c_() {
        this.setWindowSize(this.background.width, this.background.height);
        this.setWindowOffset(-10, 0);
        super.func_231160_c_();
        this.widgets.clear();
        this.animationProgress = 0.0f;
        int x = this.guiLeft;
        int y = this.guiTop;
        this.confirmButton = new IconButton(x + this.background.width - 33, y + this.background.height - 24, AllIcons.I_CONFIRM);
        this.widgets.add(this.confirmButton);
        CompoundNBT nbt = this.zapper.func_196082_o();
        this.patternButtons = new Vector(6);
        for (int row = 0; row <= 1; ++row) {
            for (int col = 0; col <= 2; ++col) {
                int id = this.patternButtons.size();
                PlacementPatterns pattern = PlacementPatterns.values()[id];
                this.patternButtons.add(new IconButton(x + this.background.width - 76 + col * 18, y + 21 + row * 18, pattern.icon));
                this.patternButtons.get(id).setToolTip((ITextComponent)Lang.translate("gui.terrainzapper.pattern." + pattern.translationKey, new Object[0]));
            }
        }
        if (nbt.func_74764_b("Pattern")) {
            this.patternButtons.get((int)PlacementPatterns.valueOf((String)nbt.func_74779_i((String)"Pattern")).ordinal()).field_230693_o_ = false;
        }
        this.widgets.addAll(this.patternButtons);
    }

    @Override
    protected void renderWindow(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        int x = this.guiLeft;
        int y = this.guiTop;
        this.background.draw(ms, (AbstractGui)this, x, y);
        this.drawOnBackground(ms, x, y);
        this.renderBlock(ms, x, y);
        this.renderZapper(ms, x, y);
    }

    protected void drawOnBackground(MatrixStack ms, int x, int y) {
        this.field_230712_o_.func_243248_b(ms, this.field_230704_d_, (float)(x + 11), (float)(y + 4), 5513551);
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        this.animationProgress += 5.0f;
    }

    public void func_231164_f_() {
        CompoundNBT nbt = this.zapper.func_77978_p();
        this.writeAdditionalOptions(nbt);
        AllPackets.channel.sendToServer((Object)new NbtPacket(this.zapper, this.offhand ? Hand.OFF_HAND : Hand.MAIN_HAND));
    }

    @Override
    public boolean func_231044_a_(double x, double y, int button) {
        CompoundNBT nbt = this.zapper.func_77978_p();
        for (IconButton patternButton : this.patternButtons) {
            if (!patternButton.func_230449_g_()) continue;
            this.patternButtons.forEach(b -> {
                b.field_230693_o_ = true;
            });
            patternButton.field_230693_o_ = false;
            patternButton.func_230988_a_(this.field_230706_i_.func_147118_V());
            nbt.func_74778_a("Pattern", PlacementPatterns.values()[this.patternButtons.indexOf((Object)patternButton)].name());
        }
        if (this.confirmButton.func_230449_g_()) {
            this.func_231175_as__();
            return true;
        }
        return super.func_231044_a_(x, y, button);
    }

    protected void renderZapper(MatrixStack ms, int x, int y) {
        ((RenderElement)GuiGameElement.of(this.zapper).scale(4.0).at(x + this.background.width, y + this.background.height - 48, -200.0f)).render(ms);
    }

    protected void renderBlock(MatrixStack ms, int x, int y) {
        ms.func_227860_a_();
        ms.func_227861_a_((double)(x + 32), (double)(y + 42), 120.0);
        ms.func_227863_a_(new Vector3f(1.0f, 0.0f, 0.0f).func_229187_a_(-25.0f));
        ms.func_227863_a_(new Vector3f(0.0f, 1.0f, 0.0f).func_229187_a_(-45.0f));
        ms.func_227862_a_(20.0f, 20.0f, 20.0f);
        BlockState state = Blocks.field_150350_a.func_176223_P();
        if (this.zapper.func_77942_o() && this.zapper.func_77978_p().func_74764_b("BlockUsed")) {
            state = NBTUtil.func_190008_d((CompoundNBT)this.zapper.func_77978_p().func_74775_l("BlockUsed"));
        }
        GuiGameElement.of(state).render(ms);
        ms.func_227865_b_();
    }

    protected void writeAdditionalOptions(CompoundNBT nbt) {
    }
}

