/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.weapons;

import com.jozufozu.flywheel.util.transform.MatrixTransformStack;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.content.curiosities.weapons.PotatoProjectileEntity;
import com.simibubi.create.foundation.utility.AngleHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public interface PotatoProjectileRenderMode {
    @OnlyIn(value=Dist.CLIENT)
    public void transform(MatrixStack var1, PotatoProjectileEntity var2, float var3);

    public static int entityRandom(Entity entity, int maxValue) {
        return System.identityHashCode(entity) * 31 % maxValue;
    }

    public static class StuckToEntity
    implements PotatoProjectileRenderMode {
        private Vector3d offset;

        public StuckToEntity(Vector3d offset) {
            this.offset = offset;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void transform(MatrixStack ms, PotatoProjectileEntity entity, float pt) {
            MatrixTransformStack.of((MatrixStack)ms).rotateY((double)AngleHelper.deg(MathHelper.func_181159_b((double)this.offset.field_72450_a, (double)this.offset.field_72449_c)));
        }
    }

    public static class TowardMotion
    implements PotatoProjectileRenderMode {
        private int spriteAngleOffset;
        private float spin;

        public TowardMotion(int spriteAngleOffset, float spin) {
            this.spriteAngleOffset = spriteAngleOffset;
            this.spin = spin;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void transform(MatrixStack ms, PotatoProjectileEntity entity, float pt) {
            Vector3d diff = entity.func_213322_ci();
            MatrixTransformStack.of((MatrixStack)ms).rotateY((double)AngleHelper.deg(MathHelper.func_181159_b((double)diff.field_72450_a, (double)diff.field_72449_c))).rotateX((double)(270.0f + AngleHelper.deg(MathHelper.func_181159_b((double)diff.field_72448_b, (double)(-MathHelper.func_76133_a((double)(diff.field_72450_a * diff.field_72450_a + diff.field_72449_c * diff.field_72449_c)))))));
            MatrixTransformStack.of((MatrixStack)ms).rotateY((double)(((float)entity.field_70173_aa + pt) * 20.0f * this.spin + (float)PotatoProjectileRenderMode.entityRandom((Entity)entity, 360))).rotateZ((double)(-this.spriteAngleOffset));
        }
    }

    public static class Tumble
    extends Billboard {
        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void transform(MatrixStack ms, PotatoProjectileEntity entity, float pt) {
            super.transform(ms, entity, pt);
            MatrixTransformStack.of((MatrixStack)ms).rotateZ((double)(((float)entity.field_70173_aa + pt) * 2.0f * (float)PotatoProjectileRenderMode.entityRandom((Entity)entity, 16))).rotateX((double)(((float)entity.field_70173_aa + pt) * (float)PotatoProjectileRenderMode.entityRandom((Entity)entity, 32)));
        }
    }

    public static class Billboard
    implements PotatoProjectileRenderMode {
        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void transform(MatrixStack ms, PotatoProjectileEntity entity, float pt) {
            Minecraft mc = Minecraft.func_71410_x();
            Vector3d p1 = mc.func_175606_aa().func_174824_e(pt);
            Vector3d diff = entity.func_174813_aQ().func_189972_c().func_178788_d(p1);
            MatrixTransformStack.of((MatrixStack)ms).rotateY((double)AngleHelper.deg(MathHelper.func_181159_b((double)diff.field_72450_a, (double)diff.field_72449_c))).rotateX((double)(180.0f + AngleHelper.deg(MathHelper.func_181159_b((double)diff.field_72448_b, (double)(-MathHelper.func_76133_a((double)(diff.field_72450_a * diff.field_72450_a + diff.field_72449_c * diff.field_72449_c)))))));
        }
    }
}

