/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids.actors;

import com.simibubi.create.AllFluids;
import com.simibubi.create.content.contraptions.fluids.potion.PotionFluidHandler;
import com.simibubi.create.foundation.fluid.FluidHelper;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MilkBucketItem;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;

public class GenericItemFilling {
    public static boolean isFluidHandlerValid(ItemStack stack, IFluidHandlerItem fluidHandler) {
        Item item;
        return fluidHandler.getClass() != FluidBucketWrapper.class || (item = stack.func_77973_b()).getClass() == BucketItem.class || item instanceof MilkBucketItem;
    }

    public static boolean canItemBeFilled(World world, ItemStack stack) {
        if (stack.func_77973_b() == Items.field_151069_bo) {
            return true;
        }
        if (stack.func_77973_b() == Items.field_151117_aB) {
            return false;
        }
        LazyOptional capability = stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
        IFluidHandlerItem tank = (IFluidHandlerItem)capability.orElse(null);
        if (tank == null) {
            return false;
        }
        if (!GenericItemFilling.isFluidHandlerValid(stack, tank)) {
            return false;
        }
        for (int i = 0; i < tank.getTanks(); ++i) {
            if (tank.getFluidInTank(i).getAmount() >= tank.getTankCapacity(i)) continue;
            return true;
        }
        return false;
    }

    public static int getRequiredAmountForItem(World world, ItemStack stack, FluidStack availableFluid) {
        if (stack.func_77973_b() == Items.field_151069_bo && GenericItemFilling.canFillGlassBottleInternally(availableFluid)) {
            return PotionFluidHandler.getRequiredAmountForFilledBottle(stack, availableFluid);
        }
        if (stack.func_77973_b() == Items.field_151133_ar && GenericItemFilling.canFillBucketInternally(availableFluid)) {
            return 1000;
        }
        LazyOptional capability = stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
        IFluidHandlerItem tank = (IFluidHandlerItem)capability.orElse(null);
        if (tank == null) {
            return -1;
        }
        if (tank instanceof FluidBucketWrapper) {
            Item filledBucket = availableFluid.getFluid().func_204524_b();
            if (filledBucket == null || filledBucket == Items.field_190931_a) {
                return -1;
            }
            if (!((FluidBucketWrapper)tank).getFluid().isEmpty()) {
                return -1;
            }
            return 1000;
        }
        int filled = tank.fill(availableFluid, IFluidHandler.FluidAction.SIMULATE);
        return filled == 0 ? -1 : filled;
    }

    private static boolean canFillGlassBottleInternally(FluidStack availableFluid) {
        return availableFluid.getFluid().func_207187_a((Fluid)Fluids.field_204546_a) || availableFluid.getFluid().func_207187_a((Fluid)AllFluids.POTION.get());
    }

    private static boolean canFillBucketInternally(FluidStack availableFluid) {
        return false;
    }

    public static ItemStack fillItem(World world, int requiredAmount, ItemStack stack, FluidStack availableFluid) {
        FluidStack toFill = availableFluid.copy();
        toFill.setAmount(requiredAmount);
        availableFluid.shrink(requiredAmount);
        if (stack.func_77973_b() == Items.field_151069_bo && GenericItemFilling.canFillGlassBottleInternally(toFill)) {
            ItemStack fillBottle = ItemStack.field_190927_a;
            fillBottle = FluidHelper.isWater(toFill.getFluid()) ? PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)Potions.field_185230_b) : PotionFluidHandler.fillBottle(stack, toFill);
            stack.func_190918_g(1);
            return fillBottle;
        }
        ItemStack split = stack.func_77946_l();
        split.func_190920_e(1);
        LazyOptional capability = split.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
        IFluidHandlerItem tank = (IFluidHandlerItem)capability.orElse(null);
        if (tank == null) {
            return ItemStack.field_190927_a;
        }
        tank.fill(toFill, IFluidHandler.FluidAction.EXECUTE);
        ItemStack container = tank.getContainer().func_77946_l();
        stack.func_190918_g(1);
        return container;
    }
}

