/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids;

import com.simibubi.create.AllFluids;
import com.simibubi.create.content.contraptions.fluids.FlowSource;
import com.simibubi.create.content.contraptions.fluids.FluidReactions;
import com.simibubi.create.content.contraptions.fluids.potion.PotionFluidHandler;
import com.simibubi.create.foundation.advancement.AllTriggers;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.utility.BlockFace;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.PotionUtils;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class OpenEndedPipe
extends FlowSource {
    private static final List<IEffectHandler> EFFECT_HANDLERS = new ArrayList<IEffectHandler>();
    private World world;
    private BlockPos pos;
    private AxisAlignedBB aoe;
    private OpenEndFluidHandler fluidHandler = new OpenEndFluidHandler();
    private BlockPos outputPos;
    private boolean wasPulling;
    private FluidStack cachedFluid;
    private List<EffectInstance> cachedEffects;

    public OpenEndedPipe(BlockFace face) {
        super(face);
        this.outputPos = face.getConnectedPos();
        this.pos = face.getPos();
        this.aoe = new AxisAlignedBB(this.outputPos).func_72321_a(0.0, -1.0, 0.0);
        if (face.getFace() == Direction.DOWN) {
            this.aoe = this.aoe.func_72321_a(0.0, -1.0, 0.0);
        }
    }

    public static void registerEffectHandler(IEffectHandler handler) {
        EFFECT_HANDLERS.add(handler);
    }

    public World getWorld() {
        return this.world;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public BlockPos getOutputPos() {
        return this.outputPos;
    }

    public AxisAlignedBB getAOE() {
        return this.aoe;
    }

    @Override
    public void manageSource(World world) {
        this.world = world;
    }

    @Override
    public LazyOptional<IFluidHandler> provideHandler() {
        return LazyOptional.of(() -> this.fluidHandler);
    }

    @Override
    public boolean isEndpoint() {
        return true;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT compound = new CompoundNBT();
        this.fluidHandler.writeToNBT(compound);
        compound.func_74757_a("Pulling", this.wasPulling);
        compound.func_218657_a("Location", (INBT)this.location.serializeNBT());
        return compound;
    }

    public static OpenEndedPipe fromNBT(CompoundNBT compound, BlockPos tilePos) {
        BlockFace fromNBT = BlockFace.fromNBT(compound.func_74775_l("Location"));
        OpenEndedPipe oep = new OpenEndedPipe(new BlockFace(tilePos, fromNBT.getFace()));
        oep.fluidHandler.readFromNBT(compound);
        oep.wasPulling = compound.func_74767_n("Pulling");
        return oep;
    }

    private FluidStack removeFluidFromSpace(boolean simulate) {
        FluidStack empty = FluidStack.EMPTY;
        if (this.world == null) {
            return empty;
        }
        if (!this.world.isAreaLoaded(this.outputPos, 0)) {
            return empty;
        }
        BlockState state = this.world.func_180495_p(this.outputPos);
        FluidState fluidState = state.func_204520_s();
        boolean waterlog = state.func_235901_b_((Property)BlockStateProperties.field_208198_y);
        if (state.func_235901_b_((Property)BlockStateProperties.field_227036_ao_) && (Integer)state.func_177229_b((Property)BlockStateProperties.field_227036_ao_) >= 5) {
            if (!simulate) {
                this.world.func_180501_a(this.outputPos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_227036_ao_, (Comparable)Integer.valueOf(0)), 3);
            }
            return new FluidStack(((ForgeFlowingFluid.Flowing)AllFluids.HONEY.get()).func_210198_f(), 250);
        }
        if (!waterlog && !state.func_185904_a().func_76222_j()) {
            return empty;
        }
        if (fluidState.func_206888_e() || !fluidState.func_206889_d()) {
            return empty;
        }
        FluidStack stack = new FluidStack(fluidState.func_206886_c(), 1000);
        if (simulate) {
            return stack;
        }
        AllTriggers.triggerForNearbyPlayers(AllTriggers.PIPE_SPILL, (IWorld)this.world, this.pos, 5);
        if (waterlog) {
            this.world.func_180501_a(this.outputPos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false)), 3);
            this.world.func_205219_F_().func_205360_a(this.outputPos, (Object)Fluids.field_204546_a, 1);
            return stack;
        }
        this.world.func_180501_a(this.outputPos, (BlockState)fluidState.func_206883_i().func_206870_a((Property)FlowingFluidBlock.field_176367_b, (Comparable)Integer.valueOf(14)), 3);
        return stack;
    }

    private boolean provideFluidToSpace(FluidStack fluid, boolean simulate) {
        if (this.world == null) {
            return false;
        }
        if (!this.world.isAreaLoaded(this.outputPos, 0)) {
            return false;
        }
        BlockState state = this.world.func_180495_p(this.outputPos);
        FluidState fluidState = state.func_204520_s();
        boolean waterlog = state.func_235901_b_((Property)BlockStateProperties.field_208198_y);
        if (!waterlog && !state.func_185904_a().func_76222_j()) {
            return false;
        }
        if (fluid.isEmpty()) {
            return false;
        }
        if (!FluidHelper.hasBlockState(fluid.getFluid())) {
            if (!simulate) {
                this.applyEffects(fluid);
            }
            return true;
        }
        if (!fluidState.func_206888_e() && fluidState.func_206886_c() != fluid.getFluid()) {
            FluidReactions.handlePipeSpillCollision(this.world, this.outputPos, fluid.getFluid(), fluidState);
            return false;
        }
        if (fluidState.func_206889_d()) {
            return false;
        }
        if (waterlog && fluid.getFluid() != Fluids.field_204546_a) {
            return false;
        }
        if (simulate) {
            return true;
        }
        if (this.world.func_230315_m_().func_236040_e_() && fluid.getFluid().func_207185_a((ITag)FluidTags.field_206959_a)) {
            int i = this.outputPos.func_177958_n();
            int j = this.outputPos.func_177956_o();
            int k = this.outputPos.func_177952_p();
            this.world.func_184148_a(null, (double)i, (double)j, (double)k, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (this.world.field_73012_v.nextFloat() - this.world.field_73012_v.nextFloat()) * 0.8f);
            return true;
        }
        AllTriggers.triggerForNearbyPlayers(AllTriggers.PIPE_SPILL, (IWorld)this.world, this.pos, 5);
        if (waterlog) {
            this.world.func_180501_a(this.outputPos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true)), 3);
            this.world.func_205219_F_().func_205360_a(this.outputPos, (Object)Fluids.field_204546_a, 1);
            return true;
        }
        this.world.func_180501_a(this.outputPos, fluid.getFluid().func_207188_f().func_206883_i(), 3);
        return true;
    }

    private boolean canApplyEffects(FluidStack fluid) {
        for (IEffectHandler handler : EFFECT_HANDLERS) {
            if (!handler.canApplyEffects(this, fluid)) continue;
            return true;
        }
        return false;
    }

    private void applyEffects(FluidStack fluid) {
        for (IEffectHandler handler : EFFECT_HANDLERS) {
            if (!handler.canApplyEffects(this, fluid)) continue;
            handler.applyEffects(this, fluid);
        }
    }

    static {
        OpenEndedPipe.registerEffectHandler(new PotionEffectHandler());
        OpenEndedPipe.registerEffectHandler(new MilkEffectHandler());
    }

    public static class MilkEffectHandler
    implements IEffectHandler {
        @Override
        public boolean canApplyEffects(OpenEndedPipe pipe, FluidStack fluid) {
            return Tags.Fluids.MILK.func_230235_a_((Object)fluid.getFluid());
        }

        @Override
        public void applyEffects(OpenEndedPipe pipe, FluidStack fluid) {
            World world = pipe.getWorld();
            if (world.func_82737_E() % 5L != 0L) {
                return;
            }
            List list = world.func_175647_a(LivingEntity.class, pipe.getAOE(), LivingEntity::func_184603_cC);
            ItemStack curativeItem = new ItemStack((IItemProvider)Items.field_151117_aB);
            for (LivingEntity livingentity : list) {
                livingentity.curePotionEffects(curativeItem);
            }
        }
    }

    public static class PotionEffectHandler
    implements IEffectHandler {
        @Override
        public boolean canApplyEffects(OpenEndedPipe pipe, FluidStack fluid) {
            return fluid.getFluid().func_207187_a((Fluid)AllFluids.POTION.get());
        }

        @Override
        public void applyEffects(OpenEndedPipe pipe, FluidStack fluid) {
            if (pipe.cachedFluid == null || pipe.cachedEffects == null || !fluid.isFluidEqual(pipe.cachedFluid)) {
                FluidStack copy = fluid.copy();
                copy.setAmount(250);
                ItemStack bottle = PotionFluidHandler.fillBottle(new ItemStack((IItemProvider)Items.field_151069_bo), fluid);
                pipe.cachedEffects = PotionUtils.func_185189_a((ItemStack)bottle);
            }
            if (pipe.cachedEffects.isEmpty()) {
                return;
            }
            List list = pipe.getWorld().func_175647_a(LivingEntity.class, pipe.getAOE(), LivingEntity::func_184603_cC);
            for (LivingEntity livingentity : list) {
                for (EffectInstance effectinstance : pipe.cachedEffects) {
                    Effect effect = effectinstance.func_188419_a();
                    if (effect.func_76403_b()) {
                        effect.func_180793_a(null, null, livingentity, effectinstance.func_76458_c(), 0.5);
                        continue;
                    }
                    livingentity.func_195064_c(new EffectInstance(effectinstance));
                }
            }
        }
    }

    public static interface IEffectHandler {
        public boolean canApplyEffects(OpenEndedPipe var1, FluidStack var2);

        public void applyEffects(OpenEndedPipe var1, FluidStack var2);
    }

    private class OpenEndFluidHandler
    extends FluidTank {
        public OpenEndFluidHandler() {
            super(1000);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (OpenEndedPipe.this.world == null) {
                return 0;
            }
            if (!OpenEndedPipe.this.world.isAreaLoaded(OpenEndedPipe.this.outputPos, 0)) {
                return 0;
            }
            if (resource.isEmpty()) {
                return 0;
            }
            if (!OpenEndedPipe.this.provideFluidToSpace(resource, true)) {
                return 0;
            }
            FluidStack containedFluidStack = this.getFluid();
            if (!containedFluidStack.isEmpty() && !containedFluidStack.isFluidEqual(resource)) {
                this.setFluid(FluidStack.EMPTY);
            }
            if (OpenEndedPipe.this.wasPulling) {
                OpenEndedPipe.this.wasPulling = false;
            }
            if (OpenEndedPipe.this.canApplyEffects(resource)) {
                resource = FluidHelper.copyStackWithAmount(resource, 1);
            }
            int fill = super.fill(resource, action);
            if (action.simulate()) {
                return fill;
            }
            if ((this.getFluidAmount() == 1000 || !FluidHelper.hasBlockState(containedFluidStack.getFluid())) && OpenEndedPipe.this.provideFluidToSpace(containedFluidStack, false)) {
                this.setFluid(FluidStack.EMPTY);
            }
            return fill;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return this.drainInner(resource.getAmount(), resource, action);
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return this.drainInner(maxDrain, null, action);
        }

        private FluidStack drainInner(int amount, @Nullable FluidStack filter, IFluidHandler.FluidAction action) {
            FluidStack drainedFromInternal;
            boolean filterPresent;
            FluidStack empty = FluidStack.EMPTY;
            boolean bl = filterPresent = filter != null;
            if (OpenEndedPipe.this.world == null) {
                return empty;
            }
            if (!OpenEndedPipe.this.world.isAreaLoaded(OpenEndedPipe.this.outputPos, 0)) {
                return empty;
            }
            if (amount == 0) {
                return empty;
            }
            if (amount > 1000) {
                amount = 1000;
                if (filterPresent) {
                    filter = FluidHelper.copyStackWithAmount(filter, amount);
                }
            }
            if (!OpenEndedPipe.this.wasPulling) {
                OpenEndedPipe.this.wasPulling = true;
            }
            FluidStack fluidStack = drainedFromInternal = filterPresent ? super.drain(filter, action) : super.drain(amount, action);
            if (!drainedFromInternal.isEmpty()) {
                return drainedFromInternal;
            }
            FluidStack drainedFromWorld = OpenEndedPipe.this.removeFluidFromSpace(action.simulate());
            if (drainedFromWorld.isEmpty()) {
                return FluidStack.EMPTY;
            }
            if (filterPresent && !drainedFromWorld.isFluidEqual(filter)) {
                return FluidStack.EMPTY;
            }
            int remainder = drainedFromWorld.getAmount() - amount;
            drainedFromWorld.setAmount(amount);
            if (!action.simulate() && remainder > 0) {
                if (!this.getFluid().isEmpty() && !this.getFluid().isFluidEqual(drainedFromWorld)) {
                    this.setFluid(FluidStack.EMPTY);
                }
                super.fill(FluidHelper.copyStackWithAmount(drainedFromWorld, remainder), IFluidHandler.FluidAction.EXECUTE);
            }
            return drainedFromWorld;
        }
    }
}

