/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.AllMovementBehaviours;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.components.actors.SeatEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionDisassemblyPacket;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionStallPacket;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.content.contraptions.components.structureMovement.OrientedContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.StructureTransform;
import com.simibubi.create.content.contraptions.components.structureMovement.TranslatingContraption;
import com.simibubi.create.content.contraptions.components.structureMovement.glue.SuperGlueEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.mounted.MountedContraption;
import com.simibubi.create.content.contraptions.components.structureMovement.sync.ContraptionSeatMappingPacket;
import com.simibubi.create.foundation.collision.Matrix3d;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import java.io.DataOutput;
import java.io.IOException;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.material.PushReaction;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.HangingEntity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.fml.network.PacketDistributor;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.tuple.MutablePair;

public abstract class AbstractContraptionEntity
extends Entity
implements IEntityAdditionalSpawnData {
    private static final DataParameter<Boolean> STALLED = EntityDataManager.func_187226_a(AbstractContraptionEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public final Map<Entity, MutableInt> collidingEntities = new IdentityHashMap<Entity, MutableInt>();
    protected Contraption contraption;
    protected boolean initialized;
    protected boolean prevPosInvalid = true;
    private boolean ticking;

    public AbstractContraptionEntity(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    protected void setContraption(Contraption contraption) {
        this.contraption = contraption;
        if (contraption == null) {
            return;
        }
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        contraption.onEntityCreated(this);
    }

    public boolean supportsTerrainCollision() {
        return this.contraption instanceof TranslatingContraption;
    }

    protected void contraptionInitialize() {
        this.contraption.onEntityInitialize(this.field_70170_p, this);
        this.initialized = true;
    }

    public boolean collisionEnabled() {
        return true;
    }

    public void addSittingPassenger(Entity passenger, int seatIndex) {
        passenger.func_184205_a((Entity)this, true);
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        this.contraption.getSeatMapping().put(passenger.func_110124_au(), seatIndex);
        AllPackets.channel.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new ContraptionSeatMappingPacket(this.func_145782_y(), this.contraption.getSeatMapping()));
    }

    protected void func_184225_p(Entity passenger) {
        Vector3d transformedVector = this.getPassengerPosition(passenger, 1.0f);
        super.func_184225_p(passenger);
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (transformedVector != null) {
            passenger.getPersistentData().func_218657_a("ContraptionDismountLocation", (INBT)VecHelper.writeNBT(transformedVector));
        }
        this.contraption.getSeatMapping().remove(passenger.func_110124_au());
        AllPackets.channel.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new ContraptionSeatMappingPacket(this.func_145782_y(), this.contraption.getSeatMapping()));
    }

    public void func_226266_a_(Entity passenger, Entity.IMoveCallback callback) {
        if (!this.func_184196_w(passenger)) {
            return;
        }
        Vector3d transformedVector = this.getPassengerPosition(passenger, 1.0f);
        if (transformedVector == null) {
            return;
        }
        callback.accept(passenger, transformedVector.field_72450_a, transformedVector.field_72448_b, transformedVector.field_72449_c);
    }

    protected Vector3d getPassengerPosition(Entity passenger, float partialTicks) {
        BlockPos localPos;
        UUID id = passenger.func_110124_au();
        if (passenger instanceof OrientedContraptionEntity && (localPos = this.contraption.getBearingPosOf(id)) != null) {
            return this.toGlobalVector(VecHelper.getCenterOf((Vector3i)localPos), partialTicks).func_178787_e(VecHelper.getCenterOf((Vector3i)BlockPos.field_177992_a)).func_178786_a(0.5, 1.0, 0.5);
        }
        AxisAlignedBB bb = passenger.func_174813_aQ();
        double ySize = bb.func_216360_c();
        BlockPos seat = this.contraption.getSeatOf(id);
        if (seat == null) {
            return null;
        }
        Vector3d transformedVector = this.toGlobalVector(Vector3d.func_237491_b_((Vector3i)seat).func_72441_c(0.5, passenger.func_70033_W() + ySize - (double)0.15f, 0.5), partialTicks).func_178787_e(VecHelper.getCenterOf((Vector3i)BlockPos.field_177992_a)).func_178786_a(0.5, ySize, 0.5);
        return transformedVector;
    }

    protected boolean func_184219_q(Entity p_184219_1_) {
        if (p_184219_1_ instanceof OrientedContraptionEntity) {
            return true;
        }
        return this.contraption.getSeatMapping().size() < this.contraption.getSeats().size();
    }

    public boolean handlePlayerInteraction(PlayerEntity player, BlockPos localPos, Direction side, Hand interactionHand) {
        int indexOfSeat = this.contraption.getSeats().indexOf(localPos);
        if (indexOfSeat == -1) {
            return false;
        }
        Entity toDismount = null;
        for (Map.Entry<UUID, Integer> entry : this.contraption.getSeatMapping().entrySet()) {
            if (entry.getValue() != indexOfSeat) continue;
            for (Entity entity : this.func_184188_bt()) {
                if (!entry.getKey().equals(entity.func_110124_au())) continue;
                if (entity instanceof PlayerEntity) {
                    return false;
                }
                toDismount = entity;
            }
        }
        if (toDismount != null && !this.field_70170_p.field_72995_K) {
            Vector3d transformedVector = this.getPassengerPosition(toDismount, 1.0f);
            toDismount.func_184210_p();
            if (transformedVector != null) {
                toDismount.func_70634_a(transformedVector.field_72450_a, transformedVector.field_72448_b, transformedVector.field_72449_c);
            }
        }
        if (this.field_70170_p.field_72995_K) {
            return true;
        }
        this.addSittingPassenger((Entity)player, indexOfSeat);
        return true;
    }

    public Vector3d toGlobalVector(Vector3d localVec, float partialTicks) {
        Vector3d rotationOffset = VecHelper.getCenterOf((Vector3i)BlockPos.field_177992_a);
        localVec = localVec.func_178788_d(rotationOffset);
        localVec = this.applyRotation(localVec, partialTicks);
        localVec = localVec.func_178787_e(rotationOffset).func_178787_e(this.getAnchorVec());
        return localVec;
    }

    public Vector3d toLocalVector(Vector3d globalVec, float partialTicks) {
        Vector3d rotationOffset = VecHelper.getCenterOf((Vector3i)BlockPos.field_177992_a);
        globalVec = globalVec.func_178788_d(this.getAnchorVec()).func_178788_d(rotationOffset);
        globalVec = this.reverseRotation(globalVec, partialTicks);
        globalVec = globalVec.func_178787_e(rotationOffset);
        return globalVec;
    }

    public final void func_70071_h_() {
        if (this.contraption == null) {
            this.func_70106_y();
            return;
        }
        Iterator<Map.Entry<Entity, MutableInt>> iterator = this.collidingEntities.entrySet().iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getValue().incrementAndGet() <= 3) continue;
            iterator.remove();
        }
        this.field_70169_q = this.func_226277_ct_();
        this.field_70167_r = this.func_226278_cu_();
        this.field_70166_s = this.func_226281_cx_();
        this.prevPosInvalid = false;
        if (!this.initialized) {
            this.contraptionInitialize();
        }
        this.contraption.onEntityTick(this.field_70170_p);
        this.tickContraption();
        super.func_70071_h_();
    }

    protected abstract void tickContraption();

    public abstract Vector3d applyRotation(Vector3d var1, float var2);

    public abstract Vector3d reverseRotation(Vector3d var1, float var2);

    public void tickActors() {
        boolean stalledPreviously = this.contraption.stalled;
        if (!this.field_70170_p.field_72995_K) {
            this.contraption.stalled = false;
        }
        this.ticking = true;
        for (MutablePair<Template.BlockInfo, MovementContext> pair : this.contraption.getActors()) {
            MovementContext context = (MovementContext)pair.right;
            Template.BlockInfo blockInfo = (Template.BlockInfo)pair.left;
            MovementBehaviour actor = AllMovementBehaviours.of(blockInfo.field_186243_b);
            Vector3d oldMotion = context.motion;
            Vector3d actorPosition = this.toGlobalVector(VecHelper.getCenterOf((Vector3i)blockInfo.field_186242_a).func_178787_e(actor.getActiveAreaOffset(context)), 1.0f);
            BlockPos gridPosition = new BlockPos(actorPosition);
            boolean newPosVisited = !context.stall && this.shouldActorTrigger(context, blockInfo, actor, actorPosition, gridPosition);
            context.rotation = v -> this.applyRotation((Vector3d)v, 1.0f);
            context.position = actorPosition;
            if (!actor.isActive(context)) continue;
            if (newPosVisited && !context.stall) {
                actor.visitNewPosition(context, gridPosition);
                if (!this.func_70089_S()) break;
                context.firstMovement = false;
            }
            if (!oldMotion.equals((Object)context.motion)) {
                actor.onSpeedChanged(context, oldMotion, context.motion);
                if (!this.func_70089_S()) break;
            }
            actor.tick(context);
            if (!this.func_70089_S()) break;
            this.contraption.stalled |= context.stall;
        }
        if (!this.func_70089_S()) {
            this.contraption.stop(this.field_70170_p);
            return;
        }
        this.ticking = false;
        for (Entity entity : this.func_184188_bt()) {
            if (!(entity instanceof OrientedContraptionEntity) || !this.contraption.stabilizedSubContraptions.containsKey(entity.func_110124_au())) continue;
            OrientedContraptionEntity orientedCE = (OrientedContraptionEntity)entity;
            if (orientedCE.contraption == null || !orientedCE.contraption.stalled) continue;
            this.contraption.stalled = true;
            break;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (!stalledPreviously && this.contraption.stalled) {
                this.onContraptionStalled();
            }
            this.field_70180_af.func_187227_b(STALLED, (Object)this.contraption.stalled);
            return;
        }
        this.contraption.stalled = this.isStalled();
    }

    protected void onContraptionStalled() {
        AllPackets.channel.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new ContraptionStallPacket(this.func_145782_y(), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.getStalledAngle()));
    }

    protected boolean shouldActorTrigger(MovementContext context, Template.BlockInfo blockInfo, MovementBehaviour actor, Vector3d actorPosition, BlockPos gridPosition) {
        Vector3d previousPosition = context.position;
        if (previousPosition == null) {
            return false;
        }
        Vector3d relativeMotion = context.motion = actorPosition.func_178788_d(previousPosition);
        context.relativeMotion = relativeMotion = this.reverseRotation(relativeMotion, 1.0f);
        return !new BlockPos(previousPosition).equals((Object)gridPosition) || context.relativeMotion.func_72433_c() > 0.0 && context.firstMovement;
    }

    public void move(double x, double y, double z) {
        this.func_70107_b(this.func_226277_ct_() + x, this.func_226278_cu_() + y, this.func_226281_cx_() + z);
    }

    public Vector3d getAnchorVec() {
        return this.func_213303_ch();
    }

    public float getYawOffset() {
        return 0.0f;
    }

    public void func_70107_b(double x, double y, double z) {
        super.func_70107_b(x, y, z);
        if (this.contraption == null) {
            return;
        }
        AxisAlignedBB cbox = this.contraption.bounds;
        if (cbox == null) {
            return;
        }
        Vector3d actualVec = this.getAnchorVec();
        this.func_174826_a(cbox.func_191194_a(actualVec));
    }

    public static float yawFromVector(Vector3d vec) {
        return (float)((4.71238898038469 + Math.atan2(vec.field_72449_c, vec.field_72450_a)) / Math.PI * 180.0);
    }

    public static float pitchFromVector(Vector3d vec) {
        return (float)(Math.acos(vec.field_72448_b) / Math.PI * 180.0);
    }

    public static EntityType.Builder<?> build(EntityType.Builder<?> builder) {
        EntityType.Builder<?> entityBuilder = builder;
        return entityBuilder.func_220321_a(1.0f, 1.0f);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(STALLED, (Object)false);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        CompoundNBT compound = new CompoundNBT();
        this.writeAdditional(compound, true);
        try {
            ByteArrayDataOutput dataOutput = ByteStreams.newDataOutput();
            CompressedStreamTools.func_74800_a((CompoundNBT)compound, (DataOutput)dataOutput);
            byte[] byteArray = dataOutput.toByteArray();
            int estimatedPacketSize = byteArray.length;
            if (estimatedPacketSize > 2000000) {
                Create.LOGGER.warn("Could not send Contraption Spawn Data (Packet too big): " + this.getContraption().getType().id + " @" + this.func_213303_ch() + " (" + this.func_110124_au().toString() + ")");
                buffer.func_150786_a(new CompoundNBT());
                return;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            buffer.func_150786_a(new CompoundNBT());
            return;
        }
        buffer.func_150786_a(compound);
    }

    protected final void func_213281_b(CompoundNBT compound) {
        this.writeAdditional(compound, false);
    }

    protected void writeAdditional(CompoundNBT compound, boolean spawnPacket) {
        if (this.contraption != null) {
            compound.func_218657_a("Contraption", (INBT)this.contraption.writeNBT(spawnPacket));
        }
        compound.func_74757_a("Stalled", this.isStalled());
        compound.func_74757_a("Initialized", this.initialized);
    }

    public void readSpawnData(PacketBuffer additionalData) {
        this.readAdditional(additionalData.func_150793_b(), true);
    }

    protected final void func_70037_a(CompoundNBT compound) {
        this.readAdditional(compound, false);
    }

    protected void readAdditional(CompoundNBT compound, boolean spawnData) {
        if (compound.isEmpty()) {
            return;
        }
        this.initialized = compound.func_74767_n("Initialized");
        this.contraption = Contraption.fromNBT(this.field_70170_p, compound.func_74775_l("Contraption"), spawnData);
        this.contraption.entity = this;
        this.field_70180_af.func_187227_b(STALLED, (Object)compound.func_74767_n("Stalled"));
    }

    public void disassemble() {
        if (!this.func_70089_S()) {
            return;
        }
        if (this.contraption == null) {
            return;
        }
        this.func_70106_y();
        StructureTransform transform = this.makeStructureTransform();
        AllPackets.channel.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new ContraptionDisassemblyPacket(this.func_145782_y(), transform));
        this.contraption.addBlocksToWorld(this.field_70170_p, transform);
        this.contraption.addPassengersToWorld(this.field_70170_p, transform, this.func_184188_bt());
        for (Entity entity : this.func_184188_bt()) {
            UUID id;
            if (!(entity instanceof OrientedContraptionEntity) || !this.contraption.stabilizedSubContraptions.containsKey(id = entity.func_110124_au())) continue;
            BlockPos transformed = transform.apply(this.contraption.stabilizedSubContraptions.get(id).getConnectedPos());
            entity.func_70107_b((double)transformed.func_177958_n(), (double)transformed.func_177956_o(), (double)transformed.func_177952_p());
            ((AbstractContraptionEntity)entity).disassemble();
        }
        this.func_184226_ay();
        this.moveCollidedEntitiesOnDisassembly(transform);
        AllSoundEvents.CONTRAPTION_DISASSEMBLE.playOnServer(this.field_70170_p, this.func_233580_cy_());
    }

    private void moveCollidedEntitiesOnDisassembly(StructureTransform transform) {
        for (Entity entity : this.collidingEntities.keySet()) {
            Vector3d localVec = this.toLocalVector(entity.func_213303_ch(), 0.0f);
            Vector3d transformed = transform.apply(localVec);
            if (this.field_70170_p.field_72995_K) {
                entity.func_70107_b(transformed.field_72450_a, transformed.field_72448_b + 0.0625, transformed.field_72449_c);
                continue;
            }
            entity.func_70634_a(transformed.field_72450_a, transformed.field_72448_b + 0.0625, transformed.field_72449_c);
        }
    }

    public void remove(boolean keepData) {
        if (!(this.field_70170_p.field_72995_K || this.field_70128_L || this.contraption == null || this.ticking)) {
            this.contraption.stop(this.field_70170_p);
        }
        if (this.contraption != null) {
            this.contraption.onEntityRemoved(this);
        }
        super.remove(keepData);
    }

    protected abstract StructureTransform makeStructureTransform();

    public void func_174812_G() {
        this.func_184226_ay();
        super.func_174812_G();
    }

    protected void func_70076_C() {
        this.func_184226_ay();
        super.func_70076_C();
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
        if (this.field_70170_p != null && this.field_70170_p.field_72995_K) {
            return;
        }
        this.func_184188_bt().forEach(Entity::func_70106_y);
    }

    protected void func_71061_d_() {
    }

    public Contraption getContraption() {
        return this.contraption;
    }

    public boolean isStalled() {
        return (Boolean)this.field_70180_af.func_187225_a(STALLED);
    }

    @OnlyIn(value=Dist.CLIENT)
    static void handleStallPacket(ContraptionStallPacket packet) {
        Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(packet.entityID);
        if (!(entity instanceof AbstractContraptionEntity)) {
            return;
        }
        AbstractContraptionEntity ce = (AbstractContraptionEntity)entity;
        ce.handleStallInformation(packet.x, packet.y, packet.z, packet.angle);
    }

    @OnlyIn(value=Dist.CLIENT)
    static void handleDisassemblyPacket(ContraptionDisassemblyPacket packet) {
        Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(packet.entityID);
        if (!(entity instanceof AbstractContraptionEntity)) {
            return;
        }
        AbstractContraptionEntity ce = (AbstractContraptionEntity)entity;
        ce.moveCollidedEntitiesOnDisassembly(packet.transform);
    }

    protected abstract float getStalledAngle();

    protected abstract void handleStallInformation(float var1, float var2, float var3, float var4);

    public CompoundNBT func_189511_e(CompoundNBT nbt) {
        Vector3d vec = this.func_213303_ch();
        List passengers = this.func_184188_bt();
        for (Entity entity : passengers) {
            entity.field_70128_L = true;
            Vector3d prevVec = entity.func_213303_ch();
            entity.func_226288_n_(vec.field_72450_a, prevVec.field_72448_b, vec.field_72449_c);
            entity.field_70128_L = false;
        }
        CompoundNBT tag = super.func_189511_e(nbt);
        return tag;
    }

    public void func_213317_d(Vector3d motionIn) {
    }

    public PushReaction func_184192_z() {
        return PushReaction.IGNORE;
    }

    public void setContraptionMotion(Vector3d vec) {
        super.func_213317_d(vec);
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return false;
    }

    public Vector3d getPrevPositionVec() {
        return this.prevPosInvalid ? this.func_213303_ch() : new Vector3d(this.field_70169_q, this.field_70167_r, this.field_70166_s);
    }

    public abstract ContraptionRotationState getRotationState();

    public Vector3d getContactPointMotion(Vector3d globalContactPoint) {
        if (this.prevPosInvalid) {
            return Vector3d.field_186680_a;
        }
        Vector3d contactPoint = this.toGlobalVector(this.toLocalVector(globalContactPoint, 0.0f), 1.0f);
        return contactPoint.func_178788_d(globalContactPoint).func_178787_e(this.func_213303_ch().func_178788_d(this.getPrevPositionVec()));
    }

    public boolean func_241849_j(Entity e) {
        if (e instanceof PlayerEntity && e.func_175149_v()) {
            return false;
        }
        if (e.field_70145_X) {
            return false;
        }
        if (e instanceof HangingEntity) {
            return false;
        }
        if (e instanceof AbstractMinecartEntity) {
            return !(this.contraption instanceof MountedContraption);
        }
        if (e instanceof SuperGlueEntity) {
            return false;
        }
        if (e instanceof SeatEntity) {
            return false;
        }
        if (e instanceof ProjectileEntity) {
            return false;
        }
        if (e.func_184187_bx() != null) {
            return false;
        }
        for (Entity riding = this.func_184187_bx(); riding != null; riding = riding.func_184187_bx()) {
            if (riding != e) continue;
            return false;
        }
        return e.func_184192_z() == PushReaction.NORMAL;
    }

    public boolean func_200601_bK() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract void doLocalTransforms(float var1, MatrixStack[] var2);

    protected boolean func_233566_aG_() {
        return false;
    }

    public void func_70015_d(int p_70015_1_) {
    }

    public static class ContraptionRotationState {
        public static final ContraptionRotationState NONE = new ContraptionRotationState();
        float xRotation = 0.0f;
        float yRotation = 0.0f;
        float zRotation = 0.0f;
        float secondYRotation = 0.0f;
        Matrix3d matrix;

        public Matrix3d asMatrix() {
            if (this.matrix != null) {
                return this.matrix;
            }
            this.matrix = new Matrix3d().asIdentity();
            if (this.xRotation != 0.0f) {
                this.matrix.multiply(new Matrix3d().asXRotation(AngleHelper.rad(-this.xRotation)));
            }
            if (this.yRotation != 0.0f) {
                this.matrix.multiply(new Matrix3d().asYRotation(AngleHelper.rad(this.yRotation)));
            }
            if (this.zRotation != 0.0f) {
                this.matrix.multiply(new Matrix3d().asZRotation(AngleHelper.rad(-this.zRotation)));
            }
            return this.matrix;
        }

        public boolean hasVerticalRotation() {
            return this.xRotation != 0.0f || this.zRotation != 0.0f;
        }

        public float getYawOffset() {
            return this.secondYRotation;
        }
    }
}

