/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import stanhebben.zenscript.parser.CompiledDFA;
import stanhebben.zenscript.parser.HashMapI;
import stanhebben.zenscript.parser.HashMapII;
import stanhebben.zenscript.parser.HashSetI;
import stanhebben.zenscript.parser.IteratorI;

public class DFA {
    public static final int NOFINAL = Integer.MIN_VALUE;
    private DFAState initial;

    public DFA(DFAState initial) {
        this.initial = initial;
    }

    public CompiledDFA compile() {
        ArrayList<DFAState> nodeList = new ArrayList<DFAState>();
        HashMap<DFAState, Integer> nodes = new HashMap<DFAState, Integer>();
        nodes.put(this.initial, 0);
        nodeList.add(this.initial);
        int counter = 1;
        LinkedList<DFAState> todo = new LinkedList<DFAState>();
        todo.add(this.initial);
        while (!todo.isEmpty()) {
            DFAState current = (DFAState)todo.poll();
            IteratorI it = current.transitions.keys();
            while (it.hasNext()) {
                int k = it.next();
                DFAState next = (DFAState)current.transitions.get(k);
                if (nodes.containsKey(next)) continue;
                todo.add(next);
                nodes.put(next, counter++);
                nodeList.add(next);
            }
        }
        HashMapII[] transitions = new HashMapII[counter];
        int[] finals2 = new int[counter];
        for (DFAState node : nodeList) {
            int index = (Integer)nodes.get(node);
            finals2[index] = node.finalCode;
            transitions[index] = new HashMapII();
            IteratorI it = node.transitions.keys();
            while (it.hasNext()) {
                int k = it.next();
                DFAState next = (DFAState)node.transitions.get(k);
                transitions[index].put(k, (Integer)nodes.get(next));
            }
        }
        return new CompiledDFA(transitions, finals2);
    }

    public DFA optimize() {
        int i;
        boolean changed;
        int i2;
        int k;
        CompiledDFA compiled = this.compile();
        HashMapII[] transitions = compiled.transitions;
        int size = transitions.length;
        HashSetI alphabet = new HashSetI();
        for (HashMapII transition : transitions) {
            IteratorI it = transition.keys();
            while (it.hasNext()) {
                k = it.next();
                alphabet.add(k);
            }
        }
        boolean[][] distinguishable = new boolean[size + 1][size + 1];
        for (i2 = 0; i2 < size; ++i2) {
            for (int j = 0; j < size; ++j) {
                distinguishable[i2][j] = compiled.finals[i2] != compiled.finals[j];
            }
        }
        for (i2 = 0; i2 < size; ++i2) {
            distinguishable[i2][size] = true;
            distinguishable[size][i2] = true;
        }
        do {
            changed = false;
            IteratorI ita = alphabet.iterator();
            while (ita.hasNext()) {
                int x = ita.next();
                for (int i3 = 0; i3 < size; ++i3) {
                    int ti = transitions[i3].get(x, size);
                    for (int j = 0; j < size; ++j) {
                        int tj;
                        if (distinguishable[i3][j] || !distinguishable[ti][tj = transitions[j].get(x, size)]) continue;
                        distinguishable[i3][j] = true;
                        changed = true;
                    }
                }
            }
        } while (changed);
        HashMapI nodeMap = new HashMapI();
        block9: for (i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                if (distinguishable[i][j] || !nodeMap.containsKey(j)) continue;
                nodeMap.put(i, nodeMap.get(j));
                if (compiled.finals[i] == Integer.MIN_VALUE || ((DFAState)nodeMap.get(j)).getFinal() == Integer.MIN_VALUE || ((DFAState)nodeMap.get(j)).getFinal() == compiled.finals[i]) continue block9;
                throw new RuntimeException("Eh?");
            }
            DFAState node = new DFAState();
            node.setFinal(compiled.finals[i]);
            nodeMap.put(i, node);
        }
        for (i = 0; i < compiled.transitions.length; ++i) {
            IteratorI iter = transitions[i].keys();
            while (iter.hasNext()) {
                k = iter.next();
                ((DFAState)nodeMap.get(i)).addTransition(k, (DFAState)nodeMap.get(transitions[i].get(k)));
            }
        }
        return new DFA((DFAState)nodeMap.get(0));
    }

    public String toString() {
        int i;
        StringBuilder result = new StringBuilder();
        CompiledDFA dfs = this.compile();
        for (i = 0; i < dfs.transitions.length; ++i) {
            HashMapII map = dfs.transitions[i];
            IteratorI it = map.keys();
            while (it.hasNext()) {
                int v = it.next();
                result.append("edge(");
                result.append(i);
                result.append(", ");
                result.append(v);
                result.append("): ");
                result.append(map.get(v));
                result.append("\r\n");
            }
        }
        for (i = 0; i < dfs.finals.length; ++i) {
            if (dfs.finals[i] == Integer.MIN_VALUE) continue;
            result.append("final(");
            result.append(i);
            result.append("): ");
            result.append(dfs.finals[i]);
            result.append("\r\n");
        }
        return result.toString();
    }

    public static class DFAState {
        private HashMapI<DFAState> transitions;
        private int finalCode = Integer.MIN_VALUE;

        public DFAState() {
            this.transitions = new HashMapI();
        }

        public void addTransition(int label, DFAState next) {
            this.transitions.put(label, next);
        }

        public int getFinal() {
            return this.finalCode;
        }

        public void setFinal(int finalCode) {
            this.finalCode = finalCode;
        }
    }
}

