/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.lua2java;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.luaj.vm2.ast.Block;
import org.luaj.vm2.ast.Chunk;
import org.luaj.vm2.ast.Exp;
import org.luaj.vm2.ast.FuncBody;
import org.luaj.vm2.ast.NameScope;
import org.luaj.vm2.ast.Stat;
import org.luaj.vm2.ast.Variable;
import org.luaj.vm2.ast.Visitor;

public class JavaScope
extends NameScope {
    private static final int MAX_CONSTNAME_LEN = 8;
    public static final Set SPECIALS = new HashSet();
    private static final String[] specials = new String[]{"name", "opcode", "env", "abstract", "continue", "for", "new", "switch", "assert", "default", "goto", "package", "synchronized", "boolean", "do", "if", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while", "false", "null", "true"};
    public int nreturns;
    public boolean needsbinoptmp;
    public boolean usesvarargs;
    final Set staticnames;
    final Set javanames = new HashSet();
    final Map astele2javaname = new HashMap();
    static /* synthetic */ Class class$org$luaj$vm2$lib$LibFunction;

    private JavaScope(Set set, JavaScope javaScope) {
        super(javaScope);
        this.staticnames = set;
    }

    public static JavaScope newJavaScope(Chunk chunk) {
        return new JavaScope(new HashSet(), null).initialize(chunk.block, -1);
    }

    public JavaScope pushJavaScope(FuncBody funcBody) {
        return new JavaScope(this.staticnames, this).initialize(funcBody.block, 0);
    }

    public JavaScope popJavaScope() {
        return (JavaScope)this.outerScope;
    }

    final String getJavaName(Variable variable) {
        JavaScope javaScope = this;
        while (javaScope != null) {
            if (javaScope.astele2javaname.containsKey(variable)) {
                return (String)javaScope.astele2javaname.get(variable);
            }
            javaScope = (JavaScope)javaScope.outerScope;
        }
        return this.allocateJavaName(variable, variable.name);
    }

    private final String allocateJavaName(Object object, String string) {
        int n = 0;
        while (true) {
            String string2;
            if (!(this.isJavanameInScope(string2 = string + (n == 0 ? "" : "$" + n)) || SPECIALS.contains(string2) || this.staticnames.contains(string2))) {
                this.javanames.add(string2);
                this.astele2javaname.put(object, string2);
                return string2;
            }
            ++n;
        }
    }

    public void setJavaName(Variable variable, String string) {
        this.javanames.add(string);
        this.astele2javaname.put(variable, string);
    }

    private boolean isJavanameInScope(String string) {
        JavaScope javaScope = this;
        while (javaScope != null) {
            if (javaScope.javanames.contains(string)) {
                return true;
            }
            javaScope = (JavaScope)javaScope.outerScope;
        }
        return false;
    }

    public String createConstantName(String string) {
        string = JavaScope.toLegalJavaName(string);
        int n = 0;
        while (true) {
            String string2;
            if (!(this.isJavanameInScope(string2 = string + (n == 0 ? "" : "$" + n)) || SPECIALS.contains(string2) || this.staticnames.contains(string2))) {
                this.javanames.add(string2);
                this.staticnames.add(string2);
                return string2;
            }
            ++n;
        }
    }

    public static String toLegalJavaName(String string) {
        String string2 = string.replaceAll("[^\\w]", "_");
        if (string2.length() > 8) {
            string2 = string2.substring(0, 8);
        }
        if (string2.length() == 0 || !Character.isJavaIdentifierStart(string2.charAt(0))) {
            string2 = "_" + string2;
        }
        return string2;
    }

    private JavaScope initialize(Block block, int n) {
        NewScopeVisitor newScopeVisitor = new NewScopeVisitor(n);
        block.accept(newScopeVisitor);
        this.nreturns = newScopeVisitor.nreturns;
        this.needsbinoptmp = newScopeVisitor.needsbinoptmp;
        this.usesvarargs = newScopeVisitor.usesvarargs;
        return this;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        for (int i = 0; i < specials.length; ++i) {
            SPECIALS.add(specials[i]);
        }
        Field[] fieldArray = (class$org$luaj$vm2$lib$LibFunction == null ? (class$org$luaj$vm2$lib$LibFunction = JavaScope.class$("org.luaj.vm2.lib.LibFunction")) : class$org$luaj$vm2$lib$LibFunction).getFields();
        int n = fieldArray.length;
        for (int i = 0; i < n; ++i) {
            SPECIALS.add(fieldArray[i].getName());
        }
        Method[] methodArray = (class$org$luaj$vm2$lib$LibFunction == null ? (class$org$luaj$vm2$lib$LibFunction = JavaScope.class$("org.luaj.vm2.lib.LibFunction")) : class$org$luaj$vm2$lib$LibFunction).getMethods();
        int n2 = methodArray.length;
        for (n = 0; n < n2; ++n) {
            SPECIALS.add(methodArray[n].getName());
        }
    }

    class NewScopeVisitor
    extends Visitor {
        int nreturns = 0;
        boolean needsbinoptmp = false;
        boolean usesvarargs = false;

        NewScopeVisitor(int n) {
            this.nreturns = n;
        }

        public void visit(FuncBody funcBody) {
        }

        public void visit(Stat.Return return_) {
            int n = return_.nreturns();
            this.nreturns = this.nreturns < 0 || n < 0 ? -1 : Math.max(n, this.nreturns);
            super.visit(return_);
        }

        public void visit(Exp.BinopExp binopExp) {
            switch (binopExp.op) {
                case 59: 
                case 60: {
                    this.needsbinoptmp = true;
                }
            }
            super.visit(binopExp);
        }

        public void visit(Exp.VarargsExp varargsExp) {
            this.usesvarargs = true;
        }
    }
}

