/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.lib;

import java.io.IOException;
import java.util.Date;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.PackageLib;
import org.luaj.vm2.lib.VarArgFunction;

public class OsLib
extends VarArgFunction {
    public static String TMP_PREFIX = ".luaj";
    public static String TMP_SUFFIX = "tmp";
    private static final int INIT = 0;
    private static final int CLOCK = 1;
    private static final int DATE = 2;
    private static final int DIFFTIME = 3;
    private static final int EXECUTE = 4;
    private static final int EXIT = 5;
    private static final int GETENV = 6;
    private static final int REMOVE = 7;
    private static final int RENAME = 8;
    private static final int SETLOCALE = 9;
    private static final int TIME = 10;
    private static final int TMPNAME = 11;
    private static final String[] NAMES = new String[]{"clock", "date", "difftime", "execute", "exit", "getenv", "remove", "rename", "setlocale", "time", "tmpname"};
    private static final long t0;
    private static long tmpnames;
    static /* synthetic */ Class class$org$luaj$vm2$lib$OsLib;

    public LuaValue init() {
        LuaTable luaTable = new LuaTable();
        this.bind(luaTable, this.getClass(), NAMES, 1);
        this.env.set("os", (LuaValue)luaTable);
        PackageLib.instance.LOADED.set("os", (LuaValue)luaTable);
        return luaTable;
    }

    public Varargs invoke(Varargs varargs) {
        try {
            switch (this.opcode) {
                case 0: {
                    return this.init();
                }
                case 1: {
                    return OsLib.valueOf(this.clock());
                }
                case 2: {
                    String string = varargs.optjstring(1, null);
                    double d = varargs.optdouble(2, -1.0);
                    return OsLib.valueOf(this.date(string, d == -1.0 ? (double)System.currentTimeMillis() / 1000.0 : d));
                }
                case 3: {
                    return OsLib.valueOf(this.difftime(varargs.checkdouble(1), varargs.checkdouble(2)));
                }
                case 4: {
                    return OsLib.valueOf(this.execute(varargs.optjstring(1, null)));
                }
                case 5: {
                    this.exit(varargs.optint(1, 0));
                    return NONE;
                }
                case 6: {
                    String string = this.getenv(varargs.checkjstring(1));
                    return string != null ? OsLib.valueOf(string) : NIL;
                }
                case 7: {
                    this.remove(varargs.checkjstring(1));
                    return LuaValue.TRUE;
                }
                case 8: {
                    this.rename(varargs.checkjstring(1), varargs.checkjstring(2));
                    return LuaValue.TRUE;
                }
                case 9: {
                    String string = this.setlocale(varargs.optjstring(1, null), varargs.optjstring(2, "all"));
                    return string != null ? OsLib.valueOf(string) : NIL;
                }
                case 10: {
                    return OsLib.valueOf(this.time(varargs.arg1().isnil() ? null : varargs.checktable(1)));
                }
                case 11: {
                    return OsLib.valueOf(this.tmpname());
                }
            }
            return NONE;
        }
        catch (IOException iOException) {
            return OsLib.varargsOf(NIL, (Varargs)OsLib.valueOf(iOException.getMessage()));
        }
    }

    protected double clock() {
        return (double)(System.currentTimeMillis() - t0) / 1000.0;
    }

    protected double difftime(double d, double d2) {
        return d - d2;
    }

    protected String date(String string, double d) {
        return new Date((long)(d * 1000.0)).toString();
    }

    protected int execute(String string) {
        return 0;
    }

    protected void exit(int n) {
    }

    protected String getenv(String string) {
        return System.getProperty(string);
    }

    protected void remove(String string) throws IOException {
        throw new IOException("not implemented");
    }

    protected void rename(String string, String string2) throws IOException {
        throw new IOException("not implemented");
    }

    protected String setlocale(String string, String string2) {
        return "C";
    }

    protected long time(LuaTable luaTable) {
        return System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String tmpname() {
        Class clazz = class$org$luaj$vm2$lib$OsLib == null ? (class$org$luaj$vm2$lib$OsLib = OsLib.class$("org.luaj.vm2.lib.OsLib")) : class$org$luaj$vm2$lib$OsLib;
        synchronized (clazz) {
            return TMP_PREFIX + tmpnames++ + TMP_SUFFIX;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        tmpnames = t0 = System.currentTimeMillis();
    }
}

