/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2;

import org.luaj.vm2.LuaNumber;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaValue;

public final class Buffer {
    private static final int DEFAULT_CAPACITY = 64;
    private static final byte[] NOBYTES = new byte[0];
    private byte[] bytes;
    private int length;
    private int offset;
    private LuaValue value;

    public Buffer() {
        this(64);
    }

    public Buffer(int n) {
        this.bytes = new byte[n];
        this.length = 0;
        this.offset = 0;
        this.value = null;
    }

    public Buffer(LuaValue luaValue) {
        this.bytes = NOBYTES;
        this.offset = 0;
        this.length = 0;
        this.value = luaValue;
    }

    public LuaValue value() {
        return this.value != null ? this.value : this.tostring();
    }

    public Buffer setvalue(LuaValue luaValue) {
        this.bytes = NOBYTES;
        this.length = 0;
        this.offset = 0;
        this.value = luaValue;
        return this;
    }

    public final LuaString tostring() {
        this.realloc(this.length, 0);
        return LuaString.valueOf(this.bytes, this.offset, this.length);
    }

    public String tojstring() {
        return this.value().tojstring();
    }

    public String toString() {
        return this.tojstring();
    }

    public final Buffer append(byte by) {
        this.makeroom(0, 1);
        this.bytes[this.offset + this.length++] = by;
        return this;
    }

    public final Buffer append(LuaValue luaValue) {
        this.append(luaValue.strvalue());
        return this;
    }

    public final Buffer append(LuaString luaString) {
        int n = luaString.m_length;
        this.makeroom(0, n);
        luaString.copyInto(0, this.bytes, this.offset + this.length, n);
        this.length += n;
        return this;
    }

    public final Buffer append(String string) {
        char[] cArray = string.toCharArray();
        this.makeroom(0, cArray.length);
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            this.bytes[this.offset + this.length + i] = c < '\u0100' ? (int)c : 63;
        }
        this.length += cArray.length;
        return this;
    }

    public Buffer concatTo(LuaValue luaValue) {
        return this.setvalue(luaValue.concat(this.value()));
    }

    public Buffer concatTo(LuaString luaString) {
        return this.value != null && !this.value.isstring() ? this.setvalue(luaString.concat(this.value)) : this.prepend(luaString);
    }

    public Buffer concatTo(LuaNumber luaNumber) {
        return this.value != null && !this.value.isstring() ? this.setvalue(luaNumber.concat(this.value)) : this.prepend(luaNumber.strvalue());
    }

    public Buffer prepend(LuaString luaString) {
        int n = luaString.m_length;
        this.makeroom(n, 0);
        System.arraycopy(luaString.m_bytes, luaString.m_offset, this.bytes, this.offset - n, n);
        this.offset -= n;
        this.length += n;
        this.value = null;
        return this;
    }

    public final void makeroom(int n, int n2) {
        if (this.value != null) {
            LuaString luaString = this.value.strvalue();
            this.value = null;
            this.length = luaString.m_length;
            this.offset = n;
            this.bytes = new byte[n + this.length + n2];
            System.arraycopy(luaString.m_bytes, luaString.m_offset, this.bytes, this.offset, this.length);
        } else if (this.offset + this.length + n2 > this.bytes.length || this.offset < n) {
            int n3 = n + this.length + n2;
            int n4 = n3 < 32 ? 32 : (n3 < this.length * 2 ? this.length * 2 : n3);
            this.realloc(n4, n == 0 ? 0 : n4 - this.length - n2);
        }
    }

    private final void realloc(int n, int n2) {
        if (n != this.bytes.length) {
            byte[] byArray = new byte[n];
            System.arraycopy(this.bytes, this.offset, byArray, n2, this.length);
            this.bytes = byArray;
            this.offset = n2;
        }
    }
}

