/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.upgrades;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.turtle.TurtleUpgradeType;
import dan200.computercraft.api.turtle.TurtleVerb;
import dan200.computercraft.shared.turtle.upgrades.CraftingTablePeripheral;
import javax.annotation.Nonnull;
import javax.vecmath.Matrix4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelManager;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class TurtleCraftingTable
implements ITurtleUpgrade {
    private ResourceLocation m_id = new ResourceLocation("minecraft", "crafting_table");
    private int m_legacyID;
    private ItemStack m_item;
    @SideOnly(value=Side.CLIENT)
    private ModelResourceLocation m_leftModel;
    @SideOnly(value=Side.CLIENT)
    private ModelResourceLocation m_rightModel;

    public TurtleCraftingTable(int legacyId) {
        this.m_legacyID = legacyId;
        this.m_item = new ItemStack(Blocks.field_150462_ai, 1, 0);
    }

    @Override
    @Nonnull
    public ResourceLocation getUpgradeID() {
        return this.m_id;
    }

    @Override
    public int getLegacyUpgradeID() {
        return this.m_legacyID;
    }

    @Override
    @Nonnull
    public String getUnlocalisedAdjective() {
        return "upgrade.minecraft:crafting_table.adjective";
    }

    @Override
    @Nonnull
    public TurtleUpgradeType getType() {
        return TurtleUpgradeType.Peripheral;
    }

    @Override
    @Nonnull
    public ItemStack getCraftingItem() {
        return this.m_item;
    }

    @Override
    public IPeripheral createPeripheral(@Nonnull ITurtleAccess turtle, @Nonnull TurtleSide side) {
        return new CraftingTablePeripheral(turtle);
    }

    @Override
    @Nonnull
    public TurtleCommandResult useTool(@Nonnull ITurtleAccess turtle, @Nonnull TurtleSide side, @Nonnull TurtleVerb verb, @Nonnull EnumFacing dir) {
        return TurtleCommandResult.failure();
    }

    @SideOnly(value=Side.CLIENT)
    private void loadModelLocations() {
        if (this.m_leftModel == null) {
            this.m_leftModel = new ModelResourceLocation("computercraft:turtle_crafting_table_left", "inventory");
            this.m_rightModel = new ModelResourceLocation("computercraft:turtle_crafting_table_right", "inventory");
        }
    }

    @Override
    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public Pair<IBakedModel, Matrix4f> getModel(ITurtleAccess turtle, @Nonnull TurtleSide side) {
        this.loadModelLocations();
        Object transform = null;
        Minecraft mc = Minecraft.func_71410_x();
        ModelManager modelManager = mc.func_175599_af().func_175037_a().func_178083_a();
        if (side == TurtleSide.Left) {
            return Pair.of((Object)modelManager.func_174953_a(this.m_leftModel), transform);
        }
        return Pair.of((Object)modelManager.func_174953_a(this.m_rightModel), transform);
    }
}

