/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.recipes;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.items.IComputerItem;
import dan200.computercraft.shared.turtle.items.TurtleItemFactory;
import dan200.computercraft.shared.util.RecipeUtil;
import javax.annotation.Nonnull;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;

public class TurtleRecipe
extends ShapedRecipes {
    private final NonNullList<Ingredient> m_recipe;
    private final ComputerFamily m_family;

    public TurtleRecipe(String group, int width, int height, NonNullList<Ingredient> recipe, ComputerFamily family) {
        super(group, width, height, recipe, TurtleItemFactory.create(-1, null, -1, family, null, null, 0, null));
        this.m_recipe = recipe;
        this.m_family = family;
    }

    public boolean func_77569_a(@Nonnull InventoryCrafting _inventory, @Nonnull World world) {
        return !this.func_77572_b(_inventory).func_190926_b();
    }

    @Nonnull
    public ItemStack func_77572_b(@Nonnull InventoryCrafting inventory) {
        int computerID = -1;
        String label = null;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                ItemStack item = inventory.func_70463_b(x, y);
                Ingredient target = (Ingredient)this.m_recipe.get(x + y * 3);
                if (item.func_77973_b() instanceof IComputerItem) {
                    IComputerItem itemComputer = (IComputerItem)item.func_77973_b();
                    if (itemComputer.getFamily(item) != this.m_family) {
                        return ItemStack.field_190927_a;
                    }
                    computerID = itemComputer.getComputerID(item);
                    label = itemComputer.getLabel(item);
                    continue;
                }
                if (target.apply(item)) continue;
                return ItemStack.field_190927_a;
            }
        }
        if (this.m_family != ComputerFamily.Beginners) {
            return TurtleItemFactory.create(computerID, label, -1, this.m_family, null, null, 0, null);
        }
        return TurtleItemFactory.create(-1, label, -1, this.m_family, null, null, 0, null);
    }

    public static class Factory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            ComputerFamily family;
            String group = JsonUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            String familyName = JsonUtils.func_151200_h((JsonObject)json, (String)"family");
            try {
                family = ComputerFamily.valueOf(familyName);
            }
            catch (IllegalArgumentException e) {
                throw new JsonSyntaxException("Unknown computer family '" + familyName + "'");
            }
            CraftingHelper.ShapedPrimer primer = RecipeUtil.getPrimer(context, json);
            return new TurtleRecipe(group, primer.width, primer.height, (NonNullList<Ingredient>)primer.input, family);
        }
    }
}

