/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.proxy;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.core.computer.MainThread;
import dan200.computercraft.shared.common.ColourableRecipe;
import dan200.computercraft.shared.common.DefaultBundledRedstoneProvider;
import dan200.computercraft.shared.common.TileGeneric;
import dan200.computercraft.shared.computer.blocks.BlockCommandComputer;
import dan200.computercraft.shared.computer.blocks.BlockComputer;
import dan200.computercraft.shared.computer.blocks.TileCommandComputer;
import dan200.computercraft.shared.computer.blocks.TileComputer;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.inventory.ContainerComputer;
import dan200.computercraft.shared.computer.items.ItemCommandComputer;
import dan200.computercraft.shared.computer.items.ItemComputer;
import dan200.computercraft.shared.media.common.DefaultMediaProvider;
import dan200.computercraft.shared.media.inventory.ContainerHeldItem;
import dan200.computercraft.shared.media.items.ItemDiskExpanded;
import dan200.computercraft.shared.media.items.ItemDiskLegacy;
import dan200.computercraft.shared.media.items.ItemPrintout;
import dan200.computercraft.shared.media.items.ItemTreasureDisk;
import dan200.computercraft.shared.media.recipes.DiskRecipe;
import dan200.computercraft.shared.media.recipes.PrintoutRecipe;
import dan200.computercraft.shared.network.ComputerCraftPacket;
import dan200.computercraft.shared.peripheral.commandblock.CommandBlockPeripheralProvider;
import dan200.computercraft.shared.peripheral.common.BlockCable;
import dan200.computercraft.shared.peripheral.common.BlockPeripheral;
import dan200.computercraft.shared.peripheral.common.DefaultPeripheralProvider;
import dan200.computercraft.shared.peripheral.common.ItemAdvancedModem;
import dan200.computercraft.shared.peripheral.common.ItemCable;
import dan200.computercraft.shared.peripheral.common.ItemPeripheral;
import dan200.computercraft.shared.peripheral.diskdrive.ContainerDiskDrive;
import dan200.computercraft.shared.peripheral.diskdrive.TileDiskDrive;
import dan200.computercraft.shared.peripheral.modem.BlockAdvancedModem;
import dan200.computercraft.shared.peripheral.modem.TileAdvancedModem;
import dan200.computercraft.shared.peripheral.modem.TileCable;
import dan200.computercraft.shared.peripheral.modem.TileWirelessModem;
import dan200.computercraft.shared.peripheral.monitor.TileMonitor;
import dan200.computercraft.shared.peripheral.printer.ContainerPrinter;
import dan200.computercraft.shared.peripheral.printer.TilePrinter;
import dan200.computercraft.shared.peripheral.speaker.TileSpeaker;
import dan200.computercraft.shared.pocket.inventory.ContainerPocketComputer;
import dan200.computercraft.shared.pocket.items.ItemPocketComputer;
import dan200.computercraft.shared.pocket.items.PocketComputerItemFactory;
import dan200.computercraft.shared.pocket.peripherals.PocketModem;
import dan200.computercraft.shared.pocket.peripherals.PocketSpeaker;
import dan200.computercraft.shared.pocket.recipes.PocketComputerUpgradeRecipe;
import dan200.computercraft.shared.proxy.IComputerCraftProxy;
import dan200.computercraft.shared.turtle.blocks.TileTurtle;
import dan200.computercraft.shared.turtle.inventory.ContainerTurtle;
import dan200.computercraft.shared.util.Colour;
import dan200.computercraft.shared.util.CreativeTabMain;
import dan200.computercraft.shared.util.ImpostorRecipe;
import dan200.computercraft.shared.util.ImpostorShapelessRecipe;
import dan200.computercraft.shared.util.StringUtil;
import java.io.File;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemRecord;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class ComputerCraftProxyCommon
implements IComputerCraftProxy {
    @Override
    public void preInit() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        ComputerCraft.mainCreativeTab = new CreativeTabMain(CreativeTabs.getNextID());
    }

    @Override
    public void init() {
        this.registerTileEntities();
        this.registerForgeHandlers();
    }

    @Override
    public abstract boolean isClient();

    @Override
    public abstract boolean getGlobalCursorBlink();

    @Override
    public abstract long getRenderFrame();

    @Override
    public void deleteDisplayLists(int list, int range) {
    }

    @Override
    public abstract Object getFixedWidthFontRenderer();

    @Override
    public String getRecordInfo(@Nonnull ItemStack recordStack) {
        Item item = recordStack.func_77973_b();
        if (item instanceof ItemRecord) {
            ItemRecord record = (ItemRecord)item;
            return StringUtil.translateToLocal(record.field_185077_c);
        }
        return null;
    }

    @Override
    public abstract void playRecord(SoundEvent var1, String var2, World var3, BlockPos var4);

    @Override
    public abstract Object getDiskDriveGUI(InventoryPlayer var1, TileDiskDrive var2);

    @Override
    public abstract Object getComputerGUI(TileComputer var1);

    @Override
    public abstract Object getPrinterGUI(InventoryPlayer var1, TilePrinter var2);

    @Override
    public abstract Object getTurtleGUI(InventoryPlayer var1, TileTurtle var2);

    @Override
    public abstract Object getPrintoutGUI(EntityPlayer var1, EnumHand var2);

    @Override
    public abstract Object getPocketComputerGUI(EntityPlayer var1, EnumHand var2);

    @Override
    public abstract File getWorldDir(World var1);

    @Override
    public void handlePacket(ComputerCraftPacket packet, EntityPlayer player) {
        MinecraftServer listener = player.func_184102_h();
        if (listener != null) {
            if (listener.func_152345_ab()) {
                this.processPacket(packet, player);
            } else {
                listener.func_152344_a(() -> this.processPacket(packet, player));
            }
        }
    }

    private void processPacket(ComputerCraftPacket packet, EntityPlayer player) {
        switch (packet.m_packetType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                int instance = packet.m_dataInt[0];
                ServerComputer computer = (ServerComputer)ComputerCraft.serverComputerRegistry.get(instance);
                if (computer == null) break;
                computer.handlePacket(packet, player);
                break;
            }
            case 9: {
                TileGeneric generic;
                SPacketUpdateTileEntity description;
                int x = packet.m_dataInt[0];
                int y = packet.m_dataInt[1];
                int z = packet.m_dataInt[2];
                BlockPos pos = new BlockPos(x, y, z);
                World world = player.func_130014_f_();
                TileEntity tileEntity = world.func_175625_s(pos);
                if (tileEntity == null || !(tileEntity instanceof TileGeneric) || (description = (generic = (TileGeneric)tileEntity).func_189518_D_()) == null) break;
                ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)description);
                break;
            }
        }
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        ComputerCraft.Blocks.computer = new BlockComputer();
        registry.register(ComputerCraft.Blocks.computer.setRegistryName(new ResourceLocation("computercraft", "computer")));
        ComputerCraft.Blocks.peripheral = new BlockPeripheral();
        registry.register(ComputerCraft.Blocks.peripheral.setRegistryName(new ResourceLocation("computercraft", "peripheral")));
        ComputerCraft.Blocks.cable = new BlockCable();
        registry.register(ComputerCraft.Blocks.cable.setRegistryName(new ResourceLocation("computercraft", "cable")));
        ComputerCraft.Blocks.commandComputer = new BlockCommandComputer();
        registry.register(ComputerCraft.Blocks.commandComputer.setRegistryName(new ResourceLocation("computercraft", "command_computer")));
        ComputerCraft.Blocks.advancedModem = new BlockAdvancedModem();
        registry.register(ComputerCraft.Blocks.advancedModem.setRegistryName(new ResourceLocation("computercraft", "advanced_modem")));
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register(new ItemComputer(ComputerCraft.Blocks.computer).setRegistryName(new ResourceLocation("computercraft", "computer")));
        registry.register(new ItemPeripheral(ComputerCraft.Blocks.peripheral).setRegistryName(new ResourceLocation("computercraft", "peripheral")));
        registry.register(new ItemCable(ComputerCraft.Blocks.cable).setRegistryName(new ResourceLocation("computercraft", "cable")));
        registry.register(new ItemCommandComputer(ComputerCraft.Blocks.commandComputer).setRegistryName(new ResourceLocation("computercraft", "command_computer")));
        registry.register(new ItemAdvancedModem(ComputerCraft.Blocks.advancedModem).setRegistryName(new ResourceLocation("computercraft", "advanced_modem")));
        ComputerCraft.Items.disk = new ItemDiskLegacy();
        registry.register(ComputerCraft.Items.disk.setRegistryName(new ResourceLocation("computercraft", "disk")));
        ComputerCraft.Items.diskExpanded = new ItemDiskExpanded();
        registry.register(ComputerCraft.Items.diskExpanded.setRegistryName(new ResourceLocation("computercraft", "disk_expanded")));
        ComputerCraft.Items.treasureDisk = new ItemTreasureDisk();
        registry.register(ComputerCraft.Items.treasureDisk.setRegistryName(new ResourceLocation("computercraft", "treasure_disk")));
        ComputerCraft.Items.printout = new ItemPrintout();
        registry.register(ComputerCraft.Items.printout.setRegistryName(new ResourceLocation("computercraft", "printout")));
        ComputerCraft.Items.pocketComputer = new ItemPocketComputer();
        registry.register(ComputerCraft.Items.pocketComputer.setRegistryName(new ResourceLocation("computercraft", "pocket_computer")));
    }

    @SubscribeEvent
    public void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register(new DiskRecipe().setRegistryName(new ResourceLocation("computercraft:disk")));
        registry.register(new ColourableRecipe().setRegistryName(new ResourceLocation("computercraft:colour")));
        ItemStack paper = new ItemStack(Items.field_151121_aF, 1);
        ItemStack redstone = new ItemStack(Items.field_151137_ax, 1);
        for (int colour = 0; colour < 16; ++colour) {
            ItemStack disk = ItemDiskLegacy.createFromIDAndColour(-1, null, Colour.values()[colour].getHex());
            ItemStack dye = new ItemStack(Items.field_151100_aR, 1, colour);
            int diskIdx = 0;
            ItemStack[] disks = new ItemStack[15];
            for (int otherColour = 0; otherColour < 16; ++otherColour) {
                if (colour == otherColour) continue;
                disks[diskIdx++] = ItemDiskLegacy.createFromIDAndColour(-1, null, Colour.values()[otherColour].getHex());
            }
            registry.register(new ImpostorShapelessRecipe("computercraft:disk", disk, new ItemStack[]{redstone, paper, dye}).setRegistryName(new ResourceLocation("computercraft:disk_imposter_" + colour)));
            registry.register(new ImpostorShapelessRecipe("computercraft:disk", disk, (NonNullList<Ingredient>)NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{Ingredient.func_193369_a((ItemStack[])disks), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{dye})})).setRegistryName(new ResourceLocation("computercraft:disk_imposter_convert_" + colour)));
        }
        registry.register(new PrintoutRecipe().setRegistryName(new ResourceLocation("computercraft:printout")));
        ComputerCraft.PocketUpgrades.wirelessModem = new PocketModem(false);
        ComputerCraftAPI.registerPocketUpgrade(ComputerCraft.PocketUpgrades.wirelessModem);
        ComputerCraft.PocketUpgrades.advancedModem = new PocketModem(true);
        ComputerCraftAPI.registerPocketUpgrade(ComputerCraft.PocketUpgrades.advancedModem);
        ComputerCraft.PocketUpgrades.pocketSpeaker = new PocketSpeaker();
        ComputerCraftAPI.registerPocketUpgrade(ComputerCraft.PocketUpgrades.pocketSpeaker);
        registry.register(new PocketComputerUpgradeRecipe().setRegistryName(new ResourceLocation("computercraft:pocket_computer_upgrade")));
        ItemStack pocketComputer = PocketComputerItemFactory.create(-1, null, -1, ComputerFamily.Normal, null);
        ItemStack advancedPocketComputer = PocketComputerItemFactory.create(-1, null, -1, ComputerFamily.Advanced, null);
        for (IPocketUpgrade upgrade : ComputerCraft.getVanillaPocketUpgrades()) {
            registry.register(new ImpostorRecipe("computercraft:normal_pocket_upgrade", 1, 2, new ItemStack[]{upgrade.getCraftingItem(), pocketComputer}, PocketComputerItemFactory.create(-1, null, -1, ComputerFamily.Normal, upgrade)).setRegistryName(new ResourceLocation("computercraft:normal_pocket_upgrade_" + upgrade.getUpgradeID().toString().replace(':', '_'))));
            registry.register(new ImpostorRecipe("computercraft:advanced_pocket_upgrade", 1, 2, new ItemStack[]{upgrade.getCraftingItem(), advancedPocketComputer}, PocketComputerItemFactory.create(-1, null, -1, ComputerFamily.Advanced, upgrade)).setRegistryName(new ResourceLocation("computercraft:advanced_pocket_upgrade_" + upgrade.getUpgradeID().toString().replace(':', '_'))));
        }
    }

    @SubscribeEvent
    public void remapItems(RegistryEvent.MissingMappings<Item> mappings) {
        for (RegistryEvent.MissingMappings.Mapping mapping : mappings.getAllMappings()) {
            String domain = mapping.key.func_110624_b();
            if (!domain.equalsIgnoreCase("computercraft")) continue;
            String key = mapping.key.func_110623_a();
            if (key.equalsIgnoreCase("CC-Computer")) {
                mapping.remap((IForgeRegistryEntry)Item.func_150898_a((Block)ComputerCraft.Blocks.computer));
                continue;
            }
            if (key.equalsIgnoreCase("CC-Peripheral")) {
                mapping.remap((IForgeRegistryEntry)Item.func_150898_a((Block)ComputerCraft.Blocks.peripheral));
                continue;
            }
            if (key.equalsIgnoreCase("CC-Cable")) {
                mapping.remap((IForgeRegistryEntry)Item.func_150898_a((Block)ComputerCraft.Blocks.cable));
                continue;
            }
            if (key.equalsIgnoreCase("diskExpanded")) {
                mapping.remap((IForgeRegistryEntry)ComputerCraft.Items.diskExpanded);
                continue;
            }
            if (key.equalsIgnoreCase("treasureDisk")) {
                mapping.remap((IForgeRegistryEntry)ComputerCraft.Items.treasureDisk);
                continue;
            }
            if (!key.equalsIgnoreCase("pocketComputer")) continue;
            mapping.remap((IForgeRegistryEntry)ComputerCraft.Items.pocketComputer);
        }
    }

    @SubscribeEvent
    public void remapBlocks(RegistryEvent.MissingMappings<Block> mappings) {
        for (RegistryEvent.MissingMappings.Mapping mapping : mappings.getAllMappings()) {
            String domain = mapping.key.func_110624_b();
            if (!domain.equalsIgnoreCase("computercraft")) continue;
            String key = mapping.key.func_110623_a();
            if (key.equalsIgnoreCase("CC-Computer")) {
                mapping.remap((IForgeRegistryEntry)ComputerCraft.Blocks.computer);
                continue;
            }
            if (key.equalsIgnoreCase("CC-Peripheral")) {
                mapping.remap((IForgeRegistryEntry)ComputerCraft.Blocks.peripheral);
                continue;
            }
            if (!key.equalsIgnoreCase("CC-Cable")) continue;
            mapping.remap((IForgeRegistryEntry)ComputerCraft.Blocks.cable);
        }
    }

    private void registerTileEntities() {
        GameRegistry.registerTileEntity(TileComputer.class, (String)"computercraft : computer");
        GameRegistry.registerTileEntity(TileDiskDrive.class, (String)"computercraft : diskdrive");
        GameRegistry.registerTileEntity(TileWirelessModem.class, (String)"computercraft : wirelessmodem");
        GameRegistry.registerTileEntity(TileMonitor.class, (String)"computercraft : monitor");
        GameRegistry.registerTileEntity(TilePrinter.class, (String)"computercraft : ccprinter");
        GameRegistry.registerTileEntity(TileCable.class, (String)"computercraft : wiredmodem");
        GameRegistry.registerTileEntity(TileCommandComputer.class, (String)"computercraft : command_computer");
        GameRegistry.registerTileEntity(TileAdvancedModem.class, (String)"computercraft : advanced_modem");
        GameRegistry.registerTileEntity(TileSpeaker.class, (String)"computercraft : speaker");
        ComputerCraftAPI.registerPeripheralProvider(new DefaultPeripheralProvider());
        if (ComputerCraft.enableCommandBlock) {
            ComputerCraftAPI.registerPeripheralProvider(new CommandBlockPeripheralProvider());
        }
        ComputerCraftAPI.registerBundledRedstoneProvider(new DefaultBundledRedstoneProvider());
        ComputerCraftAPI.registerMediaProvider(new DefaultMediaProvider());
    }

    private void registerForgeHandlers() {
        ForgeHandlers handlers = new ForgeHandlers();
        MinecraftForge.EVENT_BUS.register((Object)handlers);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)ComputerCraft.instance, (IGuiHandler)handlers);
    }

    public class ForgeHandlers
    implements IGuiHandler {
        private ForgeHandlers() {
        }

        public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
            BlockPos pos = new BlockPos(x, y, z);
            switch (id) {
                case 100: {
                    TileEntity tile = world.func_175625_s(pos);
                    if (tile == null || !(tile instanceof TileDiskDrive)) break;
                    TileDiskDrive drive = (TileDiskDrive)tile;
                    return new ContainerDiskDrive((IInventory)player.field_71071_by, drive);
                }
                case 101: {
                    TileEntity tile = world.func_175625_s(pos);
                    if (tile == null || !(tile instanceof TileComputer)) break;
                    TileComputer computer = (TileComputer)tile;
                    return new ContainerComputer(computer);
                }
                case 102: {
                    TileEntity tile = world.func_175625_s(pos);
                    if (tile == null || !(tile instanceof TilePrinter)) break;
                    TilePrinter printer = (TilePrinter)tile;
                    return new ContainerPrinter((IInventory)player.field_71071_by, printer);
                }
                case 103: {
                    TileEntity tile = world.func_175625_s(pos);
                    if (tile == null || !(tile instanceof TileTurtle)) break;
                    TileTurtle turtle = (TileTurtle)tile;
                    return new ContainerTurtle((IInventory)player.field_71071_by, turtle.getAccess(), turtle.getServerComputer());
                }
                case 105: {
                    return new ContainerHeldItem(player, x == 0 ? EnumHand.MAIN_HAND : EnumHand.MAIN_HAND);
                }
                case 106: {
                    return new ContainerPocketComputer(player, x == 0 ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND);
                }
            }
            return null;
        }

        public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
            BlockPos pos = new BlockPos(x, y, z);
            switch (id) {
                case 100: {
                    TileEntity tile = world.func_175625_s(pos);
                    if (tile == null || !(tile instanceof TileDiskDrive)) break;
                    TileDiskDrive drive = (TileDiskDrive)tile;
                    return ComputerCraftProxyCommon.this.getDiskDriveGUI(player.field_71071_by, drive);
                }
                case 101: {
                    TileEntity tile = world.func_175625_s(pos);
                    if (tile == null || !(tile instanceof TileComputer)) break;
                    TileComputer computer = (TileComputer)tile;
                    return ComputerCraftProxyCommon.this.getComputerGUI(computer);
                }
                case 102: {
                    TileEntity tile = world.func_175625_s(pos);
                    if (tile == null || !(tile instanceof TilePrinter)) break;
                    TilePrinter printer = (TilePrinter)tile;
                    return ComputerCraftProxyCommon.this.getPrinterGUI(player.field_71071_by, printer);
                }
                case 103: {
                    TileEntity tile = world.func_175625_s(pos);
                    if (tile == null || !(tile instanceof TileTurtle)) break;
                    TileTurtle turtle = (TileTurtle)tile;
                    return ComputerCraftProxyCommon.this.getTurtleGUI(player.field_71071_by, turtle);
                }
                case 105: {
                    return ComputerCraftProxyCommon.this.getPrintoutGUI(player, x == 0 ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND);
                }
                case 106: {
                    return ComputerCraftProxyCommon.this.getPocketComputerGUI(player, x == 0 ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND);
                }
            }
            return null;
        }

        @SubscribeEvent
        public void onConnectionOpened(FMLNetworkEvent.ClientConnectedToServerEvent event) {
            ComputerCraft.clientComputerRegistry.reset();
        }

        @SubscribeEvent
        public void onConnectionClosed(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
            ComputerCraft.clientComputerRegistry.reset();
        }

        @SubscribeEvent
        public void onClientTick(TickEvent.ClientTickEvent event) {
            if (event.phase == TickEvent.Phase.START) {
                ComputerCraft.clientComputerRegistry.update();
            }
        }

        @SubscribeEvent
        public void onServerTick(TickEvent.ServerTickEvent event) {
            if (event.phase == TickEvent.Phase.START) {
                MainThread.executePendingTasks();
                ComputerCraft.serverComputerRegistry.update();
            }
        }

        @SubscribeEvent
        public void onWorldLoad(WorldEvent.Load event) {
        }

        @SubscribeEvent
        public void onWorldUnload(WorldEvent.Unload event) {
        }

        @SubscribeEvent
        public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("computercraft")) {
                ComputerCraft.syncConfig();
            }
        }
    }
}

