/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.pocket.peripherals;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.pocket.IPocketAccess;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.shared.peripheral.PeripheralType;
import dan200.computercraft.shared.peripheral.common.PeripheralItemFactory;
import dan200.computercraft.shared.pocket.peripherals.PocketModemPeripheral;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class PocketModem
implements IPocketUpgrade {
    private final boolean m_advanced;

    public PocketModem(boolean m_advanced) {
        this.m_advanced = m_advanced;
    }

    @Override
    @Nonnull
    public ResourceLocation getUpgradeID() {
        return this.m_advanced ? new ResourceLocation("computercraft", "advanved_modem") : new ResourceLocation("computercraft", "wireless_modem");
    }

    @Override
    @Nonnull
    public String getUnlocalisedAdjective() {
        return this.m_advanced ? "upgrade.computercraft:advanced_modem.adjective" : "upgrade.computercraft:wireless_modem.adjective";
    }

    @Override
    @Nonnull
    public ItemStack getCraftingItem() {
        return PeripheralItemFactory.create(this.m_advanced ? PeripheralType.AdvancedModem : PeripheralType.WirelessModem, null, 1);
    }

    @Override
    @Nullable
    public IPeripheral createPeripheral(@Nonnull IPocketAccess access) {
        return new PocketModemPeripheral(this.m_advanced);
    }

    @Override
    public void update(@Nonnull IPocketAccess access, @Nullable IPeripheral peripheral) {
        if (peripheral instanceof PocketModemPeripheral) {
            Entity entity = access.getEntity();
            PocketModemPeripheral modem = (PocketModemPeripheral)peripheral;
            if (entity instanceof EntityLivingBase) {
                EntityLivingBase player = (EntityLivingBase)entity;
                modem.setLocation(entity.func_130014_f_(), player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
            } else if (entity != null) {
                modem.setLocation(entity.func_130014_f_(), entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            }
            access.setLight(modem.isActive() ? 0xBA0000 : -1);
        }
    }
}

