/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.media.items;

import dan200.computercraft.ComputerCraft;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;

public class ItemPrintout
extends Item {
    public static final int LINES_PER_PAGE = 21;
    public static final int LINE_MAX_LENGTH = 25;
    public static final int MAX_PAGES = 16;

    public ItemPrintout() {
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77655_b("computercraft:page");
        this.func_77637_a(ComputerCraft.mainCreativeTab);
    }

    public void func_150895_a(@Nonnull CreativeTabs tabs, @Nonnull NonNullList<ItemStack> list) {
        if (!this.func_194125_a(tabs)) {
            return;
        }
        list.add((Object)ItemPrintout.createSingleFromTitleAndText(null, new String[21], new String[21]));
        list.add((Object)ItemPrintout.createMultipleFromTitleAndText(null, new String[42], new String[42]));
        list.add((Object)ItemPrintout.createBookFromTitleAndText(null, new String[42], new String[42]));
    }

    public void func_77624_a(@Nonnull ItemStack itemstack, World world, List<String> list, ITooltipFlag flag) {
        String title = ItemPrintout.getTitle(itemstack);
        if (title != null && title.length() > 0) {
            list.add(title);
        }
    }

    @Nonnull
    public String func_77667_c(@Nonnull ItemStack stack) {
        Type type = ItemPrintout.getType(stack);
        switch (type) {
            default: {
                return "item.computercraft:page";
            }
            case Multiple: {
                return "item.computercraft:pages";
            }
            case Book: 
        }
        return "item.computercraft:book";
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        if (!world.field_72995_K) {
            ComputerCraft.openPrintoutGUI(player, hand);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    @Nonnull
    private static ItemStack createFromTitleAndText(Type type, String title, String[] text, String[] colours) {
        int i;
        int damage;
        switch (type) {
            default: {
                damage = 0;
                break;
            }
            case Multiple: {
                damage = 1;
                break;
            }
            case Book: {
                damage = 2;
            }
        }
        ItemStack stack = new ItemStack((Item)ComputerCraft.Items.printout, 1, damage);
        NBTTagCompound nbt = new NBTTagCompound();
        if (title != null) {
            nbt.func_74778_a("title", title);
        }
        if (text != null) {
            nbt.func_74768_a("pages", text.length / 21);
            for (i = 0; i < text.length; ++i) {
                if (text[i] == null) continue;
                nbt.func_74778_a("line" + i, text[i]);
            }
        }
        if (colours != null) {
            for (i = 0; i < colours.length; ++i) {
                if (colours[i] == null) continue;
                nbt.func_74778_a("colour" + i, colours[i]);
            }
        }
        stack.func_77982_d(nbt);
        return stack;
    }

    @Nonnull
    public static ItemStack createSingleFromTitleAndText(String title, String[] text, String[] colours) {
        return ItemPrintout.createFromTitleAndText(Type.Single, title, text, colours);
    }

    @Nonnull
    public static ItemStack createMultipleFromTitleAndText(String title, String[] text, String[] colours) {
        return ItemPrintout.createFromTitleAndText(Type.Multiple, title, text, colours);
    }

    @Nonnull
    public static ItemStack createBookFromTitleAndText(String title, String[] text, String[] colours) {
        return ItemPrintout.createFromTitleAndText(Type.Book, title, text, colours);
    }

    public static Type getType(@Nonnull ItemStack stack) {
        int damage = stack.func_77952_i();
        switch (damage) {
            default: {
                return Type.Single;
            }
            case 1: {
                return Type.Multiple;
            }
            case 2: 
        }
        return Type.Book;
    }

    public static String getTitle(@Nonnull ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_74764_b("title")) {
            return nbt.func_74779_i("title");
        }
        return null;
    }

    public static int getPageCount(@Nonnull ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_74764_b("pages")) {
            return nbt.func_74762_e("pages");
        }
        return 1;
    }

    public static String[] getText(@Nonnull ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        int numLines = ItemPrintout.getPageCount(stack) * 21;
        String[] lines = new String[numLines];
        for (int i = 0; i < lines.length; ++i) {
            lines[i] = nbt != null ? nbt.func_74779_i("line" + i) : "";
        }
        return lines;
    }

    public static String[] getColours(@Nonnull ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        int numLines = ItemPrintout.getPageCount(stack) * 21;
        String[] lines = new String[numLines];
        for (int i = 0; i < lines.length; ++i) {
            lines[i] = nbt != null ? nbt.func_74779_i("colour" + i) : "";
        }
        return lines;
    }

    public static enum Type {
        Single,
        Multiple,
        Book;

    }
}

