/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.apis;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.core.apis.ArgumentHelper;
import dan200.computercraft.core.apis.ILuaAPI;
import dan200.computercraft.shared.computer.blocks.TileCommandComputer;
import dan200.computercraft.shared.util.WorldUtil;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class CommandAPI
implements ILuaAPI {
    private TileCommandComputer m_computer;

    public CommandAPI(TileCommandComputer computer) {
        this.m_computer = computer;
    }

    @Override
    public String[] getNames() {
        return new String[]{"commands"};
    }

    @Override
    public void startup() {
    }

    @Override
    public void advance(double dt) {
    }

    @Override
    public void shutdown() {
    }

    @Override
    @Nonnull
    public String[] getMethodNames() {
        return new String[]{"exec", "execAsync", "list", "getBlockPosition", "getBlockInfos", "getBlockInfo"};
    }

    private Map<Object, Object> createOutput(String output) {
        HashMap<Object, Object> result = new HashMap<Object, Object>(1);
        result.put(1, output);
        return result;
    }

    private Object[] doCommand(String command) {
        MinecraftServer server = this.m_computer.func_145831_w().func_73046_m();
        if (server != null && server.func_82356_Z()) {
            ICommandManager commandManager = server.func_71187_D();
            try {
                TileCommandComputer.CommandSender sender = this.m_computer.getCommandSender();
                sender.clearOutput();
                int result = commandManager.func_71556_a((ICommandSender)sender, command);
                return new Object[]{result > 0, sender.copyOutput()};
            }
            catch (Throwable t) {
                if (ComputerCraft.logPeripheralErrors) {
                    ComputerCraft.log.error("Error running command.", t);
                }
                return new Object[]{false, this.createOutput("Java Exception Thrown: " + t.toString())};
            }
        }
        return new Object[]{false, this.createOutput("Command blocks disabled by server")};
    }

    private Object getBlockInfo(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        String name = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)block)).toString();
        int metadata = block.func_176201_c(state);
        HashMap<String, Object> table = new HashMap<String, Object>();
        table.put("name", name);
        table.put("metadata", metadata);
        HashMap stateTable = new HashMap();
        for (Map.Entry entry : state.func_185899_b((IBlockAccess)world, pos).func_177228_b().entrySet()) {
            String propertyName = ((IProperty)entry.getKey()).func_177701_a();
            Object value = entry.getValue();
            if (value instanceof String || value instanceof Number || value instanceof Boolean) {
                stateTable.put(propertyName, value);
                continue;
            }
            stateTable.put(propertyName, value.toString());
        }
        table.put("state", stateTable);
        return table;
    }

    @Override
    public Object[] callMethod(@Nonnull ILuaContext context, int method, @Nonnull Object[] arguments) throws LuaException, InterruptedException {
        switch (method) {
            case 0: {
                String command = ArgumentHelper.getString(arguments, 0);
                return context.executeMainThreadTask(() -> this.doCommand(command));
            }
            case 1: {
                String command = ArgumentHelper.getString(arguments, 0);
                long taskID = context.issueMainThreadTask(() -> this.doCommand(command));
                return new Object[]{taskID};
            }
            case 2: {
                return context.executeMainThreadTask(() -> {
                    int i = 1;
                    HashMap<Integer, String> result = new HashMap<Integer, String>();
                    MinecraftServer server = this.m_computer.func_145831_w().func_73046_m();
                    if (server != null) {
                        ICommandManager commandManager = server.func_71187_D();
                        TileCommandComputer.CommandSender commmandSender = this.m_computer.getCommandSender();
                        Map commands = commandManager.func_71555_a();
                        for (Map.Entry entry : commands.entrySet()) {
                            String name = (String)entry.getKey();
                            ICommand command = (ICommand)entry.getValue();
                            try {
                                if (!command.func_184882_a(server, (ICommandSender)commmandSender)) continue;
                                result.put(i++, name);
                            }
                            catch (Throwable t) {
                                if (!ComputerCraft.logPeripheralErrors) continue;
                                ComputerCraft.log.error("Error checking permissions of command.", t);
                            }
                        }
                    }
                    return new Object[]{result};
                });
            }
            case 3: {
                BlockPos pos = this.m_computer.func_174877_v();
                return new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()};
            }
            case 4: {
                int minx = ArgumentHelper.getInt(arguments, 0);
                int miny = ArgumentHelper.getInt(arguments, 1);
                int minz = ArgumentHelper.getInt(arguments, 2);
                int maxx = ArgumentHelper.getInt(arguments, 3);
                int maxy = ArgumentHelper.getInt(arguments, 4);
                int maxz = ArgumentHelper.getInt(arguments, 5);
                return context.executeMainThreadTask(() -> {
                    World world = this.m_computer.func_145831_w();
                    BlockPos min = new BlockPos(Math.min(minx, maxx), Math.min(miny, maxy), Math.min(minz, maxz));
                    BlockPos max = new BlockPos(Math.max(minx, maxx), Math.max(miny, maxy), Math.max(minz, maxz));
                    if (!WorldUtil.isBlockInWorld(world, min) || !WorldUtil.isBlockInWorld(world, max)) {
                        throw new LuaException("Co-ordinates out or range");
                    }
                    if ((max.func_177958_n() - min.func_177958_n() + 1) * (max.func_177956_o() - min.func_177956_o() + 1) * (max.func_177952_p() - min.func_177952_p() + 1) > 4096) {
                        throw new LuaException("Too many blocks");
                    }
                    int i = 1;
                    HashMap<Integer, Object> results = new HashMap<Integer, Object>();
                    for (int y = min.func_177956_o(); y <= max.func_177956_o(); ++y) {
                        for (int z = min.func_177952_p(); z <= max.func_177952_p(); ++z) {
                            for (int x = min.func_177958_n(); x <= max.func_177958_n(); ++x) {
                                BlockPos pos = new BlockPos(x, y, z);
                                results.put(i++, this.getBlockInfo(world, pos));
                            }
                        }
                    }
                    return new Object[]{results};
                });
            }
            case 5: {
                int x = ArgumentHelper.getInt(arguments, 0);
                int y = ArgumentHelper.getInt(arguments, 1);
                int z = ArgumentHelper.getInt(arguments, 2);
                return context.executeMainThreadTask(() -> {
                    BlockPos position;
                    World world = this.m_computer.func_145831_w();
                    if (WorldUtil.isBlockInWorld(world, position = new BlockPos(x, y, z))) {
                        return new Object[]{this.getBlockInfo(world, position)};
                    }
                    throw new LuaException("co-ordinates out or range");
                });
            }
        }
        return null;
    }
}

