/*
 * Decompiled with CFR 0.152.
 */
package cofh.repack.codechicken.lib.render;

import cofh.repack.codechicken.lib.render.CCModel;
import cofh.repack.codechicken.lib.render.TextureDataHolder;
import cofh.repack.codechicken.lib.render.TextureUtils;
import cofh.repack.codechicken.lib.render.Vertex5;
import cofh.repack.codechicken.lib.render.uv.UV;
import cofh.repack.codechicken.lib.render.uv.UVScale;
import cofh.repack.codechicken.lib.vec.BlockCoord;
import cofh.repack.codechicken.lib.vec.Cuboid6;
import cofh.repack.codechicken.lib.vec.CuboidCoord;
import cofh.repack.codechicken.lib.vec.Rectangle4i;
import cofh.repack.codechicken.lib.vec.Rotation;
import cofh.repack.codechicken.lib.vec.Scale;
import cofh.repack.codechicken.lib.vec.Transformation;
import cofh.repack.codechicken.lib.vec.TransformationList;
import cofh.repack.codechicken.lib.vec.Translation;
import cofh.repack.codechicken.lib.vec.Vector3;
import com.google.common.collect.HashMultimap;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;

public class QBImporter {
    private static final int[][] vertOrder = new int[][]{{3, 0}, {1, 0}, {1, 2}, {3, 2}};
    public static final int TEXTUREPLANES = 1;
    public static final int SQUARETEXTURE = 2;
    public static final int MERGETEXTURES = 4;
    public static final int SCALEMC = 8;
    private static final int CODEFLAG = Integer.reverseBytes(2);
    private static final int NEXTSLICEFLAG = Integer.reverseBytes(6);

    private static String readAsciiString(DataInputStream dataInputStream) throws IOException {
        byte[] byArray = new byte[dataInputStream.readByte() & 0xFF];
        dataInputStream.readFully(byArray);
        return new String(byArray, "US-ASCII");
    }

    private static int readTni(DataInputStream dataInputStream) throws IOException {
        return Integer.reverseBytes(dataInputStream.readInt());
    }

    public static QBModel loadQB(InputStream inputStream) throws IOException {
        boolean bl;
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        QBModel qBModel = new QBModel();
        int n = dataInputStream.readInt();
        int n2 = dataInputStream.readInt();
        qBModel.rightHanded = dataInputStream.readInt() != 0;
        boolean bl2 = dataInputStream.readInt() != 0;
        boolean bl3 = bl = dataInputStream.readInt() != 0;
        if (bl) {
            throw new IllegalArgumentException("Encoded Visiblity States not supported");
        }
        qBModel.matrices = new QBMatrix[QBImporter.readTni(dataInputStream)];
        for (int i = 0; i < qBModel.matrices.length; ++i) {
            QBMatrix qBMatrix;
            qBModel.matrices[i] = qBMatrix = new QBMatrix();
            qBMatrix.name = QBImporter.readAsciiString(dataInputStream);
            qBMatrix.size = new BlockCoord(QBImporter.readTni(dataInputStream), QBImporter.readTni(dataInputStream), QBImporter.readTni(dataInputStream));
            qBMatrix.pos = new BlockCoord(QBImporter.readTni(dataInputStream), QBImporter.readTni(dataInputStream), QBImporter.readTni(dataInputStream));
            qBMatrix.matrix = new int[qBMatrix.size.x][qBMatrix.size.y][qBMatrix.size.z];
            qBMatrix.readMatrix(dataInputStream, bl2);
            if (n2 != 1) continue;
            qBMatrix.convertBGRAtoRGBA();
        }
        return qBModel;
    }

    public static QBModel loadQB(ResourceLocation resourceLocation) {
        try {
            return QBImporter.loadQB(Minecraft.func_71410_x().func_110442_L().func_110536_a(resourceLocation).func_110527_b());
        }
        catch (Exception exception) {
            throw new RuntimeException("failed to load model: " + resourceLocation, exception);
        }
    }

    public static QBModel loadQB(File file) {
        QBModel qBModel;
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            qBModel = QBImporter.loadQB(fileInputStream);
        }
        catch (Throwable throwable) {
            try {
                fileInputStream.close();
                throw throwable;
            }
            catch (Exception exception) {
                throw new RuntimeException("failed to load model: " + file.getPath(), exception);
            }
        }
        fileInputStream.close();
        return qBModel;
    }

    public static class RasterisedModel {
        private Map<String, Holder> map = new HashMap<String, Holder>();
        private List<BufferedImage> images;
        private String[] icons;

        public RasterisedModel(List<BufferedImage> list) {
            this.images = list;
            this.icons = new String[list.size()];
        }

        public void add(String string, CCModel cCModel) {
            this.map.put(string, new Holder(cCModel, Math.min(this.map.size(), this.images.size() - 1)));
        }

        public CCModel getModel(String string) {
            return this.map.get((Object)string).m;
        }

        public IIcon getIcon(String string, IIconRegister iIconRegister, String string2) {
            int n = this.map.get((Object)string).img;
            if (this.icons[n] != null && !string2.equals(this.icons[n])) {
                throw new IllegalArgumentException("Attempted to get a previously registered icon by a different name: " + this.icons[n] + ", " + string2);
            }
            if (this.icons[n] != null) {
                return iIconRegister.func_94245_a(string2);
            }
            this.icons[n] = string2;
            return TextureUtils.getTextureSpecial(iIconRegister, string2).addTexture(new TextureDataHolder(this.images.get(n)));
        }

        private void exportImg(BufferedImage bufferedImage, File file) throws IOException {
            if (!file.exists()) {
                file.createNewFile();
            }
            ImageIO.write((RenderedImage)bufferedImage, "PNG", file);
        }

        public void export(File file, File file2) {
            try {
                if (!file.exists()) {
                    file.createNewFile();
                }
                if (!file2.exists()) {
                    file2.mkdirs();
                }
                HashMap<String, CCModel> hashMap = new HashMap<String, CCModel>();
                for (Map.Entry<String, Holder> object : this.map.entrySet()) {
                    hashMap.put(object.getKey(), object.getValue().m);
                }
                PrintWriter printWriter = new PrintWriter(file);
                CCModel.exportObj(hashMap, printWriter);
                printWriter.close();
                if (this.images.size() < this.map.size()) {
                    this.exportImg(this.images.get(0), new File(file2, file.getName().replaceAll("(.+)\\..+", "$1.png")));
                } else {
                    for (Map.Entry<String, Holder> entry : this.map.entrySet()) {
                        this.exportImg(this.images.get(entry.getValue().img), new File(file2, entry.getKey() + ".png"));
                    }
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }

        private class Holder {
            CCModel m;
            int img;

            public Holder(CCModel cCModel, int n) {
                this.m = cCModel;
                this.img = n;
            }
        }
    }

    public static class QBModel {
        public QBMatrix[] matrices;
        public boolean rightHanded;

        public RasterisedModel toRasterisedModel(int n) {
            ArrayList<QBImage> arrayList = new ArrayList<QBImage>();
            ArrayList<List<QBQuad>> arrayList2 = new ArrayList<List<QBQuad>>();
            ArrayList<BufferedImage> arrayList3 = new ArrayList<BufferedImage>();
            boolean bl = (n & 1) != 0;
            boolean bl2 = (n & 2) != 0;
            boolean bl3 = (n & 4) != 0;
            boolean bl4 = (n & 8) != 0;
            for (QBMatrix object : this.matrices) {
                List<QBQuad> list = object.extractQuads(bl);
                arrayList2.add(list);
                QBMatrix.addImages(list, arrayList);
                if (bl3) continue;
                arrayList3.add(ImagePackNode.pack(arrayList, bl2).toImage());
                arrayList.clear();
            }
            if (bl3) {
                arrayList3.add(ImagePackNode.pack(arrayList, bl2).toImage());
            }
            RasterisedModel rasterisedModel = new RasterisedModel(arrayList3);
            for (int i = 0; i < this.matrices.length; ++i) {
                QBMatrix qBMatrix = this.matrices[i];
                BufferedImage bufferedImage = (BufferedImage)arrayList3.get(bl3 ? 0 : i);
                rasterisedModel.add(qBMatrix.name, qBMatrix.buildModel((List)arrayList2.get(i), bufferedImage, bl4));
            }
            return rasterisedModel;
        }
    }

    public static class QBMatrix {
        public String name;
        public BlockCoord pos;
        public BlockCoord size;
        public int[][][] matrix;

        public void readMatrix(DataInputStream dataInputStream, boolean bl) throws IOException {
            if (bl) {
                for (int i = 0; i < this.size.z; ++i) {
                    int n;
                    int n2 = 0;
                    while ((n = dataInputStream.readInt()) != NEXTSLICEFLAG) {
                        if (n == CODEFLAG) {
                            int n3 = QBImporter.readTni(dataInputStream);
                            n = dataInputStream.readInt();
                            int n4 = 0;
                            while (n4 < n3) {
                                this.matrix[n2 % this.size.x][n2 / this.size.x][i] = n;
                                ++n4;
                                ++n2;
                            }
                            continue;
                        }
                        this.matrix[n2 % this.size.x][n2 / this.size.x][i] = n;
                        ++n2;
                    }
                }
            } else {
                for (int i = 0; i < this.size.z; ++i) {
                    for (int j = 0; j < this.size.y; ++j) {
                        for (int k = 0; k < this.size.x; ++k) {
                            this.matrix[k][j][i] = dataInputStream.readInt();
                        }
                    }
                }
            }
        }

        public void convertBGRAtoRGBA() {
            for (int i = 0; i < this.size.z; ++i) {
                for (int j = 0; j < this.size.y; ++j) {
                    for (int k = 0; k < this.size.x; ++k) {
                        int n = this.matrix[k][j][i];
                        this.matrix[k][j][i] = Integer.reverseBytes(n >>> 8) | n & 0xFF;
                    }
                }
            }
        }

        private boolean voxelFull(boolean[][][] blArray, CuboidCoord cuboidCoord) {
            for (BlockCoord blockCoord : cuboidCoord) {
                if (this.matrix[blockCoord.x][blockCoord.y][blockCoord.z] != 0) continue;
                return false;
            }
            for (BlockCoord blockCoord : cuboidCoord) {
                blArray[blockCoord.x][blockCoord.y][blockCoord.z] = false;
            }
            return true;
        }

        private QBCuboid expand(boolean[][][] blArray, BlockCoord blockCoord) {
            CuboidCoord cuboidCoord = new CuboidCoord(blockCoord);
            blArray[blockCoord.x][blockCoord.y][blockCoord.z] = false;
            for (int i = 0; i < 6; ++i) {
                CuboidCoord cuboidCoord2 = cuboidCoord.copy();
                cuboidCoord2.expand(i ^ 1, -(cuboidCoord2.size(i) - 1));
                cuboidCoord2.expand(i, 1);
                while (cuboidCoord2.getSide(i) >= 0 && cuboidCoord2.getSide(i) < this.size.getSide(i) && this.voxelFull(blArray, cuboidCoord2)) {
                    cuboidCoord2.expand(i ^ 1, -1);
                    cuboidCoord2.expand(i, 1);
                    cuboidCoord.expand(i, 1);
                }
            }
            return new QBCuboid(this, cuboidCoord);
        }

        public List<QBCuboid> rectangulate() {
            int n;
            int n2;
            int n3;
            ArrayList<QBCuboid> arrayList = new ArrayList<QBCuboid>();
            boolean[][][] blArray = new boolean[this.size.x][this.size.y][this.size.z];
            for (n3 = 0; n3 < this.size.z; ++n3) {
                for (n2 = 0; n2 < this.size.y; ++n2) {
                    for (n = 0; n < this.size.x; ++n) {
                        blArray[n][n2][n3] = this.matrix[n][n2][n3] != 0;
                    }
                }
            }
            for (n3 = 0; n3 < this.size.x; ++n3) {
                for (n2 = 0; n2 < this.size.z; ++n2) {
                    for (n = 0; n < this.size.y; ++n) {
                        if (!blArray[n3][n][n2]) continue;
                        arrayList.add(this.expand(blArray, new BlockCoord(n3, n, n2)));
                    }
                }
            }
            for (n3 = 0; n3 < arrayList.size(); ++n3) {
                for (n2 = n3 + 1; n2 < arrayList.size(); ++n2) {
                    QBCuboid.clip((QBCuboid)arrayList.get(n3), (QBCuboid)arrayList.get(n2));
                }
            }
            return arrayList;
        }

        public List<QBQuad> extractQuads(boolean bl) {
            LinkedList<QBQuad> linkedList = new LinkedList<QBQuad>();
            for (QBCuboid qBCuboid : this.rectangulate()) {
                qBCuboid.extractQuads(linkedList);
            }
            if (bl) {
                this.optimisePlanes(linkedList);
            }
            return linkedList;
        }

        private void optimisePlanes(List<QBQuad> list) {
            HashMultimap hashMultimap = HashMultimap.create();
            for (QBQuad object : list) {
                hashMultimap.put((Object)(object.side | (int)object.verts[0].vec.getSide(object.side) << 3), (Object)object);
            }
            list.clear();
            for (Integer n : hashMultimap.keySet()) {
                Object object2;
                Collection collection = hashMultimap.get((Object)n);
                if (collection.size() == 1) {
                    list.add((QBQuad)collection.iterator().next());
                    continue;
                }
                int n2 = n & 7;
                Rectangle4i rectangle4i = null;
                for (Object object2 : collection) {
                    if (rectangle4i == null) {
                        rectangle4i = ((QBQuad)object2).flatten();
                        continue;
                    }
                    rectangle4i.include(((QBQuad)object2).flatten());
                }
                QBImage qBImage = new QBImage();
                qBImage.data = new int[rectangle4i.w][rectangle4i.h];
                object2 = collection.iterator();
                while (object2.hasNext()) {
                    QBQuad qBQuad = (QBQuad)object2.next();
                    QBImage qBImage2 = qBQuad.image;
                    Rectangle4i rectangle4i2 = qBQuad.flatten();
                    int n3 = rectangle4i2.x - rectangle4i.x;
                    int n4 = rectangle4i2.y - rectangle4i.y;
                    for (int i = 0; i < qBImage2.width(); ++i) {
                        for (int j = 0; j < qBImage2.height(); ++j) {
                            qBImage.data[n3 + i][n4 + j] = qBImage2.data[i][j];
                        }
                    }
                }
                list.add(QBQuad.restore(rectangle4i, n2, n >> 3, qBImage));
            }
        }

        public CCModel buildModel(List<QBQuad> list, BufferedImage bufferedImage, boolean bl) {
            CCModel cCModel = CCModel.quadModel(list.size() * 4);
            int n = 0;
            for (QBQuad qBQuad : list) {
                qBQuad.applyImageT();
                cCModel.verts[n++] = qBQuad.verts[0];
                cCModel.verts[n++] = qBQuad.verts[1];
                cCModel.verts[n++] = qBQuad.verts[2];
                cCModel.verts[n++] = qBQuad.verts[3];
            }
            cCModel.apply(new UVScale(1.0 / (double)bufferedImage.getWidth(), 1.0 / (double)bufferedImage.getHeight()));
            cCModel.apply(new Translation(this.pos.x, this.pos.y, this.pos.z));
            if (bl) {
                cCModel.apply(new Scale(0.0625));
            }
            cCModel.computeNormals();
            return cCModel;
        }

        private static void addImages(List<QBQuad> list, List<QBImage> list2) {
            for (QBQuad qBQuad : list) {
                QBImage qBImage = qBQuad.image;
                boolean bl = false;
                for (QBImage qBImage2 : list2) {
                    ImageTransform imageTransform = qBImage.transformTo(qBImage2);
                    if (imageTransform == null) continue;
                    qBQuad.t = imageTransform;
                    qBQuad.image = qBImage2;
                    bl = true;
                    break;
                }
                if (bl) continue;
                list2.add(qBImage);
            }
        }
    }

    public static class QBCuboid {
        public QBMatrix mat;
        public CuboidCoord c;
        public int sides;

        public QBCuboid(QBMatrix qBMatrix, CuboidCoord cuboidCoord) {
            this.mat = qBMatrix;
            this.c = cuboidCoord;
            this.sides = 0;
        }

        public static boolean intersects(QBCuboid qBCuboid, QBCuboid qBCuboid2) {
            CuboidCoord cuboidCoord = qBCuboid.c;
            CuboidCoord cuboidCoord2 = qBCuboid2.c;
            return cuboidCoord.min.x <= cuboidCoord2.max.x && cuboidCoord2.min.x <= cuboidCoord.max.x && cuboidCoord.min.y <= cuboidCoord2.max.y && cuboidCoord2.min.y <= cuboidCoord.max.y && cuboidCoord.min.z <= cuboidCoord2.max.z && cuboidCoord2.min.z <= cuboidCoord.max.z;
        }

        public static void clip(QBCuboid qBCuboid, QBCuboid qBCuboid2) {
            if (QBCuboid.intersects(qBCuboid, qBCuboid2)) {
                qBCuboid.clip(qBCuboid2);
                qBCuboid2.clip(qBCuboid);
            }
        }

        public void clip(QBCuboid qBCuboid) {
            CuboidCoord cuboidCoord = qBCuboid.c;
            for (int i = 0; i < 6; i += 2) {
                int n = (i + 2) % 6;
                int n2 = (i + 4) % 6;
                if (this.c.getSide(n + 1) > cuboidCoord.getSide(n + 1) || this.c.getSide(n) < cuboidCoord.getSide(n) || this.c.getSide(n2 + 1) > cuboidCoord.getSide(n2 + 1) || this.c.getSide(n2) < cuboidCoord.getSide(n2)) continue;
                if (this.c.getSide(i) <= cuboidCoord.getSide(i + 1) && this.c.getSide(i) >= cuboidCoord.getSide(i)) {
                    this.c.setSide(i, cuboidCoord.getSide(i + 1) + 1);
                    this.sides |= 1 << i;
                }
                if (this.c.getSide(i + 1) < cuboidCoord.getSide(i) || this.c.getSide(i + 1) > cuboidCoord.getSide(i + 1)) continue;
                this.c.setSide(i + 1, cuboidCoord.getSide(i) - 1);
                this.sides |= 2 << i;
            }
        }

        public void extractQuads(List<QBQuad> list) {
            Cuboid6 cuboid6 = this.c.bounds();
            for (int i = 0; i < 6; ++i) {
                if ((this.sides & 1 << i) != 0) continue;
                list.add(this.extractQuad(i, cuboid6));
            }
        }

        private QBQuad extractQuad(int n, Cuboid6 cuboid6) {
            int n2;
            int n3;
            double[] dArray = new double[3];
            dArray[n >> 1] = cuboid6.getSide(n);
            QBQuad qBQuad = new QBQuad(n);
            for (n3 = 0; n3 < 4; ++n3) {
                n2 = vertOrder[n3][0];
                int n4 = vertOrder[n3][1];
                int n5 = Rotation.rotateSide(n, n2);
                int n6 = Rotation.rotateSide(n, n4);
                dArray[n5 >> 1] = cuboid6.getSide(n5);
                dArray[n6 >> 1] = cuboid6.getSide(n6);
                qBQuad.verts[n3] = new Vertex5(Vector3.fromAxes(dArray), (3 - n2) / 2, n4 / 2);
            }
            n3 = Rotation.rotateSide(n, 1);
            n2 = Rotation.rotateSide(n, 2);
            qBQuad.image.data = new int[this.c.size(n3)][this.c.size(n2)];
            QBImage qBImage = qBQuad.image;
            int[] nArray = new int[3];
            nArray[n >> 1] = this.c.getSide(n);
            nArray[n3 >> 1] = this.c.getSide(n3 ^ 1);
            nArray[n2 >> 1] = this.c.getSide(n2 ^ 1);
            BlockCoord blockCoord = BlockCoord.fromAxes(nArray);
            BlockCoord blockCoord2 = BlockCoord.sideOffsets[n3];
            BlockCoord blockCoord3 = BlockCoord.sideOffsets[n2];
            for (int i = 0; i < qBImage.width(); ++i) {
                for (int j = 0; j < qBImage.height(); ++j) {
                    qBImage.data[i][j] = this.mat.matrix[blockCoord.x + blockCoord2.x * i + blockCoord3.x * j][blockCoord.y + blockCoord2.y * i + blockCoord3.y * j][blockCoord.z + blockCoord2.z * i + blockCoord3.z * j];
                }
            }
            return qBQuad;
        }
    }

    public static class QBQuad {
        public Vertex5[] verts = new Vertex5[4];
        public QBImage image = new QBImage();
        public ImageTransform t = new ImageTransform();
        public int side;

        public QBQuad(int n) {
            this.side = n;
        }

        public void applyImageT() {
            for (Vertex5 vertex5 : this.verts) {
                this.t.transform(vertex5.uv);
                this.image.transform(vertex5.uv);
            }
        }

        public static QBQuad restore(Rectangle4i rectangle4i, int n, double d, QBImage qBImage) {
            QBQuad qBQuad = new QBQuad(n);
            qBQuad.image = qBImage;
            TransformationList transformationList = new Scale(-1.0, 1.0, -1.0).with(Rotation.sideOrientation(n, 0)).with(new Translation(new Vector3().setSide(n, d)));
            qBQuad.verts[0] = new Vertex5(rectangle4i.x, 0.0, rectangle4i.y, 0.0, 0.0);
            qBQuad.verts[1] = new Vertex5(rectangle4i.x + rectangle4i.w, 0.0, rectangle4i.y, 1.0, 0.0);
            qBQuad.verts[2] = new Vertex5(rectangle4i.x + rectangle4i.w, 0.0, rectangle4i.y + rectangle4i.h, 1.0, 1.0);
            qBQuad.verts[3] = new Vertex5(rectangle4i.x, 0.0, rectangle4i.y + rectangle4i.h, 0.0, 1.0);
            for (Vertex5 vertex5 : qBQuad.verts) {
                vertex5.apply(transformationList);
            }
            return qBQuad;
        }

        public Rectangle4i flatten() {
            TransformationList transformationList = ((Transformation)Rotation.sideOrientation(this.side, 0).inverse()).with(new Scale(-1.0, 0.0, -1.0));
            Vector3 vector3 = this.verts[0].vec.copy().apply(transformationList);
            Vector3 vector32 = this.verts[2].vec.copy().apply(transformationList);
            return new Rectangle4i((int)vector3.x, (int)vector3.z, (int)(vector32.x - vector3.x), (int)(vector32.z - vector3.z));
        }
    }

    public static class QBImage
    implements Comparable<QBImage> {
        int[][] data;
        ImageTransform packT;
        Rectangle4i packSlot;

        public int width() {
            return this.data.length;
        }

        public int height() {
            return this.data[0].length;
        }

        public int area() {
            return this.width() * this.height();
        }

        @Override
        public int compareTo(QBImage qBImage) {
            int n;
            int n2 = this.area();
            return n2 > (n = qBImage.area()) ? -1 : (n2 == n ? 0 : 1);
        }

        public ImageTransform transformTo(QBImage qBImage) {
            ImageTransform imageTransform;
            int n;
            if (this.width() == qBImage.width() && this.height() == qBImage.height()) {
                for (n = 0; n < 4; ++n) {
                    imageTransform = new ImageTransform(n);
                    if (!this.equals(qBImage, imageTransform)) continue;
                    return imageTransform;
                }
            }
            if (this.width() == qBImage.height() && this.height() == qBImage.width()) {
                for (n = 4; n < 8; ++n) {
                    imageTransform = new ImageTransform(n);
                    if (!this.equals(qBImage, imageTransform)) continue;
                    return imageTransform;
                }
            }
            return null;
        }

        public boolean equals(QBImage qBImage, ImageTransform imageTransform) {
            for (int i = 0; i < qBImage.width(); ++i) {
                for (int j = 0; j < qBImage.height(); ++j) {
                    if (imageTransform.access(this, i, j) == qBImage.data[i][j]) continue;
                    return false;
                }
            }
            return true;
        }

        public void transform(UV uV) {
            this.packT.transform(uV);
            uV.u *= (double)this.packSlot.w;
            uV.v *= (double)this.packSlot.h;
            uV.u += (double)this.packSlot.x;
            uV.v += (double)this.packSlot.y;
        }
    }

    private static class ImageTransform {
        int transform;

        public ImageTransform(int n) {
            this.transform = n;
        }

        public ImageTransform() {
            this(0);
        }

        public boolean transpose() {
            return (this.transform & 4) != 0;
        }

        public boolean flipU() {
            return (this.transform & 1) != 0;
        }

        public boolean flipV() {
            return (this.transform & 2) != 0;
        }

        public int access(QBImage qBImage, int n, int n2) {
            if (this.transpose()) {
                int n3 = n;
                n = n2;
                n2 = n3;
            }
            if (this.flipU()) {
                n = qBImage.width() - 1 - n;
            }
            if (this.flipV()) {
                n2 = qBImage.height() - 1 - n2;
            }
            return qBImage.data[n][n2];
        }

        public UV transform(UV uV) {
            if (this.transpose()) {
                double d = uV.u;
                uV.u = uV.v;
                uV.v = d;
            }
            if (this.flipU()) {
                uV.u = 1.0 - uV.u;
            }
            if (this.flipV()) {
                uV.v = 1.0 - uV.v;
            }
            return uV;
        }
    }

    private static class ImagePackNode {
        Rectangle4i rect;
        ImagePackNode child1;
        ImagePackNode child2;
        QBImage packed;

        public ImagePackNode(int n, int n2, int n3, int n4) {
            this.rect = new Rectangle4i(n, n2, n3, n4);
        }

        public boolean pack(QBImage qBImage) {
            int n;
            if (this.child1 != null) {
                return this.child1.pack(qBImage) || this.child2.pack(qBImage);
            }
            if (this.packed != null) {
                return false;
            }
            int n2 = this.getFit(qBImage.width(), qBImage.height());
            if (n2 == 0) {
                return false;
            }
            if ((n2 & 2) != 0) {
                this.packed = qBImage;
                qBImage.packSlot = this.rect;
                qBImage.packT = new ImageTransform((n2 & 1) << 2);
                return true;
            }
            int n3 = (n2 & 1) == 0 ? qBImage.width() : qBImage.height();
            int n4 = n = (n2 & 1) == 0 ? qBImage.height() : qBImage.width();
            if (this.rect.w - n3 > this.rect.h - n) {
                this.child1 = new ImagePackNode(this.rect.x, this.rect.y, n3, this.rect.h);
                this.child2 = new ImagePackNode(this.rect.x + n3, this.rect.y, this.rect.w - n3, this.rect.h);
            } else {
                this.child1 = new ImagePackNode(this.rect.x, this.rect.y, this.rect.w, n);
                this.child2 = new ImagePackNode(this.rect.x, this.rect.y + n, this.rect.w, this.rect.h - n);
            }
            return this.child1.pack(qBImage);
        }

        private int getFit(int n, int n2) {
            if (n == this.rect.w && n2 == this.rect.h) {
                return 2;
            }
            if (n == this.rect.h && n2 == this.rect.w) {
                return 3;
            }
            if (this.rect.w >= n && this.rect.h >= n2) {
                return 4;
            }
            if (this.rect.w >= n2 && this.rect.h >= n) {
                return 5;
            }
            return 0;
        }

        private static void nextSize(Rectangle4i rectangle4i, boolean bl) {
            if (bl) {
                rectangle4i.w <<= 1;
                rectangle4i.h <<= 1;
            } else if (rectangle4i.w == rectangle4i.h) {
                rectangle4i.w *= 2;
            } else {
                rectangle4i.h *= 2;
            }
        }

        public static ImagePackNode pack(List<QBImage> list, boolean bl) {
            Collections.sort(list);
            int n = 0;
            for (QBImage qBImage : list) {
                n += qBImage.area();
            }
            ImagePackNode imagePackNode = new ImagePackNode(0, 0, 2, 2);
            while (imagePackNode.rect.area() < n) {
                ImagePackNode.nextSize(imagePackNode.rect, bl);
            }
            while (true) {
                boolean bl2 = true;
                for (QBImage qBImage : list) {
                    if (imagePackNode.pack(qBImage)) continue;
                    bl2 = false;
                    break;
                }
                if (bl2) {
                    return imagePackNode;
                }
                imagePackNode.child2 = null;
                imagePackNode.child1 = null;
                ImagePackNode.nextSize(imagePackNode.rect, bl);
            }
        }

        public BufferedImage toImage() {
            BufferedImage bufferedImage = new BufferedImage(this.rect.w, this.rect.h, 2);
            this.write(bufferedImage);
            return bufferedImage;
        }

        private void write(BufferedImage bufferedImage) {
            if (this.child1 != null) {
                this.child1.write(bufferedImage);
                this.child2.write(bufferedImage);
            } else if (this.packed != null) {
                ImageTransform imageTransform = this.packed.packT;
                for (int i = 0; i < this.rect.w; ++i) {
                    for (int j = 0; j < this.rect.h; ++j) {
                        int n = imageTransform.access(this.packed, i, j);
                        bufferedImage.setRGB(i + this.rect.x, j + this.rect.y, n >>> 8 | n << 24);
                    }
                }
            }
        }
    }
}

