/*
 * Decompiled with CFR 0.152.
 */
package cofh.repack.codechicken.lib.asm;

import cofh.repack.codechicken.lib.asm.InsnListSection;
import com.google.common.base.Function;
import com.google.common.collect.Maps;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class InsnComparator {
    public static boolean varInsnEqual(VarInsnNode varInsnNode, VarInsnNode varInsnNode2) {
        return varInsnNode.var == -1 || varInsnNode2.var == -1 || varInsnNode.var == varInsnNode2.var;
    }

    public static boolean methodInsnEqual(MethodInsnNode methodInsnNode, MethodInsnNode methodInsnNode2) {
        return methodInsnNode.owner.equals(methodInsnNode2.owner) && methodInsnNode.name.equals(methodInsnNode2.name) && methodInsnNode.desc.equals(methodInsnNode2.desc);
    }

    public static boolean fieldInsnEqual(FieldInsnNode fieldInsnNode, FieldInsnNode fieldInsnNode2) {
        return fieldInsnNode.owner.equals(fieldInsnNode2.owner) && fieldInsnNode.name.equals(fieldInsnNode2.name) && fieldInsnNode.desc.equals(fieldInsnNode2.desc);
    }

    public static boolean ldcInsnEqual(LdcInsnNode ldcInsnNode, LdcInsnNode ldcInsnNode2) {
        return ldcInsnNode.cst == null || ldcInsnNode2.cst == null || ldcInsnNode.cst.equals(ldcInsnNode2.cst);
    }

    public static boolean typeInsnEqual(TypeInsnNode typeInsnNode, TypeInsnNode typeInsnNode2) {
        return typeInsnNode.desc.equals("*") || typeInsnNode2.desc.equals("*") || typeInsnNode.desc.equals(typeInsnNode2.desc);
    }

    public static boolean iincInsnEqual(IincInsnNode iincInsnNode, IincInsnNode iincInsnNode2) {
        return iincInsnNode.var == iincInsnNode2.var && iincInsnNode.incr == iincInsnNode2.incr;
    }

    public static boolean intInsnEqual(IntInsnNode intInsnNode, IntInsnNode intInsnNode2) {
        return intInsnNode.operand == -1 || intInsnNode2.operand == -1 || intInsnNode.operand == intInsnNode2.operand;
    }

    public static boolean insnEqual(AbstractInsnNode abstractInsnNode, AbstractInsnNode abstractInsnNode2) {
        if (abstractInsnNode.getOpcode() != abstractInsnNode2.getOpcode()) {
            return false;
        }
        switch (abstractInsnNode2.getType()) {
            case 2: {
                return InsnComparator.varInsnEqual((VarInsnNode)abstractInsnNode, (VarInsnNode)abstractInsnNode2);
            }
            case 3: {
                return InsnComparator.typeInsnEqual((TypeInsnNode)abstractInsnNode, (TypeInsnNode)abstractInsnNode2);
            }
            case 4: {
                return InsnComparator.fieldInsnEqual((FieldInsnNode)abstractInsnNode, (FieldInsnNode)abstractInsnNode2);
            }
            case 5: {
                return InsnComparator.methodInsnEqual((MethodInsnNode)abstractInsnNode, (MethodInsnNode)abstractInsnNode2);
            }
            case 9: {
                return InsnComparator.ldcInsnEqual((LdcInsnNode)abstractInsnNode, (LdcInsnNode)abstractInsnNode2);
            }
            case 10: {
                return InsnComparator.iincInsnEqual((IincInsnNode)abstractInsnNode, (IincInsnNode)abstractInsnNode2);
            }
            case 1: {
                return InsnComparator.intInsnEqual((IntInsnNode)abstractInsnNode, (IntInsnNode)abstractInsnNode2);
            }
        }
        return true;
    }

    public static boolean insnImportant(AbstractInsnNode abstractInsnNode, Set<LabelNode> set) {
        switch (abstractInsnNode.getType()) {
            case 14: 
            case 15: {
                return false;
            }
            case 8: {
                return set.contains(abstractInsnNode);
            }
        }
        return true;
    }

    public static Set<LabelNode> getControlFlowLabels(InsnListSection insnListSection) {
        return InsnComparator.getControlFlowLabels(insnListSection.list);
    }

    public static Set<LabelNode> getControlFlowLabels(InsnList insnList) {
        HashSet<LabelNode> hashSet = new HashSet<LabelNode>();
        block5: for (AbstractInsnNode abstractInsnNode = insnList.getFirst(); abstractInsnNode != null; abstractInsnNode = abstractInsnNode.getNext()) {
            switch (abstractInsnNode.getType()) {
                case 7: {
                    JumpInsnNode jumpInsnNode = (JumpInsnNode)abstractInsnNode;
                    hashSet.add(jumpInsnNode.label);
                    continue block5;
                }
                case 11: {
                    TableSwitchInsnNode tableSwitchInsnNode = (TableSwitchInsnNode)abstractInsnNode;
                    hashSet.add(tableSwitchInsnNode.dflt);
                    for (LabelNode labelNode : tableSwitchInsnNode.labels) {
                        hashSet.add(labelNode);
                    }
                    continue block5;
                }
                case 12: {
                    LabelNode labelNode;
                    LookupSwitchInsnNode lookupSwitchInsnNode = (LookupSwitchInsnNode)abstractInsnNode;
                    hashSet.add(lookupSwitchInsnNode.dflt);
                    labelNode = lookupSwitchInsnNode.labels.iterator();
                    while (labelNode.hasNext()) {
                        LabelNode labelNode2 = (LabelNode)labelNode.next();
                        hashSet.add(labelNode2);
                    }
                    continue block5;
                }
            }
        }
        return hashSet;
    }

    public static InsnList getImportantList(InsnList insnList) {
        return InsnComparator.getImportantList((InsnListSection)new InsnListSection((InsnList)insnList)).list;
    }

    public static InsnListSection getImportantList(InsnListSection insnListSection) {
        if (insnListSection.size() == 0) {
            return insnListSection;
        }
        Set<LabelNode> set = InsnComparator.getControlFlowLabels(insnListSection);
        Map map = Maps.asMap(set, (Function)new Function<LabelNode, LabelNode>(){

            public LabelNode apply(LabelNode labelNode) {
                return labelNode;
            }
        });
        InsnListSection insnListSection2 = new InsnListSection();
        for (AbstractInsnNode abstractInsnNode : insnListSection) {
            if (!InsnComparator.insnImportant(abstractInsnNode, set)) continue;
            insnListSection2.add(abstractInsnNode.clone(map));
        }
        return insnListSection2;
    }

    public static List<InsnListSection> find(InsnListSection insnListSection, InsnListSection insnListSection2) {
        Set<LabelNode> set = InsnComparator.getControlFlowLabels(insnListSection);
        LinkedList<InsnListSection> linkedList = new LinkedList<InsnListSection>();
        for (int i = 0; i <= insnListSection.size() - insnListSection2.size(); ++i) {
            InsnListSection insnListSection3 = InsnComparator.matches(insnListSection.drop(i), insnListSection2, set);
            if (insnListSection3 == null) continue;
            linkedList.add(insnListSection3);
            i = insnListSection3.end - 1;
        }
        return linkedList;
    }

    public static List<InsnListSection> find(InsnList insnList, InsnListSection insnListSection) {
        return InsnComparator.find(new InsnListSection(insnList), insnListSection);
    }

    public static InsnListSection matches(InsnListSection insnListSection, InsnListSection insnListSection2, Set<LabelNode> set) {
        int n;
        int n2 = 0;
        for (n = 0; n < insnListSection.size() && n2 < insnListSection2.size(); ++n) {
            AbstractInsnNode abstractInsnNode = insnListSection.get(n);
            if (!InsnComparator.insnImportant(abstractInsnNode, set)) continue;
            if (!InsnComparator.insnEqual(insnListSection.get(n), insnListSection2.get(n2))) {
                return null;
            }
            ++n2;
        }
        if (n2 != insnListSection2.size()) {
            return null;
        }
        return insnListSection.take(n);
    }

    public static InsnListSection findOnce(InsnListSection insnListSection, InsnListSection insnListSection2) {
        List<InsnListSection> list = InsnComparator.find(insnListSection, insnListSection2);
        if (list.size() != 1) {
            throw new RuntimeException("Needle found " + list.size() + " times in Haystack:\n" + insnListSection + "\n\n" + insnListSection2);
        }
        return list.get(0);
    }

    public static InsnListSection findOnce(InsnList insnList, InsnListSection insnListSection) {
        return InsnComparator.findOnce(new InsnListSection(insnList), insnListSection);
    }

    public static List<InsnListSection> findN(InsnListSection insnListSection, InsnListSection insnListSection2) {
        List<InsnListSection> list = InsnComparator.find(insnListSection, insnListSection2);
        if (list.isEmpty()) {
            throw new RuntimeException("Needle not found in Haystack:\n" + insnListSection + "\n\n" + insnListSection2);
        }
        return list;
    }

    public static List<InsnListSection> findN(InsnList insnList, InsnListSection insnListSection) {
        return InsnComparator.findN(new InsnListSection(insnList), insnListSection);
    }
}

