/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.render.bit;

import java.util.HashMap;
import java.util.Objects;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.client.model.baked.BaseSmartModel;
import mod.chiselsandbits.core.ClientSide;
import mod.chiselsandbits.events.TickHandler;
import mod.chiselsandbits.interfaces.ICacheClearable;
import mod.chiselsandbits.items.ItemChiseledBit;
import mod.chiselsandbits.registry.ModItems;
import mod.chiselsandbits.render.ModelCombined;
import mod.chiselsandbits.render.bit.BitItemBaked;
import mod.chiselsandbits.render.chiseledblock.ChiselRenderType;
import mod.chiselsandbits.render.chiseledblock.ChiseledBlockBakedModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;

public class BitItemSmartModel
extends BaseSmartModel
implements ICacheClearable {
    private static final HashMap<Integer, IBakedModel> modelCache = new HashMap();
    private static final HashMap<Integer, IBakedModel> largeModelCache = new HashMap();
    private static final NonNullList<ItemStack> alternativeStacks = NonNullList.func_191196_a();

    private IBakedModel getCachedModel(int stateID, boolean large) {
        HashMap<Integer, IBakedModel> target;
        IBakedModel out;
        if (stateID == 0) {
            if (alternativeStacks.isEmpty()) {
                ((ItemChiseledBit)ModItems.ITEM_BLOCK_BIT.get()).func_150895_a(Objects.requireNonNull(((ItemChiseledBit)ModItems.ITEM_BLOCK_BIT.get()).func_77640_w()), alternativeStacks);
            }
            int alternativeIndex = (int)(Math.floor((double)TickHandler.getClientTicks() / 20.0) % (double)alternativeStacks.size());
            stateID = ItemChiseledBit.getStackState((ItemStack)alternativeStacks.get(alternativeIndex));
        }
        if ((out = (target = large ? largeModelCache : modelCache).get(stateID)) == null) {
            if (large) {
                VoxelBlob blob = new VoxelBlob();
                blob.fill(stateID);
                ChiseledBlockBakedModel a = new ChiseledBlockBakedModel(stateID, ChiselRenderType.SOLID, blob, DefaultVertexFormats.field_176600_a);
                ChiseledBlockBakedModel b = new ChiseledBlockBakedModel(stateID, ChiselRenderType.SOLID_FLUID, blob, DefaultVertexFormats.field_176600_a);
                ChiseledBlockBakedModel c = new ChiseledBlockBakedModel(stateID, ChiselRenderType.CUTOUT_MIPPED, blob, DefaultVertexFormats.field_176600_a);
                ChiseledBlockBakedModel d = new ChiseledBlockBakedModel(stateID, ChiselRenderType.CUTOUT, blob, DefaultVertexFormats.field_176600_a);
                ChiseledBlockBakedModel e = new ChiseledBlockBakedModel(stateID, ChiselRenderType.TRANSLUCENT, blob, DefaultVertexFormats.field_176600_a);
                out = new ModelCombined(a, b, c, d, e);
            } else {
                out = new BitItemBaked(stateID);
            }
            target.put(stateID, out);
        }
        return out;
    }

    @Override
    public IBakedModel func_239290_a_(IBakedModel originalModel, ItemStack stack, World world, LivingEntity entity) {
        return this.getCachedModel(ItemChiseledBit.getStackState(stack), ClientSide.instance.holdingShift());
    }

    @Override
    public void clearCache() {
        modelCache.clear();
        largeModelCache.clear();
    }

    public boolean func_230044_c_() {
        return true;
    }
}

