/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.printer;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.helpers.LocalStrings;
import mod.chiselsandbits.printer.ChiselPrinterTileEntity;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

public class ChiselPrinterBlock
extends ContainerBlock {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    private static final Map<Direction, VoxelShape> BUTTON_VS_MAP = ImmutableMap.builder().put((Object)Direction.NORTH, (Object)Block.func_208617_a((double)7.0, (double)1.0, (double)-0.5, (double)12.0, (double)4.0, (double)0.0)).put((Object)Direction.EAST, (Object)Block.func_208617_a((double)16.0, (double)1.0, (double)7.0, (double)16.5, (double)4.0, (double)12.0)).put((Object)Direction.SOUTH, (Object)Block.func_208617_a((double)4.0, (double)1.0, (double)16.0, (double)9.0, (double)4.0, (double)16.5)).put((Object)Direction.WEST, (Object)Block.func_208617_a((double)-0.5, (double)1.0, (double)4.0, (double)0.0, (double)4.0, (double)9.0)).build();
    private static final VoxelShape VS_NORTH = ChiselPrinterBlock.createForDirection(Direction.NORTH);
    private static final VoxelShape VS_EAST = ChiselPrinterBlock.createForDirection(Direction.EAST);
    private static final VoxelShape VS_SOUTH = ChiselPrinterBlock.createForDirection(Direction.SOUTH);
    private static final VoxelShape VS_WEST = ChiselPrinterBlock.createForDirection(Direction.WEST);
    private static final Map<Direction, VoxelShape> VS_MAP = ImmutableMap.builder().put((Object)Direction.NORTH, (Object)VS_NORTH).put((Object)Direction.EAST, (Object)VS_EAST).put((Object)Direction.SOUTH, (Object)VS_SOUTH).put((Object)Direction.WEST, (Object)VS_WEST).build();

    private static VoxelShape createForDirection(Direction direction) {
        return VoxelShapes.func_197878_a((VoxelShape)VoxelShapes.func_197878_a((VoxelShape)Stream.of(Block.func_208617_a((double)0.0, (double)5.0, (double)0.0, (double)2.0, (double)16.0, (double)2.0), Block.func_208617_a((double)14.0, (double)5.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0), Block.func_208617_a((double)0.0, (double)5.0, (double)14.0, (double)2.0, (double)16.0, (double)16.0), Block.func_208617_a((double)14.0, (double)5.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).orElse(VoxelShapes.func_197880_a()), (VoxelShape)Stream.of(Block.func_208617_a((double)2.0, (double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)2.0), Block.func_208617_a((double)2.0, (double)14.0, (double)14.0, (double)14.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)14.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0), Block.func_208617_a((double)14.0, (double)14.0, (double)2.0, (double)16.0, (double)16.0, (double)14.0), Stream.of(Block.func_208617_a((double)2.0, (double)14.0, (double)7.0, (double)14.0, (double)16.0, (double)9.0), Block.func_208617_a((double)7.0, (double)13.99, (double)2.0, (double)9.0, (double)15.98, (double)14.0), Block.func_208617_a((double)7.0, (double)11.0, (double)7.0, (double)9.0, (double)14.0, (double)9.0), Block.func_208617_a((double)7.5, (double)10.0, (double)7.5, (double)8.5, (double)11.0, (double)8.5)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).orElse(VoxelShapes.func_197880_a())).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).orElse(VoxelShapes.func_197880_a()), (IBooleanFunction)IBooleanFunction.field_223244_o_), (VoxelShape)VoxelShapes.func_197878_a((VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0), (VoxelShape)BUTTON_VS_MAP.getOrDefault(direction, VoxelShapes.func_197880_a()), (IBooleanFunction)IBooleanFunction.field_223244_o_), (IBooleanFunction)IBooleanFunction.field_223244_o_);
    }

    public ChiselPrinterBlock(AbstractBlock.Properties builder) {
        super(builder);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VS_MAP.getOrDefault(state.func_177229_b((Property)FACING), VoxelShapes.func_197880_a());
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new ChiselPrinterTileEntity();
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        player.func_213829_a((INamedContainerProvider)worldIn.func_175625_s(pos));
        return ActionResultType.CONSUME;
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        ChiselsAndBits.getConfig().getCommon().helpText(LocalStrings.ChiselStationHelp, tooltip, new String[0]);
    }
}

