/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.network.packets;

import java.util.ArrayList;
import java.util.List;
import mod.chiselsandbits.api.APIExceptions;
import mod.chiselsandbits.bitbag.BagInventory;
import mod.chiselsandbits.chiseledblock.data.BitIterator;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.chiseledblock.data.VoxelBlobStateReference;
import mod.chiselsandbits.client.UndoTracker;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.core.api.BitAccess;
import mod.chiselsandbits.helpers.ActingPlayer;
import mod.chiselsandbits.helpers.BitInventoryFeeder;
import mod.chiselsandbits.helpers.ContinousChisels;
import mod.chiselsandbits.helpers.IItemInInventory;
import mod.chiselsandbits.helpers.InventoryBackup;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.items.ItemBitBag;
import mod.chiselsandbits.items.ItemChisel;
import mod.chiselsandbits.network.ModPacket;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class PacketUndo
extends ModPacket {
    private BlockPos pos;
    private VoxelBlobStateReference before;
    private VoxelBlobStateReference after;

    public PacketUndo(PacketBuffer buffer) {
        this.readPayload(buffer);
    }

    public PacketUndo(BlockPos pos, VoxelBlobStateReference before, VoxelBlobStateReference after) {
        this.pos = pos;
        this.before = before;
        this.after = after;
    }

    @Override
    public void server(ServerPlayerEntity player) {
        this.preformAction(ActingPlayer.actingAs((PlayerEntity)player, Hand.MAIN_HAND), true);
    }

    @Override
    public void getPayload(PacketBuffer buffer) {
        buffer.func_179255_a(this.pos);
        byte[] bef = this.before.getByteArray();
        buffer.writeInt(bef.length);
        buffer.writeBytes(bef);
        byte[] aft = this.after.getByteArray();
        buffer.writeInt(aft.length);
        buffer.writeBytes(aft);
    }

    @Override
    public void readPayload(PacketBuffer buffer) {
        this.pos = buffer.func_179259_c();
        int lena = buffer.readInt();
        byte[] ta = new byte[lena];
        buffer.readBytes(ta);
        int lenb = buffer.readInt();
        byte[] tb = new byte[lenb];
        buffer.readBytes(tb);
        this.before = new VoxelBlobStateReference(ta, 0L);
        this.after = new VoxelBlobStateReference(tb, 0L);
    }

    public boolean preformAction(ActingPlayer player, boolean spawnItemsAndCommitWorldChanges) {
        if (this.inRange(player, this.pos)) {
            return this.apply(player, spawnItemsAndCommitWorldChanges);
        }
        return false;
    }

    private boolean apply(ActingPlayer player, boolean spawnItemsAndCommitWorldChanges) {
        try {
            Direction side = Direction.UP;
            World world = player.getWorld();
            BitAccess ba = (BitAccess)ChiselsAndBits.getApi().getBitAccess(world, this.pos);
            VoxelBlob bBefore = this.before.getVoxelBlob();
            VoxelBlob bAfter = this.after.getVoxelBlob();
            VoxelBlob target = ba.getNativeBlob();
            if (target.equals(bBefore)) {
                InventoryBackup backup = new InventoryBackup(player.getInventory());
                boolean successful = true;
                ContinousChisels selected = new ContinousChisels(player, this.pos, side);
                ItemStack spawnedItem = null;
                List<BagInventory> bags = ModUtil.getBags(player);
                ArrayList<ItemEntity> spawnlist = new ArrayList<ItemEntity>();
                BitIterator bi = new BitIterator();
                while (bi.hasNext()) {
                    int inAfter;
                    int inBefore = bi.getNext(bBefore);
                    if (inBefore == (inAfter = bi.getNext(bAfter))) continue;
                    if (inAfter == 0) {
                        if (selected.isValid()) {
                            spawnedItem = ItemChisel.chiselBlock(selected, player, target, world, this.pos, side, bi.x, bi.y, bi.z, spawnedItem, spawnlist);
                            continue;
                        }
                        successful = false;
                        break;
                    }
                    if (inAfter == 0) continue;
                    if (inBefore != 0) {
                        if (selected.isValid()) {
                            spawnedItem = ItemChisel.chiselBlock(selected, player, target, world, this.pos, side, bi.x, bi.y, bi.z, spawnedItem, spawnlist);
                        } else {
                            successful = false;
                            break;
                        }
                    }
                    IItemInInventory bit = ModUtil.findBit(player, this.pos, inAfter);
                    if (ModUtil.consumeBagBit(bags, inAfter, 1) == 1) {
                        bi.setNext(target, inAfter);
                        continue;
                    }
                    if (bit.isValid()) {
                        if (!player.isCreative() && !bit.consume()) {
                            successful = false;
                            break;
                        }
                        bi.setNext(target, inAfter);
                        continue;
                    }
                    successful = false;
                    break;
                }
                if (successful) {
                    if (spawnItemsAndCommitWorldChanges) {
                        ba.commitChanges(true);
                        BitInventoryFeeder feeder = new BitInventoryFeeder(player.getPlayer(), player.getWorld());
                        for (ItemEntity ei : spawnlist) {
                            feeder.addItem(ei);
                            ItemBitBag.cleanupInventory(player.getPlayer(), ei.func_92059_d());
                        }
                    }
                    return true;
                }
                backup.rollback();
                UndoTracker.getInstance().addError(player, "mod.chiselsandbits.result.missing_bits");
                return false;
            }
        }
        catch (APIExceptions.CannotBeChiseled cannotBeChiseled) {
            // empty catch block
        }
        UndoTracker.getInstance().addError(player, "mod.chiselsandbits.result.has_changed");
        return false;
    }

    private boolean inRange(ActingPlayer player, BlockPos pos) {
        if (player.isReal()) {
            return true;
        }
        double reach = 6.0;
        if (player.isCreative()) {
            reach = 32.0;
        }
        if (player.getPlayer().func_70092_e((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()) < reach * reach) {
            return true;
        }
        UndoTracker.getInstance().addError(player, "mod.chiselsandbits.result.out_of_range");
        return false;
    }
}

