/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.items;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mod.chiselsandbits.chiseledblock.NBTBlobConverter;
import mod.chiselsandbits.chiseledblock.TileEntityBlockChiseled;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.core.ClientSide;
import mod.chiselsandbits.helpers.LocalStrings;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.interfaces.IPatternItem;
import mod.chiselsandbits.registry.ModBlocks;
import mod.chiselsandbits.registry.ModItems;
import mod.chiselsandbits.render.helpers.SimpleInstanceCache;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemMirrorPrint
extends Item
implements IPatternItem {
    SimpleInstanceCache<ItemStack, List<ITextComponent>> toolTipCache = new SimpleInstanceCache(null, new ArrayList());

    public ItemMirrorPrint(Item.Properties properties) {
        super(properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        super.func_77624_a(stack, worldIn, tooltip, advanced);
        ChiselsAndBits.getConfig().getCommon().helpText(LocalStrings.HelpMirrorPrint, tooltip, ClientSide.instance.getKeyName(Minecraft.func_71410_x().field_71474_y.field_74313_G));
        if (this.isWritten(stack)) {
            if (ClientSide.instance.holdingShift()) {
                if (this.toolTipCache.needsUpdate(stack)) {
                    VoxelBlob blob = ModUtil.getBlobFromStack(stack, null);
                    this.toolTipCache.updateCachedValue(blob.listContents(new ArrayList<ITextComponent>()));
                }
                tooltip.addAll((Collection<ITextComponent>)this.toolTipCache.getCached());
            } else {
                tooltip.add((ITextComponent)new StringTextComponent(LocalStrings.ShiftDetails.getLocal()));
            }
        }
    }

    public String func_77667_c(ItemStack stack) {
        if (this.isWritten(stack)) {
            return super.func_77667_c(stack) + "_written";
        }
        return super.func_77667_c(stack);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        ItemStack stack = context.func_195999_j().func_184586_b(context.func_221531_n());
        if (!context.func_195999_j().func_175151_a(context.func_195995_a(), context.func_196000_l(), stack)) {
            return ActionResultType.SUCCESS;
        }
        if (!this.isWritten(stack)) {
            CompoundNBT comp = this.getCompoundFromBlock(context.func_195991_k(), context.func_195995_a(), context.func_195999_j(), context.func_196000_l());
            if (comp != null) {
                stack.func_190918_g(1);
                ItemStack newStack = new ItemStack((IItemProvider)ModItems.ITEM_MIRROR_PRINT_WRITTEN.get(), 1);
                newStack.func_77982_d(comp);
                ItemEntity entity = context.func_195999_j().func_71019_a(newStack, true);
                entity.func_174867_a(0);
                entity.func_200216_c(context.func_195999_j().func_110124_au());
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.FAIL;
        }
        return ActionResultType.FAIL;
    }

    protected CompoundNBT getCompoundFromBlock(World world, BlockPos pos, PlayerEntity player, Direction face) {
        TileEntityBlockChiseled te = ModUtil.getChiseledTileEntity(world, pos, false);
        if (te != null) {
            CompoundNBT comp = new CompoundNBT();
            te.writeChiselData(comp);
            TileEntityBlockChiseled tmp = new TileEntityBlockChiseled();
            tmp.readChiselData(comp);
            VoxelBlob bestBlob = tmp.getBlob();
            tmp.setBlob(bestBlob.mirror(face.func_176740_k()));
            tmp.writeChiselData(comp);
            comp.func_74774_a("side", (byte)ModUtil.getPlaceFace((LivingEntity)player).ordinal());
            return comp;
        }
        return null;
    }

    @Override
    public ItemStack getPatternedItem(ItemStack stack, boolean wantRealItems) {
        if (!this.isWritten(stack)) {
            return null;
        }
        CompoundNBT tag = ModUtil.getTagCompound(stack);
        NBTBlobConverter conv = new NBTBlobConverter();
        conv.readChisleData(tag, -1);
        BlockState blk = conv.getPrimaryBlockState();
        ItemStack itemstack = new ItemStack((IItemProvider)ModBlocks.convertGivenStateToChiseledBlock(blk), 1);
        itemstack.func_77983_a("BlockEntityTag", (INBT)tag);
        return itemstack;
    }

    @Override
    public boolean isWritten(ItemStack stack) {
        return stack.func_77973_b() == ModItems.ITEM_MIRROR_PRINT_WRITTEN.get() && stack.func_77942_o();
    }
}

