/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.items;

import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import mod.chiselsandbits.api.ReplacementStateHandler;
import mod.chiselsandbits.bitstorage.BlockBitStorage;
import mod.chiselsandbits.chiseledblock.BlockBitInfo;
import mod.chiselsandbits.chiseledblock.BlockChiseled;
import mod.chiselsandbits.chiseledblock.TileEntityBlockChiseled;
import mod.chiselsandbits.chiseledblock.data.BitLocation;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.core.ClientSide;
import mod.chiselsandbits.core.Log;
import mod.chiselsandbits.events.TickHandler;
import mod.chiselsandbits.helpers.ActingPlayer;
import mod.chiselsandbits.helpers.BitOperation;
import mod.chiselsandbits.helpers.ChiselModeManager;
import mod.chiselsandbits.helpers.ChiselToolType;
import mod.chiselsandbits.helpers.DeprecationHelper;
import mod.chiselsandbits.helpers.IContinuousInventory;
import mod.chiselsandbits.helpers.IItemInInventory;
import mod.chiselsandbits.helpers.LocalStrings;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.interfaces.ICacheClearable;
import mod.chiselsandbits.interfaces.IChiselModeItem;
import mod.chiselsandbits.interfaces.IItemScrollWheel;
import mod.chiselsandbits.items.ItemBitBag;
import mod.chiselsandbits.items.ItemChisel;
import mod.chiselsandbits.modes.ChiselMode;
import mod.chiselsandbits.modes.IToolMode;
import mod.chiselsandbits.network.packets.PacketChisel;
import mod.chiselsandbits.registry.ModItems;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class ItemChiseledBit
extends Item
implements IItemScrollWheel,
IChiselModeItem,
ICacheClearable {
    public static boolean bitBagStackLimitHack;
    private ArrayList<ItemStack> bits;
    private static final NonNullList<ItemStack> alternativeStacks;
    private static Stopwatch timer;

    public ItemChiseledBit(Item.Properties properties) {
        super(properties);
        ChiselsAndBits.getInstance().addClearable(this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        super.func_77624_a(stack, worldIn, tooltip, advanced);
        ChiselsAndBits.getConfig().getCommon().helpText(LocalStrings.HelpBit, tooltip, ClientSide.instance.getKeyName(Minecraft.func_71410_x().field_71474_y.field_74312_F), ClientSide.instance.getKeyName(Minecraft.func_71410_x().field_71474_y.field_74313_G), ClientSide.instance.getModeKey());
        int stateId = ItemChiseledBit.getStackState(stack);
        if (stateId == 0) {
            tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.RED.toString() + TextFormatting.ITALIC.toString() + LocalStrings.AnyHelpBit.getLocal() + TextFormatting.RESET.toString()));
        }
    }

    public ITextComponent getHighlightTip(ItemStack item, ITextComponent displayName) {
        return (ITextComponent)DistExecutor.unsafeRunForDist(() -> () -> {
            if (((Boolean)ChiselsAndBits.getConfig().getClient().itemNameModeDisplay.get()).booleanValue() && displayName instanceof IFormattableTextComponent) {
                String extra = "";
                if (ItemChiseledBit.getBitOperation(ClientSide.instance.getPlayer(), Hand.MAIN_HAND, item) == BitOperation.REPLACE) {
                    extra = " - " + LocalStrings.BitOptionReplace.getLocal();
                }
                IFormattableTextComponent comp = (IFormattableTextComponent)displayName;
                return comp.func_240702_b_(" - ").func_230529_a_((ITextComponent)new StringTextComponent(ChiselModeManager.getChiselMode(ClientSide.instance.getPlayer(), ChiselToolType.BIT, Hand.MAIN_HAND).getName().getLocal())).func_230529_a_((ITextComponent)new StringTextComponent(extra));
            }
            return displayName;
        }, () -> () -> displayName);
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, PlayerEntity player) {
        return ItemChisel.fromBreakToChisel(ChiselMode.castMode(ChiselModeManager.getChiselMode(player, ChiselToolType.BIT, Hand.MAIN_HAND)), itemstack, pos, player, Hand.MAIN_HAND);
    }

    public static ITextComponent getBitStateName(BlockState state) {
        ItemStack target = null;
        Block blk = null;
        if (state == null) {
            return new StringTextComponent("Null");
        }
        try {
            blk = state.func_177230_c();
            Item item = Item.func_150898_a((Block)blk);
            if (ModUtil.isEmpty(item)) {
                Fluid f = BlockBitInfo.getFluidFromBlock(blk);
                if (f != null) {
                    return new TranslationTextComponent(f.getAttributes().getTranslationKey());
                }
            } else {
                target = new ItemStack(() -> Item.func_150898_a((Block)state.func_177230_c()), 1);
            }
        }
        catch (IllegalArgumentException e) {
            Log.logError("Unable to get Item Details for Bit.", e);
        }
        if (target == null || target.func_77973_b() == null) {
            return null;
        }
        try {
            ITextComponent myName = target.func_200301_q();
            if (!(myName instanceof IFormattableTextComponent)) {
                return myName;
            }
            IFormattableTextComponent formattableName = (IFormattableTextComponent)myName;
            HashSet<String> extra = new HashSet<String>();
            if (blk != null && state != null) {
                for (Property p : state.func_235904_r_()) {
                    if (!p.func_177701_a().equals("axis") && !p.func_177701_a().equals("facing")) continue;
                    extra.add(DeprecationHelper.translateToLocal("mod.chiselsandbits.pretty." + p.func_177701_a() + "-" + state.func_177229_b(p).toString()));
                }
            }
            if (extra.isEmpty()) {
                return myName;
            }
            for (String x : extra) {
                formattableName.func_240702_b_(" ").func_240702_b_(x);
            }
            return formattableName;
        }
        catch (Exception e) {
            return new StringTextComponent("Error");
        }
    }

    public static ITextComponent getBitTypeName(ItemStack stack) {
        int stateID = ItemChiseledBit.getStackState(stack);
        if (stateID == 0) {
            if (alternativeStacks.isEmpty()) {
                ((ItemChiseledBit)ModItems.ITEM_BLOCK_BIT.get()).func_150895_a(Objects.requireNonNull(((ItemChiseledBit)ModItems.ITEM_BLOCK_BIT.get()).func_77640_w()), alternativeStacks);
            }
            if ((stateID = ItemChiseledBit.getStackState((ItemStack)alternativeStacks.get((int)(TickHandler.getClientTicks() % ((long)alternativeStacks.size() * 20L) / 20L)))) == 0) {
                alternativeStacks.clear();
            }
        }
        return ItemChiseledBit.getBitStateName(ModUtil.getStateById(stateID));
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        ITextComponent typeName = ItemChiseledBit.getBitTypeName(stack);
        if (typeName == null) {
            return super.func_200295_i(stack);
        }
        StringTextComponent strComponent = new StringTextComponent("");
        return strComponent.func_230529_a_(super.func_200295_i(stack)).func_240702_b_(" - ").func_230529_a_(typeName);
    }

    public int getItemStackLimit(ItemStack stack) {
        return bitBagStackLimitHack ? ((Integer)ChiselsAndBits.getConfig().getServer().bagStackSize.get()).intValue() : super.getItemStackLimit(stack);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (!context.func_195991_k().field_72995_K) {
            return ActionResultType.PASS;
        }
        Pair<Vector3d, Vector3d> PlayerRay = ModUtil.getPlayerRay(context.func_195999_j());
        Vector3d ray_from = (Vector3d)PlayerRay.getLeft();
        Vector3d ray_to = (Vector3d)PlayerRay.getRight();
        RayTraceContext rtc = new RayTraceContext(ray_from, ray_to, RayTraceContext.BlockMode.VISUAL, RayTraceContext.FluidMode.NONE, (Entity)context.func_195999_j());
        BlockRayTraceResult mop = context.func_195991_k().func_217299_a(rtc);
        if (mop != null) {
            BlockRayTraceResult rayTraceResult = mop;
            return this.onItemUseInternal(context.func_195999_j(), context.func_195991_k(), context.func_195995_a(), context.func_221531_n(), rayTraceResult);
        }
        return ActionResultType.FAIL;
    }

    public ActionResultType onItemUseInternal(@Nonnull PlayerEntity player, @Nonnull World world, @Nonnull BlockPos usedBlock, @Nonnull Hand hand, @Nonnull BlockRayTraceResult rayTraceResult) {
        ItemStack stack = player.func_184586_b(hand);
        if (!player.func_175151_a(usedBlock, rayTraceResult.func_216354_b(), stack)) {
            return ActionResultType.FAIL;
        }
        BlockState usedState = world.func_180495_p(usedBlock);
        Block blk = usedState.func_177230_c();
        if (blk instanceof BlockBitStorage) {
            if (blk.func_225533_a_(usedState, world, usedBlock, player, hand, rayTraceResult) == ActionResultType.SUCCESS) {
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.FAIL;
        }
        if (world.field_72995_K) {
            IToolMode mode = ChiselModeManager.getChiselMode(player, ClientSide.instance.getHeldToolType(hand), hand);
            BitLocation bitLocation = new BitLocation(rayTraceResult, ItemChiseledBit.getBitOperation(player, hand, stack));
            BlockState blkstate = world.func_180495_p(bitLocation.blockPos);
            TileEntityBlockChiseled tebc = ModUtil.getChiseledTileEntity(world, bitLocation.blockPos, true);
            BlockChiseled.ReplaceWithChiseledValue rv = null;
            if (tebc == null) {
                rv = BlockChiseled.replaceWithChiseled(world, bitLocation.blockPos, blkstate, ItemChiseledBit.getStackState(stack), true);
                if (rv.success) {
                    blkstate = world.func_180495_p(bitLocation.blockPos);
                    tebc = rv.te;
                }
            }
            if (tebc != null) {
                PacketChisel pc = null;
                if (mode == ChiselMode.DRAWN_REGION) {
                    if (world.field_72995_K) {
                        ClientSide.instance.pointAt(ItemChiseledBit.getBitOperation(player, hand, stack).getToolType(), bitLocation, hand);
                    }
                    return ActionResultType.FAIL;
                }
                pc = new PacketChisel(ItemChiseledBit.getBitOperation(player, hand, stack), bitLocation, rayTraceResult.func_216354_b(), ChiselMode.castMode(mode), hand);
                int result = pc.doAction(player);
                if (result > 0) {
                    ClientSide.instance.setLastTool(ChiselToolType.BIT);
                    ChiselsAndBits.getNetworkChannel().sendToServer(pc);
                }
            }
        }
        return ActionResultType.SUCCESS;
    }

    public boolean canHarvestBlock(ItemStack stack, BlockState state) {
        return state.func_177230_c() instanceof BlockChiseled || super.canHarvestBlock(stack, state);
    }

    public boolean func_150897_b(BlockState blk) {
        return blk.func_177230_c() instanceof BlockChiseled || super.func_150897_b(blk);
    }

    public static BitOperation getBitOperation(PlayerEntity player, Hand hand, ItemStack stack) {
        return ReplacementStateHandler.getInstance().isReplacing() ? BitOperation.REPLACE : BitOperation.PLACE;
    }

    @Override
    public void clearCache() {
        this.bits = null;
    }

    public void func_150895_a(ItemGroup tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        if (this.bits == null) {
            this.bits = new ArrayList();
            NonNullList List2 = NonNullList.func_191196_a();
            BitSet used = new BitSet(4096);
            for (Object obj : ForgeRegistries.ITEMS) {
                if (!(obj instanceof BlockItem)) continue;
                try {
                    Item it = (Item)obj;
                    ItemGroup ctab = it.func_77640_w();
                    if (ctab != null) {
                        it.func_150895_a(ctab, List2);
                    }
                    for (ItemStack out : List2) {
                        BlockState state;
                        it = out.func_77973_b();
                        if (!(it instanceof BlockItem) || (state = DeprecationHelper.getStateFromItem(out)) == null || !BlockBitInfo.canChisel(state)) continue;
                        used.set(ModUtil.getStateId(state));
                        this.bits.add(ItemChiseledBit.createStack(ModUtil.getStateId(state), 1, false));
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                List2.clear();
            }
            for (Fluid o : ForgeRegistries.FLUIDS) {
                if (!o.func_207188_f().func_206889_d()) continue;
                this.bits.add(ItemChiseledBit.createStack(Block.func_196246_j((BlockState)o.func_207188_f().func_206883_i()), 1, false));
            }
        }
        items.addAll(this.bits);
    }

    public static boolean sameBit(ItemStack output, int blk) {
        return output.func_77942_o() ? ItemChiseledBit.getStackState(output) == blk : false;
    }

    @Nonnull
    public static ItemStack createStack(int id, int count, boolean RequireStack) {
        ItemStack out = new ItemStack((IItemProvider)ModItems.ITEM_BLOCK_BIT.get(), count);
        out.func_77983_a("id", (INBT)IntNBT.func_229692_a_((int)id));
        return out;
    }

    @Override
    public void scroll(PlayerEntity player, ItemStack stack, int dwheel) {
        IToolMode mode = ChiselModeManager.getChiselMode(player, ChiselToolType.BIT, Hand.MAIN_HAND);
        ChiselModeManager.scrollOption(ChiselToolType.BIT, mode, mode, dwheel);
    }

    public static int getStackState(ItemStack inHand) {
        return inHand != null && inHand.func_77942_o() ? ModUtil.getTagCompound(inHand).func_74762_e("id") : 0;
    }

    public static boolean placeBit(IContinuousInventory bits, ActingPlayer player, VoxelBlob vb, int x, int y, int z) {
        if (vb.get(x, y, z) == 0) {
            IItemInInventory slot = bits.getItem(0);
            int stateID = ItemChiseledBit.getStackState(slot.getStack());
            if (slot.isValid()) {
                if (!player.isCreative()) {
                    if (bits.useItem(stateID)) {
                        vb.set(x, y, z, stateID);
                    }
                } else {
                    vb.set(x, y, z, stateID);
                }
            }
            return true;
        }
        return false;
    }

    public static boolean hasBitSpace(PlayerEntity player, int blk) {
        List<ItemBitBag.BagPos> bags = ItemBitBag.getBags((IInventory)player.field_71071_by);
        for (ItemBitBag.BagPos bp : bags) {
            for (int x = 0; x < bp.inv.func_70302_i_(); ++x) {
                ItemStack is = bp.inv.func_70301_a(x);
                if ((!ItemChiseledBit.sameBit(is, blk) || ModUtil.getStackSize(is) >= bp.inv.func_70297_j_()) && !ModUtil.isEmpty(is)) continue;
                return true;
            }
        }
        for (int x = 0; x < 36; ++x) {
            ItemStack is = player.field_71071_by.func_70301_a(x);
            if ((!ItemChiseledBit.sameBit(is, blk) || ModUtil.getStackSize(is) >= is.func_77976_d()) && !ModUtil.isEmpty(is)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkRequiredSpace(PlayerEntity player, BlockState blkstate) {
        int stateId;
        if (((Boolean)ChiselsAndBits.getConfig().getServer().requireBagSpace.get()).booleanValue() && !player.func_184812_l_() && !ItemChiseledBit.hasBitSpace(player, stateId = ModUtil.getStateId(blkstate))) {
            if (player.func_130014_f_().field_72995_K && (timer == null || timer.elapsed(TimeUnit.MILLISECONDS) > 1000L)) {
                timer = Stopwatch.createStarted();
                player.func_145747_a((ITextComponent)new TranslationTextComponent("mod.chiselsandbits.result.require_bag"), Util.field_240973_b_);
            }
            return true;
        }
        return false;
    }

    static {
        alternativeStacks = NonNullList.func_191196_a();
    }
}

