/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.helpers;

import java.util.ArrayList;
import java.util.List;
import mod.chiselsandbits.bitbag.BagInventory;
import mod.chiselsandbits.helpers.ActingPlayer;
import mod.chiselsandbits.helpers.IContinuousInventory;
import mod.chiselsandbits.helpers.IItemHandlerSlot;
import mod.chiselsandbits.helpers.IItemInInventory;
import mod.chiselsandbits.helpers.ItemStackSlot;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.items.ItemBitBag;
import mod.chiselsandbits.items.ItemChiseledBit;
import mod.chiselsandbits.registry.ModItems;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ContinousBits
implements IContinuousInventory {
    final int stateID;
    private final List<IItemInInventory> options = new ArrayList<IItemInInventory>();
    private final List<BagInventory> bags = new ArrayList<BagInventory>();

    public ContinousBits(ActingPlayer src, BlockPos pos, int stateID) {
        this.stateID = stateID;
        IInventory inv = src.getInventory();
        boolean canEdit = src.canPlayerManipulate(pos, Direction.UP, new ItemStack((IItemProvider)ModItems.ITEM_CHISEL_DIAMOND.get(), 1), true);
        ItemStackSlot handSlot = null;
        for (int zz = 0; zz < inv.func_70302_i_(); ++zz) {
            ItemStack which = inv.func_70301_a(zz);
            if (which == null || which.func_77973_b() == null) continue;
            Item i = which.func_77973_b();
            if (i instanceof ItemChiseledBit) {
                if (ItemChiseledBit.getStackState(which) != stateID) continue;
                if (zz == src.getCurrentItem()) {
                    handSlot = new ItemStackSlot(inv, zz, which, src, canEdit);
                    continue;
                }
                this.options.add(new ItemStackSlot(inv, zz, which, src, canEdit));
                continue;
            }
            if (i instanceof ItemBitBag) {
                this.bags.add(new BagInventory(which));
                continue;
            }
            LazyOptional handler = which.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
            if (!handler.isPresent()) continue;
            IItemHandler internal = (IItemHandler)handler.orElseThrow(() -> new IllegalStateException("Handler is supposed to be present!"));
            for (int x = 0; x < internal.getSlots(); ++x) {
                ItemStack is = internal.getStackInSlot(x);
                if (!(is.func_77973_b() instanceof ItemChiseledBit) || ItemChiseledBit.getStackState(is) != stateID) continue;
                this.options.add(new IItemHandlerSlot(internal, x, is, src, canEdit));
            }
        }
        if (handSlot != null) {
            this.options.add(handSlot);
        }
    }

    @Override
    public IItemInInventory getItem(int BlockID) {
        return this.options.get(0);
    }

    @Override
    public boolean useItem(int blk) {
        IItemInInventory slot = this.options.get(0);
        if (slot instanceof ItemStackSlot && ModUtil.getStackSize(slot.getStack()) <= 1) {
            for (BagInventory bag : this.bags) {
                ((ItemStackSlot)slot).replaceStack(bag.restockItem(slot.getStack(), slot.getStackType()));
            }
        }
        boolean worked = slot.consume();
        if (slot.isValid()) {
            if (slot instanceof ItemStackSlot) {
                for (BagInventory bag : this.bags) {
                    ((ItemStackSlot)slot).replaceStack(bag.restockItem(slot.getStack(), slot.getStackType()));
                }
            }
        } else {
            this.options.remove(0);
        }
        return worked;
    }

    @Override
    public void fail(int BlockID) {
    }

    @Override
    public boolean isValid() {
        return !this.options.isEmpty();
    }
}

