/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.crafting;

import mod.chiselsandbits.chiseledblock.NBTBlobConverter;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.items.ItemNegativePrint;
import mod.chiselsandbits.registry.ModItems;
import mod.chiselsandbits.registry.ModRecipeSerializers;
import net.minecraft.block.Blocks;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class NegativeInversionCrafting
extends SpecialRecipe {
    public NegativeInversionCrafting(ResourceLocation name) {
        super(name);
    }

    public boolean matches(CraftingInventory craftingInv, World worldIn) {
        return this.analzyeCraftingInventory(craftingInv, true) != null;
    }

    public ItemStack analzyeCraftingInventory(CraftingInventory craftingInv, boolean generatePattern) {
        ItemStack targetA = null;
        ItemStack targetB = null;
        for (int x = 0; x < craftingInv.func_70302_i_(); ++x) {
            ItemStack f = craftingInv.func_70301_a(x);
            if (f.func_190926_b()) continue;
            if (f.func_77973_b() instanceof ItemNegativePrint) {
                if (((ItemNegativePrint)ModItems.ITEM_NEGATIVE_PRINT.get()).isWritten(f)) {
                    if (targetA != null) {
                        return null;
                    }
                    targetA = f;
                    continue;
                }
                if (targetB != null) {
                    return null;
                }
                targetB = f;
                continue;
            }
            if (ModUtil.isEmpty(f)) continue;
            return null;
        }
        if (targetA != null && targetB != null) {
            if (generatePattern) {
                return targetA;
            }
            NBTBlobConverter tmp = new NBTBlobConverter();
            tmp.readChisleData(targetA.func_77978_p(), -1);
            VoxelBlob bestBlob = tmp.getBlob();
            bestBlob.binaryReplacement(ModUtil.getStateId(Blocks.field_150348_b.func_176223_P()), 0);
            tmp.setBlob(bestBlob);
            CompoundNBT comp = ModUtil.getTagCompound(targetA).func_74737_b();
            tmp.writeChisleData(comp, false);
            ItemStack outputPattern = new ItemStack((IItemProvider)targetA.func_77973_b());
            outputPattern.func_77982_d(comp);
            return outputPattern;
        }
        return null;
    }

    public ItemStack getCraftingResult(CraftingInventory craftingInv) {
        return this.analzyeCraftingInventory(craftingInv, false);
    }

    public boolean func_194133_a(int width, int height) {
        return width > 1 || height > 1;
    }

    public ItemStack func_77571_b() {
        return ModUtil.getEmptyStack();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory craftingInv) {
        NonNullList aitemstack = NonNullList.func_191197_a((int)craftingInv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < aitemstack.size(); ++i) {
            ItemStack itemstack = craftingInv.func_70301_a(i);
            if (itemstack == null || itemstack.func_77973_b() != ModItems.ITEM_NEGATIVE_PRINT_WRITTEN.get() || !itemstack.func_77942_o()) continue;
            ModUtil.adjustStackSize(itemstack, 1);
        }
        return aitemstack;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipeSerializers.NEGATIVE_INVERSION_CRAFTING.get();
    }
}

